/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft.control;

import binnie.core.BinnieCore;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.CraftGUI;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.Widget;
import binnie.craftgui.core.geometry.IPoint;
import binnie.craftgui.minecraft.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ControlItemDisplay
extends Control
implements ITooltip {
    private ItemStack itemStack = null;
    public boolean hastooltip = false;
    private boolean rotating = false;

    public void setTooltip() {
        this.hastooltip = true;
        this.addAttribute(Attribute.MouseOver);
    }

    public ControlItemDisplay(IWidget parent, float x, float y) {
        this(parent, x, y, 16.0f);
    }

    public ControlItemDisplay(IWidget parent, float f, float y, ItemStack stack, boolean tooltip) {
        this(parent, f, y, 16.0f);
        this.setItemStack(stack);
        if (tooltip) {
            this.setTooltip();
        }
    }

    public ControlItemDisplay(IWidget parent, float x, float y, float size) {
        super(parent, x, y, size, size);
    }

    @Override
    public void onRenderBackground() {
        IPoint relativeToWindow = this.getAbsolutePosition().sub(this.getSuperParent().getPosition());
        if (relativeToWindow.x() > ((Widget)Window.get(this)).getSize().x() + 100.0f || relativeToWindow.y() > ((Widget)Window.get(this)).getSize().y() + 100.0f) {
            return;
        }
        if (this.itemStack != null) {
            if (this.getSize().x() != 16.0f) {
                GL11.glPushMatrix();
                float scale = this.getSize().x() / 16.0f;
                GL11.glScalef((float)scale, (float)scale, (float)1.0f);
                BinnieCore.proxy.getMinecraftInstance();
                float phase = (float)Minecraft.func_71386_F() / 20.0f;
                CraftGUI.Render.item(IPoint.ZERO, this.itemStack, this.rotating);
                GL11.glPopMatrix();
            } else {
                CraftGUI.Render.item(IPoint.ZERO, this.itemStack, this.rotating);
            }
        }
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        if (this.hastooltip && this.itemStack != null) {
            tooltip.add(this.itemStack.func_82840_a(((Window)this.getSuperParent()).getPlayer(), false));
        }
        super.getTooltip(tooltip);
    }

    public void setRotating() {
        this.rotating = true;
    }
}

