/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.network;

import binnie.core.BinnieCore;
import binnie.core.block.TileEntityMetadata;
import binnie.core.machines.IMachine;
import binnie.core.machines.Machine;
import binnie.core.machines.network.INetwork;
import binnie.core.network.INetworkedEntity;
import binnie.core.network.IPacketID;
import binnie.core.network.packet.MessageBinnie;
import binnie.core.network.packet.MessageCraftGUI;
import binnie.core.network.packet.MessageMetadata;
import binnie.core.network.packet.MessageTileNBT;
import binnie.core.network.packet.MessageUpdate;
import binnie.craftgui.minecraft.ContainerCraftGUI;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;

public enum BinnieCorePacketID implements IPacketID
{
    NetworkEntityUpdate,
    TileMetadata,
    CraftGUIAction,
    TileDescriptionSync;


    @Override
    public void onMessage(MessageBinnie message, MessageContext context) {
        IMachine machine;
        MessageTileNBT packet;
        TileEntity tile;
        if (this == NetworkEntityUpdate) {
            MessageUpdate packet2 = new MessageUpdate(message);
            TileEntity tile2 = packet2.getTileEntity(BinnieCore.proxy.getWorld());
            if (tile2 instanceof INetworkedEntity) {
                ((INetworkedEntity)tile2).readFromPacket(packet2.payload);
            }
        } else if (this == TileMetadata) {
            MessageMetadata packet3 = new MessageMetadata(message);
            TileEntity tile3 = packet3.getTileEntity(BinnieCore.proxy.getWorld());
            if (tile3 instanceof TileEntityMetadata) {
                ((TileEntityMetadata)tile3).setTileMetadata(packet3.meta, true);
            }
        } else if (this == CraftGUIAction && context.side == Side.CLIENT) {
            MessageCraftGUI packet4 = new MessageCraftGUI(message);
            EntityPlayer player = BinnieCore.proxy.getPlayer();
            if (player.field_71070_bA instanceof ContainerCraftGUI && packet4.getTagCompound() != null) {
                ((ContainerCraftGUI)player.field_71070_bA).recieveNBT(Side.CLIENT, player, packet4.getTagCompound());
            }
        } else if (this == CraftGUIAction && context.side == Side.SERVER && context.netHandler instanceof NetHandlerPlayServer) {
            MessageCraftGUI packet5 = new MessageCraftGUI(message);
            EntityPlayerMP player = ((NetHandlerPlayServer)context.netHandler).field_147369_b;
            if (player.field_71070_bA instanceof ContainerCraftGUI && packet5.getTagCompound() != null) {
                ((ContainerCraftGUI)player.field_71070_bA).recieveNBT(Side.SERVER, (EntityPlayer)player, packet5.getTagCompound());
            }
        } else if (this == TileDescriptionSync && context.side == Side.CLIENT && (tile = (packet = new MessageTileNBT(message)).getTarget(BinnieCore.proxy.getWorld())) != null && packet.getTagCompound() != null && (machine = Machine.getMachine(tile)) != null && machine instanceof INetwork.TilePacketSync) {
            ((INetwork.TilePacketSync)((Object)machine)).syncFromNBT(packet.getTagCompound());
        }
    }
}

