/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.power;

import binnie.core.machines.power.IProcess;
import binnie.core.machines.power.IProcessTimed;
import forestry.api.core.INBTTagable;
import net.minecraft.nbt.NBTTagCompound;

public class ProcessInfo
implements INBTTagable {
    private float currentProgress = 0.0f;
    private int processEnergy = 0;
    private int processTime = 0;
    private float energyPerTick = 0.0f;

    public ProcessInfo(IProcess process) {
        this.energyPerTick = process.getEnergyPerTick();
        if (process instanceof IProcessTimed) {
            IProcessTimed time = (IProcessTimed)process;
            this.currentProgress = time.getProgress();
            this.processEnergy = time.getProcessEnergy();
            this.processTime = time.getProcessLength();
        } else {
            this.currentProgress = process.isInProgress() ? 100.0f : 0.0f;
        }
    }

    public ProcessInfo() {
    }

    public float getCurrentProgress() {
        return this.currentProgress;
    }

    public int getProcessEnergy() {
        return this.processEnergy;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public float getEnergyPerTick() {
        return this.energyPerTick;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.energyPerTick = nbttagcompound.func_74760_g("ept");
        this.processEnergy = nbttagcompound.func_74762_e("e");
        this.processTime = nbttagcompound.func_74762_e("t");
        this.currentProgress = nbttagcompound.func_74760_g("p");
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74776_a("ept", this.energyPerTick);
        nbttagcompound.func_74776_a("p", this.currentProgress);
        nbttagcompound.func_74768_a("e", this.processEnergy);
        nbttagcompound.func_74768_a("t", this.processTime);
    }
}

