/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.machines.inventory.BaseSlot;
import binnie.core.machines.inventory.SlotValidator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class InventorySlot
extends BaseSlot<ItemStack> {
    private ItemStack itemStack = null;
    private Type type = Type.Standard;

    public InventorySlot(int index, String unlocName) {
        super(index, unlocName);
    }

    @Override
    public ItemStack getContent() {
        return this.itemStack;
    }

    public ItemStack getItemStack() {
        return this.getContent();
    }

    @Override
    public void setContent(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public ItemStack decrStackSize(int amount) {
        if (this.itemStack == null) {
            return null;
        }
        if (this.itemStack.field_77994_a <= amount) {
            ItemStack returnStack = this.itemStack.func_77946_l();
            this.itemStack = null;
            return returnStack;
        }
        ItemStack returnStack = this.itemStack.func_77946_l();
        this.itemStack.field_77994_a -= amount;
        returnStack.field_77994_a = amount;
        return returnStack;
    }

    public void readFromNBT(NBTTagCompound slotNBT) {
        if (slotNBT.func_74764_b("item")) {
            NBTTagCompound itemNBT = slotNBT.func_74775_l("item");
            this.itemStack = ItemStack.func_77949_a((NBTTagCompound)itemNBT);
        } else {
            this.itemStack = null;
        }
    }

    public void writeToNBT(NBTTagCompound slotNBT) {
        NBTTagCompound itemNBT = new NBTTagCompound();
        if (this.itemStack != null) {
            this.itemStack.func_77955_b(itemNBT);
        }
        slotNBT.func_74782_a("item", (NBTBase)itemNBT);
    }

    public void setItemStack(ItemStack duplicate) {
        this.setContent(duplicate);
    }

    public SlotValidator getValidator() {
        return (SlotValidator)this.validator;
    }

    public void setType(Type type) {
        this.type = type;
        if (type == Type.Recipe) {
            this.setReadOnly();
            this.forbidInteraction();
        }
    }

    public Type getType() {
        return this.type;
    }

    public boolean isRecipe() {
        return this.type == Type.Recipe;
    }

    @Override
    public String getName() {
        return Binnie.Language.localise(BinnieCore.instance, "gui.slot." + this.unlocName);
    }

    public static enum Type {
        Standard,
        Recipe;

    }
}

