/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

enum AccessDirection {
    Both,
    In,
    Out,
    Neither;


    boolean canInsert() {
        return this == Both || this == In;
    }

    boolean canExtract() {
        return this == Both || this == Out;
    }

    boolean canAccess() {
        return this != Neither;
    }

    AccessDirection changeInsert(boolean b) {
        if (b) {
            if (this == Out) {
                return Both;
            }
            if (this == Neither) {
                return In;
            }
        } else {
            if (this == Both) {
                return Out;
            }
            if (this == In) {
                return Neither;
            }
        }
        return this;
    }

    AccessDirection changeExtract(boolean b) {
        if (b) {
            if (this == In) {
                return Both;
            }
            if (this == Neither) {
                return Out;
            }
        } else {
            if (this == Both) {
                return In;
            }
            if (this == Out) {
                return Neither;
            }
        }
        return this;
    }

    public String getTextColour() {
        switch (this) {
            case Both: {
                return "\u00a7a";
            }
            case In: {
                return "\u00a7e";
            }
            case Neither: {
                return "\u00a7c";
            }
        }
        return "\u00a7b";
    }

    public int getShadeColour() {
        switch (this) {
            case Both: {
                return 0x5555FF55;
            }
            case In: {
                return 0x55FFFF55;
            }
            case Neither: {
                return 0x55FF5555;
            }
        }
        return 0x5555FFFF;
    }
}

