/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.gardening;

import binnie.Binnie;
import binnie.botany.Botany;
import binnie.botany.CreativeTabBotany;
import binnie.botany.api.EnumAcidity;
import binnie.botany.api.EnumMoisture;
import binnie.botany.api.EnumSoilType;
import binnie.botany.api.gardening.IBlockSoil;
import binnie.botany.gardening.BlockPlant;
import binnie.botany.gardening.Gardening;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSoil
extends Block
implements IBlockSoil {
    boolean weedKilled = false;
    IIcon[] iconsTop = new IIcon[9];
    IIcon[] iconsSide = new IIcon[9];
    IIcon[] iconsNoWeed = new IIcon[9];
    EnumSoilType type;

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < 9; ++i) {
            par3List.add(new ItemStack((Block)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_149691_a(side, world.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        meta = meta >= 9 ? 8 : meta;
        EnumMoisture moisture = EnumMoisture.values()[meta % 3];
        EnumAcidity acidity = EnumAcidity.values()[meta / 3];
        return side == 1 ? (this.weedKilled ? this.iconsNoWeed[meta] : this.iconsTop[meta]) : (side == 0 ? Blocks.field_150346_d.func_149691_a(side, 0) : this.iconsSide[meta]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        for (EnumMoisture moisture : EnumMoisture.values()) {
            for (EnumAcidity pH : EnumAcidity.values()) {
                this.iconsTop[moisture.ordinal() + pH.ordinal() * 3] = Botany.proxy.getIcon(register, "soil/" + this.getType().getID() + "." + pH.getID() + "." + moisture.getID() + ".0");
                this.iconsSide[moisture.ordinal() + pH.ordinal() * 3] = Botany.proxy.getIcon(register, "soil/" + this.getType().getID() + "." + pH.getID() + "." + moisture.getID() + ".1");
                this.iconsNoWeed[moisture.ordinal() + pH.ordinal() * 3] = Botany.proxy.getIcon(register, "soil/" + this.getType().getID() + "." + pH.getID() + "." + moisture.getID() + ".2");
            }
        }
    }

    public EnumSoilType getType() {
        return this.type;
    }

    public BlockSoil(EnumSoilType type, String blockName, boolean weedKilled) {
        super(Material.field_151578_c);
        this.weedKilled = weedKilled;
        this.func_149647_a(CreativeTabBotany.instance);
        this.func_149663_c(blockName);
        this.func_149675_a(true);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
        this.func_149713_g(255);
        this.func_149711_c(0.5f);
        this.func_149672_a(field_149767_g);
        this.type = type;
    }

    public int func_149692_a(int p_149692_1_) {
        return p_149692_1_;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        int meta2;
        int meta = world.func_72805_g(x, y, z);
        EnumMoisture moisture = EnumMoisture.values()[meta % 3];
        EnumAcidity acidity = EnumAcidity.values()[meta / 3];
        EnumMoisture desiredMoisture = Gardening.getNaturalMoisture(world, x, y, z);
        if (desiredMoisture.ordinal() > moisture.ordinal()) {
            EnumMoisture enumMoisture = moisture = moisture == EnumMoisture.Dry ? EnumMoisture.Normal : EnumMoisture.Damp;
        }
        if (desiredMoisture.ordinal() < moisture.ordinal()) {
            EnumMoisture enumMoisture = moisture = moisture == EnumMoisture.Damp ? EnumMoisture.Normal : EnumMoisture.Dry;
        }
        if (meta != (meta2 = BlockSoil.getMeta(acidity, moisture))) {
            world.func_72921_c(x, y, z, meta2, 2);
        }
        if (!this.weedKilled && random.nextInt(5 - this.getType(world, x, y, z).ordinal()) == 0 && world.func_147439_a(x, y + 1, z) == Blocks.field_150350_a) {
            world.func_147465_d(x, y + 1, z, (Block)Botany.plant, BlockPlant.Type.Weeds.ordinal(), 2);
        }
    }

    public AxisAlignedBB func_149668_a(World p_149668_1_, int p_149668_2_, int p_149668_3_, int p_149668_4_) {
        return AxisAlignedBB.func_72330_a((double)(p_149668_2_ + 0), (double)(p_149668_3_ + 0), (double)(p_149668_4_ + 0), (double)(p_149668_2_ + 1), (double)(p_149668_3_ + 1), (double)(p_149668_4_ + 1));
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public EnumAcidity getPH(World world, int x, int y, int z) {
        return EnumAcidity.values()[world.func_72805_g(x, y, z) / 3];
    }

    @Override
    public EnumMoisture getMoisture(World world, int x, int y, int z) {
        return EnumMoisture.values()[world.func_72805_g(x, y, z) % 3];
    }

    @Override
    public EnumSoilType getType(World world, int x, int y, int z) {
        return this.type;
    }

    @Override
    public boolean fertilise(World world, int x, int y, int z, EnumSoilType maxLevel) {
        EnumSoilType type = this.getType(world, x, y, z);
        if (type.ordinal() >= maxLevel.ordinal()) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        return world.func_147465_d(x, y, z, Gardening.getSoilBlock(maxLevel, this.weedKilled), meta, 2);
    }

    @Override
    public boolean degrade(World world, int x, int y, int z, EnumSoilType minLevel) {
        EnumSoilType type = this.getType(world, x, y, z);
        if (type.ordinal() <= minLevel.ordinal()) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        return world.func_147465_d(x, y, z, Gardening.getSoilBlock(minLevel, this.weedKilled), meta, 2);
    }

    @Override
    public boolean setPH(World world, int x, int y, int z, EnumAcidity pH) {
        int meta = BlockSoil.getMeta(pH, this.getMoisture(world, x, y, z));
        return world.func_72921_c(x, y, z, meta, 2);
    }

    @Override
    public boolean setMoisture(World world, int x, int y, int z, EnumMoisture moisture) {
        int meta = BlockSoil.getMeta(this.getPH(world, x, y, z), moisture);
        return world.func_72921_c(x, y, z, meta, 2);
    }

    public static int getMeta(EnumAcidity acid, EnumMoisture moisture) {
        return acid.ordinal() * 3 + moisture.ordinal();
    }

    public void func_149695_a(World world, int x, int y, int z, Block p_149695_5_) {
        super.func_149695_a(world, x, y, z, p_149695_5_);
        if (world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN, false)) {
            world.func_147465_d(x, y, z, Blocks.field_150346_d, 0, 2);
        }
    }

    public static String getPH(ItemStack stack) {
        return Binnie.Language.localise((Object)EnumAcidity.values()[stack.func_77960_j() / 3]);
    }

    public static String getMoisture(ItemStack stack) {
        return Binnie.Language.localise((Object)EnumMoisture.values()[stack.func_77960_j() % 3]);
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        Block plant = plantable.getPlant(world, x, y + 1, z);
        if (plant == Botany.flower) {
            return true;
        }
        if (plant == Botany.plant) {
            return !this.weedKilled || !BlockPlant.isWeed(world, x, y, z);
        }
        if (!(world instanceof World)) {
            return false;
        }
        return Blocks.field_150346_d.canSustainPlant(world, x, y, z, direction, plantable);
    }

    @Override
    public boolean resistsWeeds(World world, int x, int y, int z) {
        return this.weedKilled;
    }
}

