/*
 * Decompiled with CFR 0.152.
 */
package extracells.network.packet.part;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.container.ContainerFluidStorage;
import extracells.container.ContainerGasStorage;
import extracells.gui.GuiFluidStorage;
import extracells.gui.GuiGasStorage;
import extracells.integration.Integration;
import extracells.network.AbstractPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class PacketFluidStorage
extends AbstractPacket {
    private IItemList<IAEFluidStack> fluidStackList;
    private Fluid currentFluid;
    private boolean hasTermHandler;

    public PacketFluidStorage() {
    }

    public PacketFluidStorage(EntityPlayer _player) {
        super(_player);
        this.mode = (byte)2;
    }

    public PacketFluidStorage(EntityPlayer _player, boolean _hasTermHandler) {
        super(_player);
        this.mode = (byte)3;
        this.hasTermHandler = _hasTermHandler;
    }

    public PacketFluidStorage(EntityPlayer _player, Fluid _currentFluid) {
        super(_player);
        this.mode = 1;
        this.currentFluid = _currentFluid;
    }

    public PacketFluidStorage(EntityPlayer _player, IItemList<IAEFluidStack> _list) {
        super(_player);
        this.mode = 0;
        this.fluidStackList = _list;
    }

    @Override
    public void execute() {
        switch (this.mode) {
            case 0: {
                this.case0();
                break;
            }
            case 1: {
                if (this.player != null && this.player.field_71070_bA instanceof ContainerFluidStorage) {
                    ((ContainerFluidStorage)this.player.field_71070_bA).receiveSelectedFluid(this.currentFluid);
                    break;
                }
                if (this.player == null || !Integration.Mods.MEKANISMGAS.isEnabled() || !(this.player.field_71070_bA instanceof ContainerGasStorage)) break;
                ((ContainerGasStorage)this.player.field_71070_bA).receiveSelectedFluid(this.currentFluid);
                break;
            }
            case 2: {
                if (this.player == null || this.player.field_70170_p.field_72995_K) break;
                if (this.player.field_71070_bA instanceof ContainerFluidStorage) {
                    ((ContainerFluidStorage)this.player.field_71070_bA).forceFluidUpdate();
                    ((ContainerFluidStorage)this.player.field_71070_bA).doWork();
                    break;
                }
                if (!(this.player.field_71070_bA instanceof ContainerGasStorage) || !Integration.Mods.MEKANISMGAS.isEnabled()) break;
                ((ContainerGasStorage)this.player.field_71070_bA).forceFluidUpdate();
                ((ContainerGasStorage)this.player.field_71070_bA).doWork();
                break;
            }
            case 3: {
                this.case3();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void case0() {
        if (this.player != null && this.player.func_70613_aW()) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui instanceof GuiFluidStorage) {
                ContainerFluidStorage container = (ContainerFluidStorage)((GuiFluidStorage)gui).field_147002_h;
                container.updateFluidList(this.fluidStackList);
            } else if (gui instanceof GuiGasStorage && Integration.Mods.MEKANISMGAS.isEnabled()) {
                ContainerGasStorage container = (ContainerGasStorage)((GuiGasStorage)gui).field_147002_h;
                container.updateFluidList(this.fluidStackList);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void case3() {
        if (this.player != null && this.player.func_70613_aW()) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui instanceof GuiFluidStorage) {
                ContainerFluidStorage container = (ContainerFluidStorage)((GuiFluidStorage)gui).field_147002_h;
                container.hasWirelessTermHandler = this.hasTermHandler;
            } else if (gui instanceof GuiGasStorage && Integration.Mods.MEKANISMGAS.isEnabled()) {
                ContainerGasStorage container = (ContainerGasStorage)((GuiGasStorage)gui).field_147002_h;
                container.hasWirelessTermHandler = this.hasTermHandler;
            }
        }
    }

    @Override
    public void readData(ByteBuf in) {
        switch (this.mode) {
            case 0: {
                this.fluidStackList = AEApi.instance().storage().createFluidList();
                while (in.readableBytes() > 0) {
                    Fluid fluid = PacketFluidStorage.readFluid(in);
                    long fluidAmount = in.readLong();
                    if (fluid == null) continue;
                    IAEFluidStack stack = AEApi.instance().storage().createFluidStack(new FluidStack(fluid, 1));
                    stack.setStackSize(fluidAmount);
                    this.fluidStackList.add((IAEStack)stack);
                }
                break;
            }
            case 1: {
                this.currentFluid = PacketFluidStorage.readFluid(in);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.hasTermHandler = in.readBoolean();
            }
        }
    }

    @Override
    public void writeData(ByteBuf out) {
        switch (this.mode) {
            case 0: {
                for (IAEFluidStack stack : this.fluidStackList) {
                    FluidStack fluidStack = stack.getFluidStack();
                    PacketFluidStorage.writeFluid(fluidStack.getFluid(), out);
                    out.writeLong((long)fluidStack.amount);
                }
                break;
            }
            case 1: {
                PacketFluidStorage.writeFluid(this.currentFluid, out);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                out.writeBoolean(this.hasTermHandler);
            }
        }
    }
}

