/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.tile;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.lib.util.helpers.EnergyHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.endertech.EnderTech;
import io.endertech.block.BlockPad;
import io.endertech.config.GeneralConfig;
import io.endertech.network.PacketETBase;
import io.endertech.tile.TileInventory;
import io.endertech.util.IChargeableFromSlot;
import io.endertech.util.IOutlineDrawer;
import io.endertech.util.RGBA;
import io.endertech.util.helper.LocalisationHelper;
import io.endertech.util.helper.NBTHelper;
import io.endertech.util.helper.RenderHelper;
import java.awt.Color;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TilePad
extends TileInventory
implements IReconfigurableFacing,
IEnergyHandler,
IOutlineDrawer,
IChargeableFromSlot {
    public static final short TICKS_PER_UPDATE = 20;
    public static final int INVENTORY_SIZE = 1;
    public short ticksSinceLastUpdate = 0;
    public boolean isActive = false;
    public int storedEnergy = 0;
    public boolean isCreative = false;

    public TilePad() {
        this.inventory = new ItemStack[1];
    }

    @Override
    public String getName() {
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int blockMeta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return LocalisationHelper.localiseString(block.func_149739_a() + "." + blockMeta + ".name", new Object[0]);
    }

    public static void writeDefaultTag(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74768_a("Energy", 0);
        NBTHelper.writeInventoryToNBT(nbtTagCompound, new ItemStack[1]);
    }

    @Override
    public int getFacing() {
        return this.getOrientation().ordinal();
    }

    @Override
    public boolean allowYAxisFacing() {
        return true;
    }

    @Override
    public boolean rotateBlock() {
        int orientation = this.getFacing();
        if (++orientation >= ForgeDirection.VALID_DIRECTIONS.length) {
            orientation = 0;
        }
        return this.setFacing(orientation);
    }

    @Override
    public boolean setFacing(int side) {
        if (side == this.getOrientation().ordinal()) {
            return false;
        }
        this.setOrientation(side);
        this.sendDescriptionPacket();
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        boolean canReceive;
        boolean bl = canReceive = from != this.getOrientation();
        if (!canReceive) {
            return 0;
        }
        return this.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, int meta, boolean simulate) {
        int energyExtracted = Math.min(this.storedEnergy, Math.min(this.getMaxSendRate(meta), maxExtract));
        if (!simulate) {
            this.storedEnergy -= energyExtracted;
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storedEnergy;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        int blockMeta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.getMaxEnergyStored(blockMeta);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != this.getOrientation();
    }

    @Override
    public boolean hasItemState() {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.readStateFromNBT(nbtTagCompound);
    }

    @Override
    public void readStateFromNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("Energy")) {
            this.storedEnergy = nbtTagCompound.func_74762_e("Energy");
        }
        if (nbtTagCompound.func_74764_b("Inventory")) {
            this.inventory = NBTHelper.readInventoryFromNBT(nbtTagCompound, 1);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        this.writeStateToNBT(nbtTagCompound);
    }

    @Override
    public void writeStateToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74768_a("Energy", this.storedEnergy);
        NBTHelper.writeInventoryToNBT(nbtTagCompound, this.inventory);
    }

    @Override
    public PacketETBase getPacket() {
        PacketETBase packet = super.getPacket();
        packet.addBool(this.isActive);
        packet.addInt(this.storedEnergy);
        packet.addInventory(this.inventory);
        return packet;
    }

    @Override
    public void handleTilePacket(PacketETBase tilePacket, boolean isServer) {
        super.handleTilePacket(tilePacket, isServer);
        boolean isActive = tilePacket.getBool();
        int storedEnergy = tilePacket.getInt();
        ItemStack[] inventory = tilePacket.getInventory(1);
        if (!isServer) {
            this.isActive = isActive;
            this.storedEnergy = storedEnergy;
            this.inventory = inventory;
        }
    }

    public AxisAlignedBB getAABBInFront(int distance) {
        ForgeDirection orientation = this.getOrientation();
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b((double)(Math.abs(orientation.offsetX) * (distance - 1)), (double)(Math.abs(orientation.offsetY) * (distance - 1)), (double)(Math.abs(orientation.offsetZ) * (distance - 1))).func_72317_d((double)orientation.offsetX, (double)orientation.offsetY, (double)orientation.offsetZ);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int getChargeSlot() {
        return this.inventory.length - 1;
    }

    @Override
    public boolean hasChargeSlot() {
        return true;
    }

    @Override
    public void chargeFromGUISlot() {
        if (this.isCreative) {
            return;
        }
        int chargeSlot = this.getChargeSlot();
        ItemStack chargeItemStack = this.inventory[chargeSlot];
        if (!this.hasChargeSlot() || !EnergyHelper.isEnergyContainerItem(chargeItemStack)) {
            return;
        }
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int chargeAmount = Math.min(this.getMaxReceiveRate(meta), this.getMaxEnergyStored(meta) - this.getEnergyStored());
        IEnergyContainerItem energyContainerItem = (IEnergyContainerItem)chargeItemStack.func_77973_b();
        if (energyContainerItem == null) {
            return;
        }
        int extractedAmount = energyContainerItem.extractEnergy(chargeItemStack, chargeAmount, false);
        this.receiveEnergy(extractedAmount, false);
        if (chargeItemStack.field_77994_a <= 0) {
            this.inventory[chargeSlot] = null;
        }
    }

    @Override
    public boolean drawOutline(DrawBlockHighlightEvent event) {
        if (GeneralConfig.debugRender) {
            AxisAlignedBB front = this.getAABBInFront(2);
            RenderHelper.renderAABBOutline(event.context, event.player, front, RGBA.Red.setAlpha(0.6f), 2.0f, event.partialTicks);
            return true;
        }
        return false;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored() {
        return this.storedEnergy;
    }

    @SideOnly(value=Side.CLIENT)
    protected float[] getRainbowParticleColour(Random rand) {
        float hue = rand.nextFloat();
        float saturation = 0.9f;
        float luminance = 1.0f;
        Color color = Color.getHSBColor(hue, 0.9f, 1.0f);
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getBlue() / 255.0f;
        float b = (float)color.getGreen() / 255.0f;
        return new float[]{r, g, b};
    }

    protected boolean isItemInChargeSlotTuberous() {
        int slot = this.getChargeSlot();
        ItemStack itemStack = this.inventory[slot];
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return false;
        }
        return item == EnderTech.capacitor && itemStack.func_77960_j() == 1;
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.isCreative) {
            return 0;
        }
        int blockMeta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int energyReceived = Math.min(this.getMaxEnergyStored(blockMeta) - this.storedEnergy, Math.min(this.getMaxReceiveRate(blockMeta), maxReceive));
        if (!simulate) {
            this.storedEnergy += energyReceived;
        }
        return energyReceived;
    }

    @Override
    public int getMaxEnergyStored() {
        int blockMeta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.getMaxEnergyStored(blockMeta);
    }

    public IIcon getFrontIcon() {
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!(block instanceof BlockPad)) {
            return null;
        }
        int blockMeta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        BlockPad blockPad = (BlockPad)block;
        if (this.isActive) {
            return blockPad.getActiveIcon(blockMeta);
        }
        return blockPad.getInactiveIcon(blockMeta);
    }

    public double calculateEfficiencyForEntity(Entity entity) {
        double xDiff = Math.abs(((double)this.field_145851_c + 0.5 - entity.field_70165_t) * (double)this.orientation.offsetX);
        double yDiff = Math.abs(((double)this.field_145848_d + 0.5 - entity.field_70163_u) * (double)this.orientation.offsetY);
        double zDiff = Math.abs(((double)this.field_145849_e + 0.5 - entity.field_70161_v) * (double)this.orientation.offsetZ);
        double distance = xDiff + yDiff + zDiff - 0.5;
        if (this.orientation == ForgeDirection.DOWN) {
            distance -= 1.5;
        }
        if (distance < 0.3) {
            distance = 0.0;
        }
        if (distance > 1.5) {
            distance = 1.5;
        }
        double efficiency = (2.0 - distance) / 2.0;
        if (distance < 0.9) {
            efficiency += 0.2;
        }
        efficiency = Math.max(0.5, efficiency);
        efficiency = Math.min(1.0, efficiency);
        return efficiency;
    }

    public abstract int getMaxEnergyStored(int var1);

    public abstract int getMaxReceiveRate(int var1);

    public abstract int getMaxSendRate(int var1);

    @SideOnly(value=Side.CLIENT)
    public abstract void spawnParticles(int var1);

    @SideOnly(value=Side.CLIENT)
    public abstract float[] getParticleColour(Random var1);

    @SideOnly(value=Side.CLIENT)
    public abstract int getParticleMaxAge();

    @SideOnly(value=Side.CLIENT)
    public abstract double[] getParticleVelocity();

    @SideOnly(value=Side.CLIENT)
    public abstract int getParticleCount(int var1);

    @SideOnly(value=Side.CLIENT)
    public abstract float getParticleSizeModifier(int var1);
}

