/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.multiblock.rectangular;

import io.endertech.multiblock.MultiblockControllerBase;
import io.endertech.multiblock.MultiblockTileEntityBase;
import io.endertech.multiblock.MultiblockValidationException;
import io.endertech.multiblock.rectangular.PartPosition;
import io.endertech.util.BlockCoord;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class RectangularMultiblockTileEntityBase
extends MultiblockTileEntityBase {
    PartPosition position = PartPosition.Unknown;
    Set<ForgeDirection> outwards = new HashSet<ForgeDirection>();

    public Set<ForgeDirection> getOutwardsDir() {
        return this.outwards;
    }

    public ForgeDirection getFirstOutwardsDir() {
        if (this.outwards == null || this.outwards.isEmpty()) {
            return null;
        }
        return this.outwards.iterator().next();
    }

    public PartPosition getPartPosition() {
        return this.position;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        super.onAttached(newController);
        this.recalculateOutwardsDirection(newController.getMinimumCoord(), newController.getMaximumCoord());
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        BlockCoord maxCoord = controller.getMaximumCoord();
        BlockCoord minCoord = controller.getMinimumCoord();
        this.recalculateOutwardsDirection(minCoord, maxCoord);
    }

    @Override
    public void onMachineBroken() {
        this.position = PartPosition.Unknown;
        this.outwards = new HashSet<ForgeDirection>();
    }

    private boolean isOnBottomFace(BlockCoord minCoord, BlockCoord coord) {
        return minCoord.y == coord.y;
    }

    private boolean isOnTopFace(BlockCoord maxCoord, BlockCoord coord) {
        return maxCoord.y == coord.y;
    }

    private boolean isOnWestFace(BlockCoord minCoord, BlockCoord coord) {
        return minCoord.x == coord.x;
    }

    private boolean isOnEastFace(BlockCoord maxCoord, BlockCoord coord) {
        return maxCoord.x == coord.x;
    }

    private boolean isOnFrontFace(BlockCoord minCoord, BlockCoord coord) {
        return minCoord.z == coord.z;
    }

    private boolean isOnBackFace(BlockCoord maxCoord, BlockCoord coord) {
        return maxCoord.z == coord.z;
    }

    public void recalculateOutwardsDirection(BlockCoord minCoord, BlockCoord maxCoord) {
        this.position = PartPosition.Unknown;
        BlockCoord coord = new BlockCoord(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int facesMatching = 0;
        if (maxCoord.x == coord.x || minCoord.x == coord.x) {
            ++facesMatching;
        }
        if (maxCoord.y == coord.y || minCoord.y == coord.y) {
            ++facesMatching;
        }
        if (maxCoord.z == coord.z || minCoord.z == coord.z) {
            ++facesMatching;
        }
        this.position = facesMatching <= 0 ? PartPosition.Interior : (facesMatching >= 3 ? PartPosition.FrameCorner : (facesMatching == 2 ? PartPosition.Frame : (maxCoord.x == this.field_145851_c ? PartPosition.EastFace : (minCoord.x == this.field_145851_c ? PartPosition.WestFace : (maxCoord.z == this.field_145849_e ? PartPosition.SouthFace : (minCoord.z == this.field_145849_e ? PartPosition.NorthFace : (maxCoord.y == this.field_145848_d ? PartPosition.TopFace : PartPosition.BottomFace)))))));
        if (this.isOnTopFace(maxCoord, coord)) {
            this.outwards.add(ForgeDirection.UP);
        }
        if (this.isOnBottomFace(minCoord, coord)) {
            this.outwards.add(ForgeDirection.DOWN);
        }
        if (this.isOnEastFace(maxCoord, coord)) {
            this.outwards.add(ForgeDirection.EAST);
        }
        if (this.isOnWestFace(minCoord, coord)) {
            this.outwards.add(ForgeDirection.WEST);
        }
        if (this.isOnFrontFace(maxCoord, coord)) {
            this.outwards.add(ForgeDirection.SOUTH);
        }
        if (this.isOnBackFace(minCoord, coord)) {
            this.outwards.add(ForgeDirection.NORTH);
        }
    }

    public abstract void isGoodForFrame() throws MultiblockValidationException;

    public abstract void isGoodForSides() throws MultiblockValidationException;

    public abstract void isGoodForTop() throws MultiblockValidationException;

    public abstract void isGoodForBottom() throws MultiblockValidationException;

    public abstract void isGoodForInterior() throws MultiblockValidationException;
}

