/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world.feature;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.world.feature.FeatureBase;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fluids.Fluid;

public class FeatureGenUnderfluid
extends FeatureBase {
    final boolean water;
    final WorldGenerator worldGen;
    final int count;
    final List<WeightedRandomBlock> matList;
    final int[] fluidList;

    public FeatureGenUnderfluid(String name, WorldGenerator worldGen, List<WeightedRandomBlock> matList, int count, FeatureBase.GenRestriction biomeRes, boolean regen, FeatureBase.GenRestriction dimRes) {
        super(name, biomeRes, regen, dimRes);
        this.worldGen = worldGen;
        this.count = count;
        this.matList = matList;
        this.water = true;
        this.fluidList = null;
    }

    public FeatureGenUnderfluid(String name, WorldGenerator worldGen, List<WeightedRandomBlock> matList, int[] fluidList, int count, FeatureBase.GenRestriction biomeRes, boolean regen, FeatureBase.GenRestriction dimRes) {
        super(name, biomeRes, regen, dimRes);
        this.worldGen = worldGen;
        this.count = count;
        this.matList = matList;
        this.water = false;
        Arrays.sort(fluidList);
        this.fluidList = fluidList;
    }

    @Override
    public boolean generateFeature(Random random, int chunkX, int chunkZ, World world) {
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        boolean generated = false;
        for (int i = 0; i < this.count; ++i) {
            int z;
            int x = blockX + random.nextInt(16);
            if (!this.canGenerateInBiome(world, x, z = blockZ + random.nextInt(16), random)) continue;
            int y = BlockHelper.getSurfaceBlockY(world, x, z);
            block1: do {
                Fluid fluid;
                Block block = world.func_147439_a(x, y, z);
                if (this.water ? block.func_149688_o() == Material.field_151586_h || world.func_147439_a(x, y + 1, z).func_149688_o() != Material.field_151586_h : (fluid = FluidHelper.lookupFluidForBlock(block)) != null && Arrays.binarySearch(this.fluidList, fluid.getID()) >= 0 || (fluid = FluidHelper.lookupFluidForBlock(world.func_147439_a(x, y + 1, z))) == null || Arrays.binarySearch(this.fluidList, fluid.getID()) < 0) continue;
                for (WeightedRandomBlock mat : this.matList) {
                    if (!block.isReplaceableOreGen(world, x, y, z, mat.block)) continue;
                    break block1;
                }
            } while (y-- > 1);
            if (y <= 0) continue;
            generated |= this.worldGen.func_76484_a(world, random, x, y, z);
        }
        return generated;
    }
}

