/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world.feature;

import cofh.lib.world.feature.FeatureBase;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class FeatureGenLargeVein
extends FeatureBase {
    final WorldGenerator worldGen;
    final int count;
    final int minY;
    private int veinHeight;
    private int veinDiameter;
    private int verticalDensity;
    private int horizontalDensity;

    public FeatureGenLargeVein(String name, WorldGenerator worldGen, int count, int minY, FeatureBase.GenRestriction biomeRes, boolean regen, FeatureBase.GenRestriction dimRes, int height, int diameter, int vDensity, int hDensity) {
        super(name, biomeRes, regen, dimRes);
        this.worldGen = worldGen;
        this.count = count;
        this.minY = minY;
        this.veinHeight = height;
        this.veinDiameter = diameter;
        this.verticalDensity = vDensity;
        this.horizontalDensity = hDensity;
    }

    public int getDensity(Random rand, int oreDistance, float oreDensity) {
        int i;
        oreDensity = oreDensity * 0.01f * (float)(oreDistance >> 1) + 1.0f;
        int rnd = oreDistance / i;
        int r = 0;
        for (i = (int)oreDensity; i > 0; --i) {
            r += rand.nextInt(rnd);
        }
        return r;
    }

    @Override
    public boolean generateFeature(Random random, int chunkX, int chunkZ, World world) {
        int blockX = chunkX * 16;
        int blockY = this.minY;
        int blockZ = chunkZ * 16;
        Random dRand = new Random(world.func_72905_C());
        long l = dRand.nextLong() / 2L * 2L + 1L;
        long l1 = dRand.nextLong() / 2L * 2L + 1L;
        dRand.setSeed((long)chunkX * l + (long)chunkZ * l1 ^ world.func_72905_C());
        boolean generated = false;
        int i = this.count;
        while (i-- > 0) {
            int x = blockX + this.getDensity(dRand, this.veinDiameter, this.horizontalDensity);
            int y = blockY + this.getDensity(dRand, this.veinHeight, this.verticalDensity);
            int z = blockZ + this.getDensity(dRand, this.veinDiameter, this.horizontalDensity);
            if (!this.canGenerateInBiome(world, x, z, random)) continue;
            generated |= this.worldGen.func_76484_a(world, random, x, y, z);
        }
        return generated;
    }
}

