/*
 * Decompiled with CFR 0.152.
 */
package vswe.production.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import vswe.production.block.BlockTable;
import vswe.production.gui.container.slot.SlotBase;
import vswe.production.gui.container.slot.SlotFuel;
import vswe.production.gui.menu.GuiMenu;
import vswe.production.gui.menu.GuiMenuItem;
import vswe.production.item.Upgrade;
import vswe.production.network.DataReader;
import vswe.production.network.DataWriter;
import vswe.production.network.IBitCount;
import vswe.production.network.LengthCount;
import vswe.production.network.PacketHandler;
import vswe.production.network.PacketId;
import vswe.production.network.data.DataType;
import vswe.production.page.Page;
import vswe.production.page.PageMain;
import vswe.production.page.PageTransfer;
import vswe.production.page.PageUpgrades;
import vswe.production.page.setting.Setting;
import vswe.production.page.setting.Side;
import vswe.production.page.setting.Transfer;
import vswe.production.page.unit.Unit;
import vswe.production.page.unit.UnitCrafting;

public class TileEntityTable
extends TileEntity
implements IInventory,
ISidedInventory,
IFluidHandler {
    private List<Page> pages;
    private Page selectedPage;
    private List<SlotBase> slots;
    private ItemStack[] items;
    private GuiMenu menu;
    private int power;
    public static final int MAX_POWER = 20000;
    private SlotFuel fuelSlot;
    private List<EntityPlayer> players = new ArrayList<EntityPlayer>();
    private int fuelTick = 0;
    private static final int FUEL_DELAY = 5;
    private int moveTick = 0;
    private static final int MOVE_DELAY = 20;
    private boolean lit;
    private boolean lastLit;
    private int slotTick = 0;
    private static final int SLOT_DELAY = 10;
    private int lava;
    public static final int MAX_LAVA = 1000;
    private static final int MAX_LAVA_DRAIN = 30;
    private static final int LAVA_EFFICIENCY = 12;
    private static final int SOLAR_GENERATION = 4;
    private int lastPower;
    private int lastLava;
    private int[][] sideSlots = new int[6][];
    private static final String NBT_ITEMS = "Items";
    private static final String NBT_UNITS = "Units";
    private static final String NBT_SETTINGS = "Settings";
    private static final String NBT_SIDES = "Sides";
    private static final String NBT_INPUT = "Input";
    private static final String NBT_OUTPUT = "Output";
    private static final String NBT_SLOT = "Slot";
    private static final String NBT_POWER = "Power";
    private static final String NBT_LAVA = "LavaLevel";
    private static final int COMPOUND_ID = 10;
    private static final IBitCount GRID_ID_BITS = new LengthCount(4);

    public int getPower() {
        return this.power;
    }

    public void setPower(int power) {
        this.power = power;
    }

    public TileEntityTable() {
        this.pages = new ArrayList<Page>();
        this.pages.add(new PageMain(this, "Main"));
        this.pages.add(new PageTransfer(this, "Transfer"));
        this.pages.add(new PageUpgrades(this, "Upgrades"));
        this.slots = new ArrayList<SlotBase>();
        int id = 0;
        this.fuelSlot = new SlotFuel(this, null, id++, 226, 226);
        this.addSlot(this.fuelSlot);
        for (Page page : this.pages) {
            id = page.createSlots(id);
        }
        this.items = new ItemStack[this.slots.size()];
        this.setSelectedPage(this.pages.get(0));
        this.onUpgradeChange();
    }

    public List<SlotBase> getSlots() {
        return this.slots;
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public Page getSelectedPage() {
        return this.selectedPage;
    }

    public void setSelectedPage(Page selectedPage) {
        this.selectedPage = selectedPage;
    }

    public ItemStack[] getItems() {
        return this.items;
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public PageMain getMainPage() {
        return (PageMain)this.pages.get(0);
    }

    public PageTransfer getTransferPage() {
        return (PageTransfer)this.pages.get(1);
    }

    public PageUpgrades getUpgradePage() {
        return (PageUpgrades)this.pages.get(2);
    }

    public ItemStack func_70301_a(int id) {
        return this.items[id];
    }

    public ItemStack func_70298_a(int id, int count) {
        ItemStack item = this.func_70301_a(id);
        if (item != null) {
            if (item.field_77994_a <= count) {
                this.func_70299_a(id, null);
                return item;
            }
            ItemStack result = item.func_77979_a(count);
            if (item.field_77994_a == 0) {
                this.func_70299_a(id, null);
            }
            return result;
        }
        return null;
    }

    public ItemStack func_70304_b(int id) {
        if (this.slots.get(id).shouldDropOnClosing()) {
            ItemStack item = this.func_70301_a(id);
            this.func_70299_a(id, null);
            return item;
        }
        return null;
    }

    public void func_70299_a(int id, ItemStack item) {
        this.items[id] = item;
    }

    public String func_145825_b() {
        return "Production Table";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void addSlot(SlotBase slot) {
        this.slots.add(slot);
    }

    public void addPlayer(EntityPlayer player) {
        if (!this.players.contains(player)) {
            this.players.add(player);
            this.sendAllDataToPlayer(player);
        } else {
            System.err.println("Trying to add a listening player: " + player.toString());
        }
    }

    private void sendAllDataToPlayer(EntityPlayer player) {
        DataWriter dw = PacketHandler.getWriter(this, PacketId.ALL);
        for (DataType dataType : DataType.values()) {
            dataType.save(this, dw, -1);
        }
        PacketHandler.sendToPlayer(dw, player);
    }

    public void sendDataToAllPlayer(DataType dataType) {
        this.sendDataToAllPlayer(dataType, 0);
    }

    public void sendDataToAllPlayer(DataType dataType, int id) {
        this.sendToAllPlayers(this.getWriterForType(dataType, id));
    }

    private void sendDataToAllPlayersExcept(DataType dataType, int id, EntityPlayer ignored) {
        this.sendToAllPlayersExcept(this.getWriterForType(dataType, id), ignored);
    }

    private void sendToAllPlayers(DataWriter dw) {
        this.sendToAllPlayersExcept(dw, null);
    }

    private void sendToAllPlayersExcept(DataWriter dw, EntityPlayer ignored) {
        for (EntityPlayer player : this.players) {
            if (player.equals((Object)ignored)) continue;
            PacketHandler.sendToPlayer(dw, player);
        }
    }

    public void removePlayer(EntityPlayer player) {
        if (!this.players.remove(player)) {
            System.err.println("Trying to remove non-listening player: " + player.toString());
        }
    }

    public void updateServer(DataType dataType) {
        this.updateServer(dataType, 0);
    }

    public void updateServer(DataType dataType, int id) {
        PacketHandler.sendToServer(this.getWriterForType(dataType, id));
    }

    private DataWriter getWriterForType(DataType dataType, int id) {
        DataWriter dw = PacketHandler.getWriter(this, PacketId.TYPE);
        dw.writeEnum(dataType);
        dataType.save(this, dw, id);
        return dw;
    }

    public void receiveServerPacket(DataReader dr, PacketId id, EntityPlayer player) {
        switch (id) {
            case TYPE: {
                DataType dataType = dr.readEnum(DataType.class);
                int index = dataType.load(this, dr, false);
                if (index != -1 && dataType.shouldBounce(this)) {
                    this.sendDataToAllPlayersExcept(dataType, index, dataType.shouldBounceToAll(this) ? null : player);
                }
                if (dataType == DataType.SIDE_ENABLED) {
                    this.onSideChange();
                }
                this.func_70296_d();
                break;
            }
            case CLOSE: {
                this.removePlayer(player);
                break;
            }
            case RE_OPEN: {
                this.addPlayer(player);
                break;
            }
            case CLEAR: {
                this.clearGrid(player, dr.readData(GRID_ID_BITS));
            }
        }
    }

    public void receiveClientPacket(DataReader dr, PacketId id) {
        switch (id) {
            case ALL: {
                for (DataType dataType : DataType.values()) {
                    dataType.load(this, dr, true);
                }
                this.onUpgradeChange();
                break;
            }
            case TYPE: {
                DataType dataType = dr.readEnum(DataType.class);
                dataType.load(this, dr, false);
                if (dataType != DataType.SIDE_ENABLED) break;
                this.onSideChange();
                break;
            }
            case UPGRADE_CHANGE: {
                this.onUpgradeChange();
            }
        }
    }

    public void func_145845_h() {
        for (Page page : this.pages) {
            page.onUpdate();
        }
        if (!this.field_145850_b.field_72995_K && ++this.fuelTick >= 5) {
            boolean bl = this.lit = this.field_145850_b.func_72957_l(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == 15;
            if (this.lastLit != this.lit) {
                this.lastLit = this.lit;
                this.sendDataToAllPlayer(DataType.LIT);
            }
            this.fuelTick = 0;
            this.reloadFuel();
        }
        if (!this.field_145850_b.field_72995_K && ++this.moveTick >= 20) {
            this.moveTick = 0;
            if (this.getUpgradePage().hasGlobalUpgrade(Upgrade.AUTO_TRANSFER)) {
                int transferSize = (int)Math.pow(2.0, this.getUpgradePage().getGlobalUpgradeCount(Upgrade.TRANSFER));
                for (Setting setting : this.getTransferPage().getSettings()) {
                    for (Side side : setting.getSides()) {
                        this.transfer(setting, side, side.getInput(), transferSize);
                        this.transfer(setting, side, side.getOutput(), transferSize);
                    }
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && ++this.slotTick >= 10) {
            this.slotTick = 0;
            for (SlotBase slot : this.slots) {
                slot.updateServer();
            }
        }
    }

    private void transfer(Setting setting, Side side, Transfer transfer, int transferSize) {
        if (transfer.isEnabled() && transfer.isAuto()) {
            ForgeDirection direction = ForgeDirection.values()[BlockTable.getSideFromSideAndMetaReversed(side.getDirection().ordinal(), this.func_145832_p())];
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            if (te instanceof IInventory) {
                int[] slots2;
                List<SlotBase> transferSlots;
                IInventory inventory;
                if (te instanceof TileEntityChest) {
                    inventory = Blocks.field_150486_ae.func_149951_m(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e);
                    if (inventory == null) {
                        return;
                    }
                } else {
                    inventory = (IInventory)te;
                }
                if ((transferSlots = setting.getSlots()) == null) {
                    return;
                }
                int[] slots1 = new int[transferSlots.size()];
                for (int i = 0; i < transferSlots.size(); ++i) {
                    slots1[i] = transferSlots.get(i).getSlotIndex();
                }
                ForgeDirection directionReversed = direction.getOpposite();
                if (inventory instanceof ISidedInventory) {
                    slots2 = ((ISidedInventory)inventory).func_94128_d(directionReversed.ordinal());
                } else {
                    slots2 = new int[inventory.func_70302_i_()];
                    for (int i = 0; i < slots2.length; ++i) {
                        slots2[i] = i;
                    }
                }
                if (slots2 == null || slots2.length == 0) {
                    return;
                }
                if (transfer.isInput()) {
                    this.transfer(inventory, this, slots2, slots1, directionReversed.ordinal(), direction.ordinal(), transferSize);
                } else {
                    this.transfer(this, inventory, slots1, slots2, direction.ordinal(), directionReversed.ordinal(), transferSize);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transfer(IInventory from, IInventory to, int[] fromSlots, int[] toSlots, int fromSide, int toSide, int maxTransfer) {
        int oldTransfer = maxTransfer;
        try {
            ISidedInventory fromSided = fromSide != -1 && from instanceof ISidedInventory ? (ISidedInventory)from : null;
            ISidedInventory toSided = toSide != -1 && to instanceof ISidedInventory ? (ISidedInventory)to : null;
            block5: for (int fromSlot : fromSlots) {
                ItemStack toItem;
                ItemStack fromItem = from.func_70301_a(fromSlot);
                if (fromItem == null || fromItem.field_77994_a <= 0 || fromSided != null && !fromSided.func_102008_b(fromSlot, fromItem, fromSide)) continue;
                if (fromItem.func_77985_e()) {
                    for (int toSlot : toSlots) {
                        toItem = to.func_70301_a(toSlot);
                        if (toItem == null || toItem.field_77994_a <= 0 || toSided != null && !toSided.func_102007_a(toSlot, fromItem, toSide) || !fromItem.func_77969_a(toItem) || !ItemStack.func_77970_a((ItemStack)toItem, (ItemStack)fromItem)) continue;
                        int maxSize = Math.min(toItem.func_77976_d(), to.func_70297_j_());
                        int maxMove = Math.min(maxSize - toItem.field_77994_a, Math.min(maxTransfer, fromItem.field_77994_a));
                        toItem.field_77994_a += maxMove;
                        maxTransfer -= maxMove;
                        fromItem.field_77994_a -= maxMove;
                        if (fromItem.field_77994_a == 0) {
                            from.func_70299_a(fromSlot, null);
                        }
                        if (maxTransfer == 0) {
                            return;
                        }
                        if (fromItem.field_77994_a == 0) break;
                    }
                }
                if (fromItem.field_77994_a <= 0) continue;
                for (int toSlot : toSlots) {
                    toItem = to.func_70301_a(toSlot);
                    if (toItem != null || !to.func_94041_b(toSlot, fromItem) || toSided != null && !toSided.func_102007_a(toSlot, fromItem, toSide)) continue;
                    toItem = fromItem.func_77946_l();
                    toItem.field_77994_a = Math.min(maxTransfer, fromItem.field_77994_a);
                    to.func_70299_a(toSlot, toItem);
                    maxTransfer -= toItem.field_77994_a;
                    fromItem.field_77994_a -= toItem.field_77994_a;
                    if (fromItem.field_77994_a == 0) {
                        from.func_70299_a(fromSlot, null);
                    }
                    if (maxTransfer == 0) {
                        return;
                    }
                    if (fromItem.field_77994_a == 0) continue block5;
                }
            }
        }
        finally {
            if (oldTransfer != maxTransfer) {
                to.func_70296_d();
                from.func_70296_d();
            }
        }
    }

    private void reloadFuel() {
        ItemStack fuel;
        int space;
        if (this.isLitAndCanSeeTheSky()) {
            this.power += 4 * this.getUpgradePage().getGlobalUpgradeCount(Upgrade.SOLAR);
        }
        if (this.getUpgradePage().hasGlobalUpgrade(Upgrade.LAVA) && (space = (20000 - this.power) / 12) > 0) {
            int move = Math.max(0, Math.min(30, Math.min(space, this.lava)));
            this.power += move * 12;
            this.lava -= move;
        }
        if ((fuel = this.fuelSlot.func_75211_c()) != null && this.fuelSlot.func_75214_a(fuel)) {
            int fuelLevel = TileEntityFurnace.func_145952_a((ItemStack)fuel);
            if ((fuelLevel = (int)((float)fuelLevel * (1.0f + (float)this.getUpgradePage().getGlobalUpgradeCount(Upgrade.EFFICIENCY) / 4.0f))) > 0 && fuelLevel + this.power <= 20000) {
                this.power += fuelLevel;
                if (fuel.func_77973_b().hasContainerItem(fuel)) {
                    this.fuelSlot.func_75215_d(fuel.func_77973_b().getContainerItem(fuel).func_77946_l());
                } else {
                    this.func_70298_a(this.fuelSlot.getSlotIndex(), 1);
                }
            }
        }
        if (this.power > 20000) {
            this.power = 20000;
        }
        if (this.power != this.lastPower) {
            this.lastPower = this.power;
            this.sendDataToAllPlayer(DataType.POWER);
        }
        if (this.lava != this.lastLava) {
            this.lastLava = this.lava;
            this.sendDataToAllPlayer(DataType.LAVA);
        }
    }

    public boolean isLitAndCanSeeTheSky() {
        return this.lit && this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    public void onUpgradeChangeDistribute() {
        if (!this.field_145850_b.field_72995_K) {
            this.onUpgradeChange();
            this.sendToAllPlayers(PacketHandler.getWriter(this, PacketId.UPGRADE_CHANGE));
        } else {
            this.getUpgradePage().onUpgradeChange();
        }
    }

    public void onUpgradeChange() {
        this.reloadTransferSides();
        this.getUpgradePage().onUpgradeChange();
        for (UnitCrafting crafting : this.getMainPage().getCraftingList()) {
            crafting.onUpgradeChange();
        }
    }

    public void onSideChange() {
        this.reloadTransferSides();
    }

    private void reloadTransferSides() {
        for (int i = 0; i < this.sideSlots.length; ++i) {
            for (SlotBase slot : this.slots) {
                slot.resetValidity(i);
            }
            ArrayList<SlotBase> slotsForSide = new ArrayList<SlotBase>();
            for (Setting setting : this.getTransferPage().getSettings()) {
                List<SlotBase> unitSlots;
                Transfer input = setting.getSides().get(i).getInput();
                Transfer output = setting.getSides().get(i).getOutput();
                if (!input.isEnabled() && !output.isEnabled() || (unitSlots = setting.getSlots()) == null) continue;
                slotsForSide.addAll(unitSlots);
                for (SlotBase unitSlot : unitSlots) {
                    boolean isSlotInput = input.isEnabled() && unitSlot.canAcceptItems();
                    boolean isSlotOutput = output.isEnabled() && unitSlot.canSupplyItems();
                    unitSlot.setValidity(i, isSlotInput ? input : null, isSlotOutput ? output : null);
                }
            }
            this.sideSlots[i] = this.getSlotIndexArray(slotsForSide);
        }
    }

    private int[] getSlotIndexArray(List<SlotBase> slots) {
        int[] result = new int[slots.size()];
        for (int j = 0; j < slots.size(); ++j) {
            result[j] = slots.get(j).getSlotIndex();
        }
        return result;
    }

    public boolean func_94041_b(int id, ItemStack item) {
        return this.slots.get(id).func_75214_a(item);
    }

    public int[] func_94128_d(int side) {
        return this.sideSlots[this.getTransferSide(side)];
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return this.func_94041_b(slot, item) && this.slots.get(slot).canAcceptItem(item) && this.slots.get(slot).isInputValid(this.getTransferSide(side), item);
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return this.slots.get(slot).isOutputValid(this.getTransferSide(side), item);
    }

    private int getTransferSide(int side) {
        return BlockTable.getSideFromSideAndMeta(side, this.func_145832_p());
    }

    public GuiMenu getMenu() {
        return this.menu;
    }

    public void setMenu(GuiMenuItem menu) {
        this.menu = menu;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() != null && resource.getFluid().equals(FluidRegistry.LAVA)) {
            int space = 1000 - this.lava;
            int fill = Math.min(space, resource.amount);
            if (doFill) {
                this.lava += fill;
            }
            return fill;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() != null && resource.getFluid().equals(FluidRegistry.LAVA)) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        int drain = Math.min(maxDrain, this.lava);
        if (doDrain) {
            this.lava -= drain;
        }
        return drain == 0 ? null : new FluidStack(FluidRegistry.LAVA, drain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid != null && fluid.equals(FluidRegistry.LAVA);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid != null && fluid.equals(FluidRegistry.LAVA);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo(new FluidStack(FluidRegistry.LAVA, this.lava), 1000)};
    }

    public int getLava() {
        return this.lava;
    }

    public void setLava(int lava) {
        this.lava = lava;
    }

    public boolean isLit() {
        return this.lit;
    }

    public void setLit(boolean lit) {
        this.lit = lit;
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound slotCompound = new NBTTagCompound();
            slotCompound.func_74774_a(NBT_SLOT, (byte)i);
            this.items[i].func_77955_b(slotCompound);
            itemList.func_74742_a((NBTBase)slotCompound);
        }
        compound.func_74782_a(NBT_ITEMS, (NBTBase)itemList);
        NBTTagList unitList = new NBTTagList();
        for (Unit unit : this.getMainPage().getUnits()) {
            NBTTagCompound unitCompound = new NBTTagCompound();
            unit.writeToNBT(unitCompound);
            unitList.func_74742_a((NBTBase)unitCompound);
        }
        compound.func_74782_a(NBT_UNITS, (NBTBase)unitList);
        NBTTagList settingList = new NBTTagList();
        for (Setting setting : this.getTransferPage().getSettings()) {
            NBTTagCompound settingCompound = new NBTTagCompound();
            NBTTagList sideList = new NBTTagList();
            for (Side side : setting.getSides()) {
                NBTTagCompound sideCompound = new NBTTagCompound();
                NBTTagCompound inputCompound = new NBTTagCompound();
                NBTTagCompound outputCompound = new NBTTagCompound();
                side.getInput().writeToNBT(inputCompound);
                side.getOutput().writeToNBT(outputCompound);
                sideCompound.func_74782_a(NBT_INPUT, (NBTBase)inputCompound);
                sideCompound.func_74782_a(NBT_OUTPUT, (NBTBase)outputCompound);
                sideList.func_74742_a((NBTBase)sideCompound);
            }
            settingCompound.func_74782_a(NBT_SIDES, (NBTBase)sideList);
            settingList.func_74742_a((NBTBase)settingCompound);
        }
        compound.func_74782_a(NBT_SETTINGS, (NBTBase)settingList);
        compound.func_74777_a(NBT_POWER, (short)this.power);
        compound.func_74777_a(NBT_LAVA, (short)((byte)this.lava));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.items = new ItemStack[this.func_70302_i_()];
        NBTTagList itemList = compound.func_150295_c(NBT_ITEMS, 10);
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound slotCompound = itemList.func_150305_b(i);
            int id = slotCompound.func_74771_c(NBT_SLOT);
            if (id < 0) {
                id += 256;
            }
            if (id < 0 || id >= this.items.length) continue;
            this.items[id] = ItemStack.func_77949_a((NBTTagCompound)slotCompound);
        }
        NBTTagList unitList = compound.func_150295_c(NBT_UNITS, 10);
        List<Unit> units = this.getMainPage().getUnits();
        for (int i = 0; i < units.size(); ++i) {
            Unit unit = units.get(i);
            NBTTagCompound unitCompound = unitList.func_150305_b(i);
            unit.readFromNBT(unitCompound);
        }
        NBTTagList settingList = compound.func_150295_c(NBT_SETTINGS, 10);
        List<Setting> settings = this.getTransferPage().getSettings();
        for (int i = 0; i < settings.size(); ++i) {
            Setting setting = settings.get(i);
            NBTTagCompound settingCompound = settingList.func_150305_b(i);
            NBTTagList sideList = settingCompound.func_150295_c(NBT_SIDES, 10);
            List<Side> sides = setting.getSides();
            for (int j = 0; j < sides.size(); ++j) {
                Side side = sides.get(j);
                NBTTagCompound sideCompound = sideList.func_150305_b(j);
                NBTTagCompound inputCompound = sideCompound.func_74775_l(NBT_INPUT);
                NBTTagCompound outputCompound = sideCompound.func_74775_l(NBT_OUTPUT);
                side.getInput().readFromNBT(inputCompound);
                side.getOutput().readFromNBT(outputCompound);
            }
        }
        this.power = compound.func_74765_d(NBT_POWER);
        this.lava = compound.func_74765_d(NBT_LAVA);
        this.onUpgradeChange();
    }

    public void spitOutItem(ItemStack item) {
        float offsetX = this.field_145850_b.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float offsetY = this.field_145850_b.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float offsetZ = this.field_145850_b.field_73012_v.nextFloat() * 0.8f + 0.1f;
        EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + offsetX), (double)((float)this.field_145848_d + offsetY), (double)((float)this.field_145849_e + offsetZ), item.func_77946_l());
        entityItem.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * (double)0.05f;
        entityItem.field_70181_x = this.field_145850_b.field_73012_v.nextGaussian() * (double)0.05f + (double)0.2f;
        entityItem.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * (double)0.05f;
        this.field_145850_b.func_72838_d((Entity)entityItem);
    }

    public void clearGridSend(int id) {
        DataWriter dw = PacketHandler.getWriter(this, PacketId.CLEAR);
        dw.writeData(id, GRID_ID_BITS);
        PacketHandler.sendToServer(dw);
    }

    private void clearGrid(EntityPlayer player, int id) {
        UnitCrafting crafting = this.getMainPage().getCraftingList().get(id);
        if (crafting.isEnabled()) {
            int[] from = this.getAllSlots(crafting.getGridId(), 9);
            if (this.getUpgradePage().hasUpgrade(crafting.getId(), Upgrade.STORAGE)) {
                this.transfer(this, this, from, this.getAllSlots(crafting.getStorageId(), 6), -1, -1, Integer.MAX_VALUE);
            }
            this.transfer(this, (IInventory)player.field_71071_by, from, this.getAllSlots(0, player.field_71071_by.field_70462_a.length), -1, -1, Integer.MAX_VALUE);
        }
    }

    private int[] getAllSlots(int start, int length) {
        int[] result = new int[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = start + i;
        }
        return result;
    }
}

