/*
 * Decompiled with CFR 0.152.
 */
package vswe.production.page.setting;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import vswe.production.item.Upgrade;
import vswe.production.page.setting.ItemSetting;
import vswe.production.page.setting.TransferMode;
import vswe.production.tileentity.TileEntityTable;

public class Transfer {
    private boolean enabled;
    private boolean isInput;
    private boolean auto;
    private ItemSetting[] items;
    private boolean useWhiteList;
    private static final String NBT_ENABLED = "Enabled";
    private static final String NBT_AUTO = "Auto";
    private static final String NBT_WHITE_LIST = "WhiteList";
    private static final String NBT_ITEMS = "Items";
    private static final String NBT_ID = "Slot";
    private static final String NBT_MODE = "MatchMode";
    private static final int COMPOUND_ID = 10;

    public Transfer(boolean isInput) {
        this.isInput = isInput;
        this.items = new ItemSetting[10];
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = new ItemSetting(i);
        }
    }

    public boolean isInput() {
        return this.isInput;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public void setAuto(boolean auto) {
        this.auto = auto;
    }

    public boolean hasWhiteList() {
        return this.useWhiteList;
    }

    public void setUseWhiteList(boolean useWhiteList) {
        this.useWhiteList = useWhiteList;
    }

    public ItemSetting getItem(int id) {
        return this.items[id];
    }

    public boolean isValid(TileEntityTable table, ItemStack item) {
        if (item == null || !table.getUpgradePage().hasGlobalUpgrade(Upgrade.FILTER)) {
            return true;
        }
        for (ItemSetting itemSetting : this.items) {
            boolean match;
            ItemStack filterItem = itemSetting.getItem();
            if (filterItem == null || !(match = itemSetting.getMode().isMatch(item, filterItem))) continue;
            return this.useWhiteList;
        }
        return !this.useWhiteList;
    }

    public boolean hasFilter(TileEntityTable table) {
        if (table.getUpgradePage().hasGlobalUpgrade(Upgrade.FILTER)) {
            for (ItemSetting item : this.items) {
                if (item.getItem() == null) continue;
                return true;
            }
        }
        return false;
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74757_a(NBT_ENABLED, this.enabled);
        if (this.enabled) {
            compound.func_74757_a(NBT_AUTO, this.auto);
            compound.func_74757_a(NBT_WHITE_LIST, this.useWhiteList);
            boolean hasItem = false;
            NBTTagList itemList = new NBTTagList();
            for (int i = 0; i < this.items.length; ++i) {
                ItemSetting item = this.items[i];
                if (item.getItem() == null) continue;
                NBTTagCompound itemCompound = new NBTTagCompound();
                itemCompound.func_74774_a(NBT_ID, (byte)i);
                itemCompound.func_74774_a(NBT_MODE, (byte)item.getMode().ordinal());
                item.getItem().func_77955_b(itemCompound);
                itemList.func_74742_a((NBTBase)itemCompound);
                hasItem = true;
            }
            if (hasItem) {
                compound.func_74782_a(NBT_ITEMS, (NBTBase)itemList);
            }
        }
    }

    public void readFromNBT(NBTTagCompound compound) {
        for (ItemSetting item : this.items) {
            item.setItem(null);
            item.setMode(TransferMode.PRECISE);
        }
        this.enabled = compound.func_74767_n(NBT_ENABLED);
        if (this.enabled) {
            this.auto = compound.func_74767_n(NBT_AUTO);
            this.useWhiteList = compound.func_74767_n(NBT_WHITE_LIST);
            if (compound.func_74764_b(NBT_ITEMS)) {
                NBTTagList itemList = compound.func_150295_c(NBT_ITEMS, 10);
                for (int i = 0; i < itemList.func_74745_c(); ++i) {
                    NBTTagCompound itemCompound = itemList.func_150305_b(i);
                    byte id = itemCompound.func_74771_c(NBT_ID);
                    ItemSetting itemSetting = this.items[id];
                    itemSetting.setMode(TransferMode.values()[itemCompound.func_74771_c(NBT_MODE)]);
                    itemSetting.setItem(ItemStack.func_77949_a((NBTTagCompound)itemCompound));
                }
            }
        }
    }
}

