/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.tiles;

import appeng.api.AEApi;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import thaumicenergistics.common.tiles.abstraction.ThETileInventory;

public class TileDistillationPatternEncoder
extends ThETileInventory {
    private static String NBTKEY_INVENTORY = "inventory";
    public static int SLOT_PATTERNS_COUNT = 2;
    public static int SLOT_SOURCE_ITEM_COUNT = 1;
    public static int SLOT_TOTAL_COUNT = SLOT_SOURCE_ITEM_COUNT + SLOT_PATTERNS_COUNT;
    public static int SLOT_SOURCE_ITEM = 0;
    public static int SLOT_BLANK_PATTERNS = 1;
    public static int SLOT_ENCODED_PATTERN = 2;

    public TileDistillationPatternEncoder() {
        super("distillation.inscriber", SLOT_TOTAL_COUNT, 64);
    }

    public boolean canUpdate() {
        return false;
    }

    public ArrayList<ItemStack> getDrops(ArrayList<ItemStack> drops) {
        if (this.internalInventory.getHasStack(SLOT_ENCODED_PATTERN)) {
            drops.add(this.internalInventory.func_70301_a(SLOT_ENCODED_PATTERN));
        }
        if (this.internalInventory.getHasStack(SLOT_BLANK_PATTERNS)) {
            drops.add(this.internalInventory.func_70301_a(SLOT_BLANK_PATTERNS));
        }
        return drops;
    }

    public boolean hasPatterns() {
        return this.internalInventory.getHasStack(SLOT_ENCODED_PATTERN) || this.internalInventory.getHasStack(SLOT_BLANK_PATTERNS);
    }

    public boolean func_94041_b(int slotId, ItemStack itemStack) {
        if (itemStack == null) {
            return true;
        }
        if (slotId == SLOT_BLANK_PATTERNS) {
            return AEApi.instance().definitions().materials().blankPattern().isSameAs(itemStack);
        }
        if (slotId == SLOT_ENCODED_PATTERN) {
            return AEApi.instance().definitions().items().encodedPattern().isSameAs(itemStack);
        }
        return true;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b(NBTKEY_INVENTORY)) {
            this.internalInventory.readFromNBT(data, NBTKEY_INVENTORY);
        }
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.internalInventory.writeToNBT(data, NBTKEY_INVENTORY);
    }
}

