/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.storage;

import java.util.Comparator;
import thaumicenergistics.api.storage.IAspectStack;

public class AspectStackComparator
implements Comparator<IAspectStack> {
    private AspectStackComparatorMode mode;

    public AspectStackComparator() {
        this.setMode(AspectStackComparatorMode.MODE_ALPHABETIC);
    }

    public AspectStackComparator(AspectStackComparatorMode mode) {
        this.setMode(mode);
    }

    private int compareByAmount(IAspectStack left, IAspectStack right) {
        return (int)(right.getStackSize() - left.getStackSize());
    }

    private int compareByName(IAspectStack left, IAspectStack right) {
        return left.getAspectName().compareTo(right.getAspectName());
    }

    @Override
    public int compare(IAspectStack left, IAspectStack right) {
        switch (this.mode) {
            case MODE_ALPHABETIC: {
                return this.compareByName(left, right);
            }
            case MODE_AMOUNT: {
                int comparedAmounts = this.compareByAmount(left, right);
                if (comparedAmounts == 0) {
                    comparedAmounts = this.compareByName(left, right);
                }
                return comparedAmounts;
            }
        }
        return 0;
    }

    public void setMode(AspectStackComparatorMode mode) {
        this.mode = mode;
    }

    public static enum AspectStackComparatorMode {
        MODE_ALPHABETIC,
        MODE_AMOUNT;

        public static final AspectStackComparatorMode[] VALUES;

        public AspectStackComparatorMode nextMode() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public AspectStackComparatorMode previousMode() {
            return VALUES[(this.ordinal() + (VALUES.length - 1)) % VALUES.length];
        }

        static {
            VALUES = AspectStackComparatorMode.values();
        }
    }
}

