/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.parts;

import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.grid.IEssentiaWatcher;
import thaumicenergistics.api.grid.IEssentiaWatcherHost;
import thaumicenergistics.api.grid.IMEEssentiaMonitor;
import thaumicenergistics.client.gui.GuiEssentiaLevelEmitter;
import thaumicenergistics.client.textures.BlockTextureManager;
import thaumicenergistics.common.container.ContainerPartEssentiaLevelEmitter;
import thaumicenergistics.common.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.common.network.IAspectSlotPart;
import thaumicenergistics.common.parts.AEPartsEnum;
import thaumicenergistics.common.parts.ThEPartBase;
import thaumicenergistics.common.registries.EnumCache;
import thaumicenergistics.common.utils.EffectiveSide;

public class PartEssentiaLevelEmitter
extends ThEPartBase
implements IAspectSlotPart,
IEssentiaWatcherHost {
    private static final double IDLE_POWER_DRAIN = 0.3;
    private static final String NBT_KEY_ASPECT_FILTER = "aspect";
    private static final String NBT_KEY_REDSTONE_MODE = "mode";
    private static final String NBT_KEY_WANTED_AMOUNT = "wantedAmount";
    private static final String NBT_KEY_IS_EMITTING = "emitting";
    private static final RedstoneMode DEFAULT_REDSTONE_MODE = RedstoneMode.HIGH_SIGNAL;
    private static final float Base_XY_Min = 7.0f;
    private static final float Base_XY_Max = 9.0f;
    private static final float Base_Z_Min = 11.0f;
    private static final float Base_Z_Max = 13.0f;
    private static final float Head_Z_Min = 13.0f;
    private static final float Head_Z_Max = 15.0f;
    private static final float Face_Z_Min = 12.0f;
    private static final float FaceZMax = 16.0f;
    private static final float FaceOffset_XH_YV = 0.001f;
    private static final float FaceOffset_XV_YH = 1.0f;
    private static final float Face_XH_Min = 6.999f;
    private static final float Face_YH_Min = 6.0f;
    private static final float Face_XH_Max = 9.001f;
    private static final float Face_YH_Max = 10.0f;
    private static final float Face_XV_Min = 6.0f;
    private static final float Face_YV_Min = 6.999f;
    private static final float Face_XV_Max = 10.0f;
    private static final float Face_YV_Max = 9.001f;
    private Aspect trackedAspect;
    private RedstoneMode redstoneMode = DEFAULT_REDSTONE_MODE;
    private long thresholdLevel = 0L;
    private long currentLevel;
    private boolean isEmitting = false;
    private IEssentiaWatcher essentiaWatcher;

    public PartEssentiaLevelEmitter() {
        super(AEPartsEnum.EssentiaLevelEmitter, SecurityPermissions.BUILD);
    }

    private void configureWatcher() {
        boolean didSet = false;
        if (this.essentiaWatcher != null) {
            this.essentiaWatcher.clear();
            if (this.trackedAspect != null) {
                this.essentiaWatcher.add(this.trackedAspect);
                IMEEssentiaMonitor essMon = this.getGridBlock().getEssentiaMonitor();
                if (essMon != null) {
                    this.setCurrentLevel(essMon.getEssentiaAmount(this.trackedAspect));
                    didSet = true;
                }
            }
        }
        if (!didSet) {
            this.setCurrentLevel(0L);
        }
    }

    private void setCurrentLevel(long amount) {
        if (amount != this.currentLevel) {
            this.currentLevel = amount;
            this.updateEmittingState();
        }
    }

    private void updateEmittingState() {
        boolean emitting = false;
        if (!this.isActive()) {
            return;
        }
        switch (this.redstoneMode) {
            case HIGH_SIGNAL: {
                emitting = this.currentLevel >= this.thresholdLevel;
                break;
            }
            case LOW_SIGNAL: {
                emitting = this.currentLevel < this.thresholdLevel;
                break;
            }
        }
        if (emitting != this.isEmitting) {
            this.isEmitting = emitting;
            this.markForSave();
            this.markForUpdate();
            TileEntity hte = this.getHostTile();
            ForgeDirection side = this.getSide();
            Platform.notifyBlocksOfNeighbors((World)hte.func_145831_w(), (int)hte.field_145851_c, (int)hte.field_145848_d, (int)hte.field_145849_e);
            Platform.notifyBlocksOfNeighbors((World)hte.func_145831_w(), (int)(hte.field_145851_c + side.offsetX), (int)(hte.field_145848_d + side.offsetX), (int)(hte.field_145849_e + side.offsetX));
        }
    }

    @Override
    public int cableConnectionRenderTo() {
        return 8;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public void getBoxes(IPartCollisionHelper helper) {
        helper.addBox(7.0, 7.0, 11.0, 9.0, 9.0, 15.0);
    }

    @Override
    public IIcon getBreakingTexture() {
        return BlockTextureManager.ESSENTIA_LEVEL_EMITTER.getTextures()[1];
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiEssentiaLevelEmitter(this, player);
    }

    @Override
    public double getIdlePowerUsage() {
        return 0.3;
    }

    @Override
    public int getLightLevel() {
        return this.isEmitting ? 7 : 0;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerPartEssentiaLevelEmitter(this, player);
    }

    public long getThresholdLevel() {
        return this.thresholdLevel;
    }

    @Nullable
    public Aspect getTrackedAspect() {
        return this.trackedAspect;
    }

    @Override
    public int isProvidingStrongPower() {
        return this.isEmitting ? 15 : 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return this.isProvidingStrongPower();
    }

    public void onAdjustThresholdLevel(int adjustmentAmount, EntityPlayer player) {
        this.onSetThresholdLevel(this.thresholdLevel + (long)adjustmentAmount, player);
    }

    public void onClientToggleRedstoneMode(EntityPlayer player) {
        switch (this.redstoneMode) {
            case HIGH_SIGNAL: {
                this.redstoneMode = RedstoneMode.LOW_SIGNAL;
                break;
            }
            case LOW_SIGNAL: {
                this.redstoneMode = RedstoneMode.HIGH_SIGNAL;
                break;
            }
        }
        this.updateEmittingState();
    }

    @Override
    public void onEssentiaChange(Aspect aspect, long storedAmount, long changeAmount) {
        this.setCurrentLevel(storedAmount);
    }

    public void onSetThresholdLevel(long threshold, EntityPlayer player) {
        this.thresholdLevel = threshold;
        if (this.thresholdLevel < 0L) {
            this.thresholdLevel = 0L;
        } else if (this.thresholdLevel > 9999999999L) {
            this.thresholdLevel = 9999999999L;
        }
        this.markForSave();
        this.updateEmittingState();
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random r) {
        if (this.isEmitting) {
            ForgeDirection side = this.getSide();
            double particleX = (double)((float)side.offsetX * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double particleY = (double)((float)side.offsetY * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double particleZ = (double)((float)side.offsetZ * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            world.func_72869_a("reddust", 0.5 + (double)x + particleX, 0.5 + (double)y + particleY, 0.5 + (double)z + particleZ, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b(NBT_KEY_ASPECT_FILTER)) {
            this.trackedAspect = (Aspect)Aspect.aspects.get(data.func_74779_i(NBT_KEY_ASPECT_FILTER));
        }
        if (data.func_74764_b(NBT_KEY_REDSTONE_MODE)) {
            this.redstoneMode = EnumCache.AE_REDSTONE_MODES[data.func_74762_e(NBT_KEY_REDSTONE_MODE)];
        }
        if (data.func_74764_b(NBT_KEY_WANTED_AMOUNT)) {
            this.thresholdLevel = data.func_74763_f(NBT_KEY_WANTED_AMOUNT);
        }
        if (data.func_74764_b(NBT_KEY_IS_EMITTING)) {
            this.isEmitting = data.func_74767_n(NBT_KEY_IS_EMITTING);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean readFromStream(ByteBuf stream) throws IOException {
        boolean redraw = false;
        boolean oldEmit = this.isEmitting;
        redraw |= super.readFromStream(stream);
        this.isEmitting = stream.readBoolean();
        return redraw |= this.isEmitting != oldEmit;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper helper, RenderBlocks renderer) {
        helper.setTexture(BlockTextureManager.ESSENTIA_LEVEL_EMITTER.getTextures()[0]);
        helper.setBounds(7.0f, 1.0f, 14.0f, 9.0f, 7.0f, 16.0f);
        helper.renderInventoryBox(renderer);
        helper.setTexture(BlockTextureManager.ESSENTIA_LEVEL_EMITTER.getTextures()[1]);
        helper.setBounds(7.0f, 7.0f, 14.0f, 9.0f, 9.0f, 16.0f);
        helper.renderInventoryBox(renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper helper, RenderBlocks renderer) {
        helper.setTexture(BlockTextureManager.ESSENTIA_LEVEL_EMITTER.getTextures()[0]);
        helper.setBounds(7.0f, 7.0f, 11.0f, 9.0f, 9.0f, 13.0f);
        helper.renderBlock(x, y, z, renderer);
        if (this.isEmitting) {
            IIcon activeTex = BlockTextureManager.ESSENTIA_LEVEL_EMITTER.getTextures()[1];
            helper.setTexture(activeTex);
            Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
            Tessellator.field_78398_a.func_78380_c(0xD000D0);
            helper.setBounds(6.999f, 6.0f, 12.0f, 9.001f, 10.0f, 16.0f);
            helper.renderFace(x, y, z, activeTex, ForgeDirection.EAST, renderer);
            helper.renderFace(x, y, z, activeTex, ForgeDirection.WEST, renderer);
            helper.setBounds(6.0f, 6.999f, 12.0f, 10.0f, 9.001f, 16.0f);
            helper.renderFace(x, y, z, activeTex, ForgeDirection.UP, renderer);
            helper.renderFace(x, y, z, activeTex, ForgeDirection.DOWN, renderer);
        } else {
            helper.setTexture(BlockTextureManager.ESSENTIA_LEVEL_EMITTER.getTextures()[2]);
        }
        helper.setBounds(7.0f, 7.0f, 13.0f, 9.0f, 9.0f, 15.0f);
        helper.renderBlock(x, y, z, renderer);
    }

    @Override
    public void setAspect(int index, Aspect aspect, EntityPlayer player) {
        if (this.trackedAspect != aspect) {
            this.trackedAspect = aspect;
            if (EffectiveSide.isClientSide()) {
                return;
            }
            this.markForSave();
            this.configureWatcher();
        }
    }

    public boolean setFilteredAspectFromItemstack(EntityPlayer player, ItemStack itemStack) {
        Aspect itemAspect = EssentiaItemContainerHelper.INSTANCE.getFilterAspectFromItem(itemStack);
        if (itemAspect == null) {
            return false;
        }
        this.setAspect(0, itemAspect, player);
        return true;
    }

    @Override
    public void updateWatcher(IEssentiaWatcher newWatcher) {
        this.essentiaWatcher = newWatcher;
        this.configureWatcher();
    }

    @Override
    public void writeToNBT(NBTTagCompound data, PartItemStack saveType) {
        super.writeToNBT(data, saveType);
        if (saveType != PartItemStack.World && saveType != PartItemStack.Wrench) {
            return;
        }
        if (this.trackedAspect != null) {
            data.func_74778_a(NBT_KEY_ASPECT_FILTER, this.trackedAspect.getTag());
        }
        if (saveType == PartItemStack.World || this.trackedAspect != null) {
            if (this.redstoneMode != DEFAULT_REDSTONE_MODE) {
                data.func_74768_a(NBT_KEY_REDSTONE_MODE, this.redstoneMode.ordinal());
            }
            if (this.thresholdLevel > 0L) {
                data.func_74772_a(NBT_KEY_WANTED_AMOUNT, this.thresholdLevel);
            }
        }
        if (saveType == PartItemStack.World && this.isEmitting) {
            data.func_74757_a(NBT_KEY_IS_EMITTING, true);
        }
    }

    @Override
    public void writeToStream(ByteBuf stream) throws IOException {
        super.writeToStream(stream);
        stream.writeBoolean(this.isEmitting);
    }
}

