/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.network;

import appeng.api.parts.IPartHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import com.google.common.base.Charsets;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.common.parts.ThEPartBase;
import thaumicenergistics.common.utils.ThELog;

public abstract class ThEBasePacket
implements IMessage {
    private static final int COMPRESSED_BUFFER_SIZE = 0x100000;
    public EntityPlayer player = null;
    protected byte mode = (byte)-1;
    protected boolean useCompression = false;

    @SideOnly(value=Side.CLIENT)
    private static World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    protected static IAEItemStack readAEItemStack(ByteBuf stream) {
        try {
            IAEItemStack itemStack = AEItemStack.loadItemStackFromPacket((ByteBuf)stream);
            return itemStack;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected static ItemStack readItemstack(ByteBuf stream) {
        return ByteBufUtils.readItemStack((ByteBuf)stream);
    }

    protected static ThEPartBase readPart(ByteBuf stream) {
        ForgeDirection side = ForgeDirection.getOrientation((int)stream.readInt());
        IPartHost host = (IPartHost)ThEBasePacket.readTileEntity(stream);
        return (ThEPartBase)host.getPart(side);
    }

    protected static EntityPlayer readPlayer(ByteBuf stream) {
        EntityPlayer player = null;
        if (stream.readBoolean()) {
            World playerWorld = ThEBasePacket.readWorld(stream);
            player = playerWorld.func_72924_a(ThEBasePacket.readString(stream));
        }
        return player;
    }

    protected static String readString(ByteBuf stream) {
        byte[] stringBytes = new byte[stream.readInt()];
        stream.readBytes(stringBytes);
        return new String(stringBytes, Charsets.UTF_8);
    }

    protected static TileEntity readTileEntity(ByteBuf stream) {
        World world = ThEBasePacket.readWorld(stream);
        return world.func_147438_o(stream.readInt(), stream.readInt(), stream.readInt());
    }

    protected static World readWorld(ByteBuf stream) {
        WorldServer world = DimensionManager.getWorld((int)stream.readInt());
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT && world == null) {
            world = ThEBasePacket.getClientWorld();
        }
        return world;
    }

    protected static void writeAEItemStack(IAEItemStack itemStack, ByteBuf stream) {
        if (itemStack != null) {
            try {
                itemStack.writeToPacket(stream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static void writeItemstack(ItemStack stack, ByteBuf stream) {
        ByteBufUtils.writeItemStack((ByteBuf)stream, (ItemStack)stack);
    }

    protected static void writePart(ThEPartBase part, ByteBuf stream) {
        stream.writeInt(part.getSide().ordinal());
        ThEBasePacket.writeTileEntity(part.getHost().getTile(), stream);
    }

    protected static void writePlayer(EntityPlayer player, ByteBuf stream) {
        boolean validPlayer = player != null;
        stream.writeBoolean(validPlayer);
        if (validPlayer) {
            ThEBasePacket.writeWorld(player.field_70170_p, stream);
            ThEBasePacket.writeString(player.func_70005_c_(), stream);
        }
    }

    protected static void writeString(String string, ByteBuf stream) {
        byte[] stringBytes = string.getBytes(Charsets.UTF_8);
        stream.writeInt(stringBytes.length);
        stream.writeBytes(stringBytes);
    }

    protected static void writeTileEntity(TileEntity entity, ByteBuf stream) {
        ThEBasePacket.writeWorld(entity.func_145831_w(), stream);
        stream.writeInt(entity.field_145851_c);
        stream.writeInt(entity.field_145848_d);
        stream.writeInt(entity.field_145849_e);
    }

    protected static void writeWorld(World world, ByteBuf stream) {
        stream.writeInt(world.field_73011_w.field_76574_g);
    }

    public static Aspect readAspect(ByteBuf stream) {
        String name = ThEBasePacket.readString(stream);
        if (name != "") {
            return (Aspect)Aspect.aspects.get(name);
        }
        return null;
    }

    public static void writeAspect(Aspect aspect, ByteBuf stream) {
        String aspectName = "";
        if (aspect != null) {
            aspectName = aspect.getTag();
        }
        ThEBasePacket.writeString(aspectName, stream);
    }

    private void fromCompressedBytes(final ByteBuf packetStream) {
        ByteBuf decompressedStream = Unpooled.buffer((int)0x100000);
        try (InputStream inStream = new InputStream(){

            @Override
            public int read() throws IOException {
                if (packetStream.readableBytes() <= 0) {
                    return -1;
                }
                return packetStream.readByte() & 0xFF;
            }
        };
             GZIPInputStream decompressor = new GZIPInputStream(inStream);){
            byte[] holding = new byte[512];
            while (decompressor.available() != 0) {
                int bytesRead = decompressor.read(holding);
                if (bytesRead <= 0) continue;
                decompressedStream.writeBytes(holding, 0, bytesRead);
            }
            decompressor.close();
            decompressedStream.readerIndex(0);
            this.readData(decompressedStream);
        }
        catch (IOException e) {
            ThELog.error(e, "Packet decompression failed.", new Object[0]);
        }
    }

    private void toCompressedBytes(final ByteBuf packetStream) {
        ByteBuf streamToCompress = Unpooled.buffer((int)0x100000);
        this.writeData(streamToCompress);
        try (OutputStream outStream = new OutputStream(){

            @Override
            public void write(int byteToWrite) throws IOException {
                packetStream.writeByte(byteToWrite & 0xFF);
            }
        };
             GZIPOutputStream compressor = new GZIPOutputStream(outStream){
            {
                this.def.setLevel(9);
            }
        };){
            compressor.write(streamToCompress.array(), 0, streamToCompress.writerIndex());
            compressor.close();
        }
        catch (IOException e) {
            ThELog.error(e, "Packet compression failed, packet will be incomplete or dropped.", new Object[0]);
        }
    }

    protected abstract boolean includePlayerInStream();

    protected abstract void readData(ByteBuf var1);

    protected abstract void writeData(ByteBuf var1);

    public abstract void execute();

    public void fromBytes(ByteBuf stream) {
        this.mode = stream.readByte();
        if (this.includePlayerInStream()) {
            this.player = ThEBasePacket.readPlayer(stream);
        }
        this.useCompression = stream.readBoolean();
        if (this.useCompression) {
            this.fromCompressedBytes(stream);
        } else {
            this.readData(stream);
        }
    }

    public void toBytes(ByteBuf stream) {
        stream.writeByte((int)this.mode);
        if (this.includePlayerInStream()) {
            ThEBasePacket.writePlayer(this.player, stream);
        }
        stream.writeBoolean(this.useCompression);
        if (this.useCompression) {
            this.toCompressedBytes(stream);
        } else {
            this.writeData(stream);
        }
    }
}

