/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.integration.tc;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.HashMap;
import java.util.HashSet;
import thaumicenergistics.api.entities.IGolemHookHandler;
import thaumicenergistics.api.entities.IGolemHookSyncRegistry;
import thaumicenergistics.common.utils.ThELog;

class GolemSyncRegistry
implements IGolemHookSyncRegistry {
    private static final HashMap<Integer, IGolemHookHandler> handlerMappings = new HashMap();
    private final HashMap<Integer, Character> dataMappings = new HashMap();
    private Integer uuid = 13;
    private boolean hasDataChanged = false;
    public boolean canRegister = false;
    public String lastUpdatedFrom = null;
    public float clientSyncTicks = 0.0f;

    GolemSyncRegistry() {
    }

    public void copyDefaults(GolemSyncRegistry defaults) {
        this.dataMappings.clear();
        this.dataMappings.putAll(defaults.dataMappings);
        this.hasDataChanged = true;
    }

    @Override
    public char getSyncCharOrDefault(int id, char defaultChar) {
        return this.dataMappings.getOrDefault(id, Character.valueOf(defaultChar)).charValue();
    }

    public boolean hasChanged() {
        return this.hasDataChanged;
    }

    /*
     * Exception decompiling
     */
    public String mappingsToString() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void markDirty() {
        this.hasDataChanged = true;
    }

    public HashSet<IGolemHookHandler> readFromString(String data) {
        if (data == null || data.length() < 4) {
            ThELog.warning("Incomplete golem sync data received", new Object[0]);
            return null;
        }
        HashSet<IGolemHookHandler> handlersToUpdate = new HashSet<IGolemHookHandler>();
        this.hasDataChanged = false;
        this.lastUpdatedFrom = data;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data.getBytes(Charsets.UTF_8.name()));
             DataInputStream stream = new DataInputStream(bais);){
            int count = stream.readInt();
            for (int i = 0; i < count; ++i) {
                Integer id = stream.readInt();
                Character c = Character.valueOf(stream.readChar());
                this.dataMappings.put(id, c);
                handlersToUpdate.add(handlerMappings.get(id));
            }
            stream.close();
        }
        catch (Exception e) {
            ThELog.error(e, "Malformed golem sync data received", new Object[0]);
        }
        if (!handlersToUpdate.isEmpty()) {
            return handlersToUpdate;
        }
        return null;
    }

    @Override
    public int registerSyncChar(IGolemHookHandler handler, char c) {
        if (!this.canRegister) {
            throw new UnsupportedOperationException("Can not register new sync data at this location.");
        }
        this.dataMappings.put(this.uuid, Character.valueOf(c));
        handlerMappings.put(this.uuid, handler);
        this.hasDataChanged = true;
        int id = this.uuid;
        this.uuid = id + 1;
        return id;
    }

    @Override
    public void updateSyncChar(IGolemHookHandler handler, int id, char c) {
        Integer ID = id;
        if (!this.dataMappings.containsKey(ID)) {
            throw new UnsupportedOperationException("Unable to update sync byte '" + Integer.toString(id) + "', that ID is not mapped");
        }
        IGolemHookHandler registeredHandler = handlerMappings.get(ID);
        if (registeredHandler != handler) {
            throw new UnsupportedOperationException("Unable to update sync byte '" + Integer.toString(id) + "', that ID does not belong to you.");
        }
        Character newValue = Character.valueOf(c);
        if (this.dataMappings.put(ID, newValue) != newValue) {
            this.hasDataChanged = true;
        }
    }
}

