/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import thaumicenergistics.client.gui.EnumGuiParticles;
import thaumicenergistics.client.gui.GuiParticleAnimator;
import thaumicenergistics.client.gui.abstraction.ThEBaseGui;
import thaumicenergistics.client.gui.buttons.GuiButtonClearCraftingGrid;
import thaumicenergistics.client.gui.buttons.GuiButtonSaveDelete;
import thaumicenergistics.client.textures.GuiTextureManager;
import thaumicenergistics.common.container.ContainerKnowledgeInscriber;
import thaumicenergistics.common.network.packet.server.Packet_S_KnowledgeInscriber;
import thaumicenergistics.common.registries.ThEStrings;

@SideOnly(value=Side.CLIENT)
public class GuiKnowledgeInscriber
extends ThEBaseGui {
    private static final int GUI_WIDTH = 210;
    private static final int GUI_HEIGHT = 244;
    private static final int BUTTON_SAVE_POS_X = 141;
    private static final int BUTTON_SAVE_POS_Y = 109;
    private static final int BUTTON_CLEAR_POS_X = 80;
    private static final int BUTTON_CLEAR_POS_Y = 89;
    private static final int TITLE_POS_X = 6;
    private static final int TITLE_POS_Y = 6;
    private final EntityPlayer player;
    private final GuiParticleAnimator[] particles;
    private final String title;
    private GuiButtonSaveDelete buttonSave;
    private GuiButtonClearCraftingGrid buttonClear;
    private ContainerKnowledgeInscriber.CoreSaveState saveState = ContainerKnowledgeInscriber.CoreSaveState.Disabled_MissingCore;
    private boolean hasParticlesToDraw = false;

    public GuiKnowledgeInscriber(EntityPlayer player, World world, int x, int y, int z) {
        super(new ContainerKnowledgeInscriber(player, world, x, y, z));
        this.player = player;
        this.field_146999_f = 210;
        this.field_147000_g = 244;
        this.title = ThEStrings.Block_KnowledgeInscriber.getLocalized();
        this.particles = new GuiParticleAnimator[9];
        for (int index = 0; index < this.particles.length; ++index) {
            this.particles[index] = this.createSaveParticle(index);
        }
    }

    private GuiParticleAnimator createSaveParticle(int slotNumber) {
        int startX = 26 + slotNumber % 3 * 18;
        int startY = 90 + slotNumber / 3 * 18;
        GuiParticleAnimator gpa = new GuiParticleAnimator(startX, startY, 186, 8, 0.4f, EnumGuiParticles.Knowledge);
        gpa.red = 0.2f;
        gpa.green = 0.5f;
        gpa.blue = 1.0f;
        gpa.setDelayTime(slotNumber * 50);
        return gpa;
    }

    private void drawSaveParticles() {
        this.hasParticlesToDraw = false;
        EnumGuiParticles.Knowledge.prepareDraw();
        for (int index = 0; index < this.particles.length; ++index) {
            this.hasParticlesToDraw |= this.particles[index].draw((Gui)this, false);
        }
        EnumGuiParticles.finishDraw();
    }

    protected void func_146976_a(float alpha, int mouseX, int mouseY) {
        long slowTime = System.currentTimeMillis() / 100L;
        float redBounce = Math.abs(1.0f - (float)(slowTime % 50L) / 50.0f * 2.0f);
        float greenBounce = 1.0f - redBounce;
        GL11.glColor4f((float)redBounce, (float)greenBounce, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("thaumicenergistics", "textures/research/Research.Background.png"));
        int xpos = (int)(slowTime % 10L);
        this.func_73729_b(this.field_147003_i + 80, this.field_147009_r + 106, 55 - xpos, 25, 35, 20);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiTextureManager.KNOWLEDGE_INSCRIBER.getTexture());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.title, 6, 6, 0);
        if (this.hasParticlesToDraw) {
            this.drawSaveParticles();
        }
    }

    @Override
    protected void onButtonClicked(GuiButton button, int mouseButton) {
        if (button == this.buttonSave) {
            Packet_S_KnowledgeInscriber.sendSaveDelete(this.player);
        } else if (button == this.buttonClear) {
            Packet_S_KnowledgeInscriber.sendClearGrid(this.player);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.buttonSave = new GuiButtonSaveDelete(0, this.field_147003_i + 141, this.field_147009_r + 109, this.saveState);
        this.field_146292_n.add(this.buttonSave);
        this.buttonClear = new GuiButtonClearCraftingGrid(1, this.field_147003_i + 80, this.field_147009_r + 89, 8, 8, false);
        this.field_146292_n.add(this.buttonClear);
        Packet_S_KnowledgeInscriber.sendFullUpdateRequest(this.player);
    }

    public void onReceiveSaveState(ContainerKnowledgeInscriber.CoreSaveState saveState, boolean justSaved) {
        this.saveState = saveState;
        if (this.buttonSave != null) {
            this.buttonSave.setSaveState(saveState);
        }
        if (justSaved) {
            for (int index = 0; index < this.particles.length; ++index) {
                this.particles[index].reset();
            }
            this.hasParticlesToDraw = true;
        }
    }
}

