/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.storage;

import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.DimensionManager;

public class FileUtils {
    public static List<Integer> getExistingAgeList(File dataDir) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (File var6 : dataDir.listFiles()) {
            if (!var6.getName().startsWith("agedata_") || !var6.getName().endsWith(".dat")) continue;
            try {
                String dimStr = var6.getName();
                dimStr = dimStr.substring(8, dimStr.length() - 4);
                list.add(Integer.parseInt(dimStr));
            }
            catch (Exception e) {
                LoggerUtils.warn("Error parsing dim id from " + var6.getName(), new Object[0]);
            }
        }
        return list;
    }

    public static boolean deleteAgeChunkData(Integer dimid) {
        File rootdir = DimensionManager.getCurrentSaveRootDirectory();
        File dimensionfolder = new File(rootdir, WorldProviderMyst.getSaveFolderName(dimid));
        if (!dimensionfolder.exists()) {
            return true;
        }
        try {
            org.apache.commons.io.FileUtils.deleteDirectory((File)dimensionfolder);
        }
        catch (IOException e) {
            LoggerUtils.error("Failed to delete dimension chunk data for dimension " + dimid, new Object[0]);
            return false;
        }
        return !dimensionfolder.exists();
    }
}

