/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.villager;

import com.google.common.collect.MapMaker;
import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.client.gui.GuiHandlerManager;
import com.xcompwiz.mystcraft.client.gui.GuiVillagerShop;
import com.xcompwiz.mystcraft.inventory.ContainerVillagerShop;
import com.xcompwiz.mystcraft.inventory.InventoryVillager;
import com.xcompwiz.mystcraft.nbt.NBTUtils;
import com.xcompwiz.mystcraft.network.NetworkUtils;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.EntityInteractEvent;

public class VillagerTradeSystem {
    private static final int GuiID = GuiHandlerManager.registerGuiNetHandler(new GuiHandlerVillager());
    private static ConcurrentMap<EntityVillager, InventoryVillager> villagers = new MapMaker().weakKeys().weakValues().makeMap();
    private static long tick_accumulator = 0L;

    public static boolean onVillagerInteraction(EntityInteractEvent event) {
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            return false;
        }
        if (!(event.target instanceof EntityVillager)) {
            return false;
        }
        EntityVillager villager = (EntityVillager)event.target;
        if (villager.func_70946_n() != Mystcraft.archivistId) {
            return false;
        }
        NetworkUtils.displayGui(event.entityPlayer, event.entityPlayer.field_70170_p, GuiID, event.target);
        return true;
    }

    public static void onTick() {
        if (++tick_accumulator % 1000L == 0L) {
            for (InventoryVillager villagerinv : villagers.values()) {
                villagerinv.simulate();
            }
        }
    }

    public static InventoryVillager getVillagerInventory(EntityVillager villager) {
        if (villager.field_70170_p.field_72995_K) {
            return new InventoryVillager(villager);
        }
        InventoryVillager villagerinv = (InventoryVillager)villagers.get(villager);
        if (villagerinv == null) {
            villagerinv = new InventoryVillager(villager);
            villagerinv.readFromNBT(villager.getEntityData().func_74775_l("Mystcraft").func_74775_l("Trade"));
            villagers.put(villager, villagerinv);
            villagerinv.simulate();
        }
        return villagerinv;
    }

    public static void release(InventoryVillager villagerinv) {
        if (villagerinv.isDirty()) {
            villagerinv.writeToNBT(NBTUtils.forceGetCompound(NBTUtils.forceGetCompound(villagerinv.getVillager().getEntityData(), "Mystcraft"), "Trade"));
        }
    }

    public static int getCardCost(ItemStack itemstack) {
        if (itemstack == null) {
            return 0;
        }
        Integer rank = SymbolManager.getSymbolItemCardRank(Page.getSymbol(itemstack));
        if (rank == null) {
            return 100;
        }
        return 4 * (1 + rank);
    }

    public static class GuiHandlerVillager
    extends GuiHandlerManager.GuiHandler {
        @Override
        public Container getContainer(EntityPlayerMP player, World worldObj, Entity entity) {
            return new ContainerVillagerShop(player.field_71071_by, (EntityVillager)entity);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiScreen getGuiScreen(EntityPlayer player, ByteBuf data) {
            int entityId = data.readInt();
            Entity entity = Mystcraft.sidedProxy.getEntityByID(player.field_70170_p, entityId);
            if (entity != null && entity instanceof EntityVillager) {
                return new GuiVillagerShop(player.field_71071_by, (EntityVillager)entity);
            }
            return null;
        }
    }
}

