/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.symbol.WeatherControllerToggleable;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class SymbolWeatherStorm
extends SymbolBase {
    public SymbolWeatherStorm(String identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        controller.registerInterface(new WeatherController());
    }

    private static class WeatherController
    extends WeatherControllerToggleable {
        private Random random = new Random();
        private int updateLCG = this.random.nextInt();

        private WeatherController() {
        }

        @Override
        protected void onEnable() {
            this.rainingStrength = 1.0;
            this.thunderingStrength = 1.0;
            this.rainEnabled = true;
            this.snowEnabled = false;
        }

        @Override
        protected void onDisable() {
            this.rainingStrength = 0.0;
            this.thunderingStrength = 0.0;
        }

        @Override
        public void tick(World worldObj, Chunk chunk) {
            int var5 = chunk.field_76635_g * 16;
            int var6 = chunk.field_76647_h * 16;
            if (worldObj.func_72896_J() && worldObj.func_72911_I() && worldObj.field_73012_v.nextInt(100000) == 0) {
                this.updateLCG = this.updateLCG * 3 + 1013904223;
                int var8 = this.updateLCG >> 2;
                int var9 = var5 + (var8 & 0xF);
                int var10 = var6 + (var8 >> 8 & 0xF);
                int var11 = worldObj.func_72874_g(var9, var10);
                if (this.canLightningStrikeAt(worldObj, var9, var11, var10)) {
                    worldObj.func_72942_c((Entity)new EntityLightningBolt(worldObj, (double)var9, (double)var11, (double)var10));
                }
            }
        }

        @Override
        public float getTemperature(float current, int biomeId) {
            if (current < 0.2f) {
                return 0.2f;
            }
            return current;
        }

        public boolean canLightningStrikeAt(World worldObj, int par1, int par2, int par3) {
            if (!worldObj.func_72896_J()) {
                return false;
            }
            if (!worldObj.func_72937_j(par1, par2, par3)) {
                return false;
            }
            return worldObj.func_72874_g(par1, par3) <= par2;
        }
    }
}

