/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.modifiers;

import com.xcompwiz.mystcraft.api.symbol.BlockDescriptor;
import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class SymbolBlock
extends SymbolBase {
    private BlockDescriptor blockDescriptor;
    private String displayName;

    public SymbolBlock(BlockDescriptor block, String word) {
        super("ModMat_" + SymbolBlock.getBlockAsItem(block).func_77977_a());
        this.blockDescriptor = block;
        this.setWords(new String[]{"Transform", "Constraint", word, SymbolBlock.getBlockAsItem(block).func_77977_a()});
        this.displayName = SymbolBlock.formatted(block);
    }

    private static String formatted(BlockDescriptor blockDescriptor) {
        String name = SymbolBlock.getBlockAsItem(blockDescriptor).func_82833_r();
        if (name.endsWith("Block")) {
            name = name.substring(0, name.length() - "Block".length()).trim();
        }
        name = StatCollector.func_74837_a((String)"myst.symbol.block.wrapper", (Object[])new Object[]{name});
        return name;
    }

    private static ItemStack getBlockAsItem(BlockDescriptor blockDescriptor) {
        Block block = blockDescriptor.block;
        if (block == null) {
            throw new RuntimeException("Block id " + blockDescriptor.block + " is not a valid block!");
        }
        ItemStack itemstack = new ItemStack(block, 1, (int)blockDescriptor.metadata);
        if (itemstack.func_77973_b() == null) {
            throw new RuntimeException("Invalid item form for block " + block.func_149739_a() + "with metadata " + blockDescriptor.metadata);
        }
        return itemstack;
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        ModifierUtils.pushBlock(controller, this.blockDescriptor);
    }

    @Override
    public String displayName() {
        return this.displayName;
    }
}

