/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.nbt;

import com.xcompwiz.mystcraft.item.ItemStackUtils;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public final class NBTUtils {
    public static Number readNumber(NBTBase tag) {
        if (tag == null) {
            return 0;
        }
        if (tag instanceof NBTTagByte) {
            return ((NBTTagByte)tag).func_150290_f();
        }
        if (tag instanceof NBTTagShort) {
            return ((NBTTagShort)tag).func_150289_e();
        }
        if (tag instanceof NBTTagInt) {
            return ((NBTTagInt)tag).func_150287_d();
        }
        if (tag instanceof NBTTagLong) {
            return ((NBTTagLong)tag).func_150291_c();
        }
        if (tag instanceof NBTTagFloat) {
            return Float.valueOf(((NBTTagFloat)tag).func_150288_h());
        }
        if (tag instanceof NBTTagDouble) {
            return ((NBTTagDouble)tag).func_150286_g();
        }
        return 0;
    }

    public static String readString(NBTBase tag) {
        if (tag == null) {
            return "";
        }
        if (tag instanceof NBTTagString) {
            return ((NBTTagString)tag).func_150285_a_();
        }
        return tag.toString();
    }

    public static void readInventoryArray(NBTTagList tagList, ItemStack[] inventory) {
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = tagList.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= inventory.length) continue;
            inventory[byte0] = ItemStackUtils.loadItemStackFromNBT(nbttagcompound1);
        }
    }

    public static NBTTagList writeInventoryArray(NBTTagList nbttaglist, ItemStack[] inventory) {
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] == null) continue;
            NBTTagCompound slot = new NBTTagCompound();
            slot.func_74774_a("Slot", (byte)i);
            inventory[i].func_77955_b(slot);
            nbttaglist.func_74742_a((NBTBase)slot);
        }
        return nbttaglist;
    }

    public static <T extends Map<String, Byte>> T readByteMap(NBTTagCompound tagcompound, T map) {
        Set tagnames = tagcompound.func_150296_c();
        for (String tagname : tagnames) {
            map.put((String)tagname, NBTUtils.readNumber(tagcompound.func_74781_a(tagname)).byteValue());
        }
        return map;
    }

    public static NBTTagCompound writeByteMap(NBTTagCompound tagcompound, Map<String, Byte> map) {
        for (String key : map.keySet()) {
            tagcompound.func_74774_a(key, map.get(key).byteValue());
        }
        return tagcompound;
    }

    public static <T extends Map<String, Integer>> T readIntMap(NBTTagCompound tagcompound, T map) {
        Set tagnames = tagcompound.func_150296_c();
        for (String tagname : tagnames) {
            map.put((String)tagname, NBTUtils.readNumber(tagcompound.func_74781_a(tagname)).intValue());
        }
        return map;
    }

    public static NBTTagCompound writeIntMap(NBTTagCompound tagcompound, Map<String, Integer> map) {
        for (String key : map.keySet()) {
            tagcompound.func_74768_a(key, map.get(key).intValue());
        }
        return tagcompound;
    }

    public static <T extends Map<String, Float>> T readFloatMap(NBTTagCompound tagcompound, T map) {
        Set tagnames = tagcompound.func_150296_c();
        for (String tagname : tagnames) {
            map.put((String)tagname, (Float)Float.valueOf(NBTUtils.readNumber(tagcompound.func_74781_a(tagname)).floatValue()));
        }
        return map;
    }

    public static NBTTagCompound writeFloatMap(NBTTagCompound tagcompound, Map<String, Float> map) {
        for (String key : map.keySet()) {
            tagcompound.func_74776_a(key, map.get(key).floatValue());
        }
        return tagcompound;
    }

    public static <T extends Map<String, String>> T readStringMap(NBTTagCompound tagcompound, T map) {
        Set tagnames = tagcompound.func_150296_c();
        for (String tagname : tagnames) {
            map.put((String)tagname, (String)tagcompound.func_74779_i(tagname));
        }
        return map;
    }

    public static NBTTagCompound writeStringMap(NBTTagCompound tagcompound, Map<String, String> map) {
        for (String key : map.keySet()) {
            tagcompound.func_74778_a(key, map.get(key));
        }
        return tagcompound;
    }

    public static NBTTagList writeStringCollection(NBTTagList nbttaglist, Collection<String> collection) {
        for (String str : collection) {
            if (str == null) continue;
            nbttaglist.func_74742_a((NBTBase)new NBTTagString(str));
        }
        return nbttaglist;
    }

    public static <T extends Collection<String>> T readStringCollection(NBTTagList nbttaglist, T collection) {
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            collection.add((String)nbttaglist.func_150307_f(i));
        }
        return collection;
    }

    public static NBTTagList writeTagCompoundCollection(NBTTagList nbttaglist, Collection<NBTTagCompound> collection) {
        for (NBTTagCompound tag : collection) {
            if (tag == null) continue;
            nbttaglist.func_74742_a((NBTBase)tag);
        }
        return nbttaglist;
    }

    public static <T extends Collection<NBTTagCompound>> T readTagCompoundCollection(NBTTagList nbttaglist, T collection) {
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            collection.add((NBTTagCompound)nbttaglist.func_150305_b(i));
        }
        return collection;
    }

    public static NBTTagList writeItemStackCollection(NBTTagList nbttaglist, Collection<ItemStack> collection) {
        for (ItemStack itemstack : collection) {
            if (itemstack == null) continue;
            nbttaglist.func_74742_a((NBTBase)itemstack.func_77955_b(new NBTTagCompound()));
        }
        return nbttaglist;
    }

    public static <T extends Collection<ItemStack>> T readItemStackCollection(NBTTagList nbttaglist, T collection) {
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            collection.add((ItemStack)ItemStack.func_77949_a((NBTTagCompound)nbttaglist.func_150305_b(i)));
        }
        return collection;
    }

    public static NBTTagCompound readNBTTagCompound(ByteBuf data) throws IOException {
        short length = data.readShort();
        if (length < 0) {
            return null;
        }
        byte[] abyte = new byte[length];
        data.readBytes(abyte);
        return CompressedStreamTools.func_152457_a((byte[])abyte, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
    }

    public static int writeNBTTagCompound(NBTTagCompound nbttagcompound, ByteBuf data) throws IOException {
        if (nbttagcompound != null) {
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)nbttagcompound);
            data.writeShort((int)((short)abyte.length));
            data.writeBytes(abyte);
            return abyte.length;
        }
        data.writeShort(-1);
        return 0;
    }

    public static NBTTagCompound forceGetCompound(NBTTagCompound nbt, String key) {
        NBTTagCompound tagcompound = nbt.func_74775_l(key);
        nbt.func_74782_a(key, (NBTBase)tagcompound);
        return tagcompound;
    }
}

