/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.logging;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LoggerUtils {
    private static Logger log = null;

    private static void configureLogging() {
        log = LogManager.getLogger((String)"Mystcraft");
    }

    public static void log(Level level, String message, Object ... params) {
        if (log == null) {
            LoggerUtils.configureLogging();
        }
        if (message == null) {
            log.log(level, "Attempted to log null message.");
        } else {
            try {
                message = String.format(message, params);
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.log(level, message);
        }
    }

    public static void info(String message, Object ... params) {
        LoggerUtils.log(Level.INFO, message, params);
    }

    public static void warn(String message, Object ... params) {
        LoggerUtils.log(Level.WARN, message, params);
    }

    public static void error(String message, Object ... params) {
        LoggerUtils.log(Level.ERROR, message, params);
    }

    public static void debug(String message, Object ... params) {
    }
}

