/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.item;

import com.xcompwiz.mystcraft.api.event.PortalLinkEvent;
import com.xcompwiz.mystcraft.api.item.IItemPortalActivator;
import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import com.xcompwiz.mystcraft.client.gui.GuiBook;
import com.xcompwiz.mystcraft.client.gui.GuiHandlerManager;
import com.xcompwiz.mystcraft.entity.EntityLinkbook;
import com.xcompwiz.mystcraft.inventory.ContainerBook;
import com.xcompwiz.mystcraft.linking.DimensionUtils;
import com.xcompwiz.mystcraft.linking.LinkController;
import com.xcompwiz.mystcraft.linking.LinkListenerManager;
import com.xcompwiz.mystcraft.linking.LinkOptions;
import com.xcompwiz.mystcraft.network.NetworkUtils;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public abstract class ItemLinking
extends Item
implements IItemPortalActivator {
    private static final int GuiID = GuiHandlerManager.registerGuiNetHandler(new GuiHandlerBookItem());

    protected ItemLinking() {
        this.func_77625_d(1);
        this.func_77656_e(10);
        this.canRepair = false;
    }

    public boolean func_77651_p() {
        return true;
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isBookEnchantable(ItemStack itemstack, ItemStack enchantbook) {
        return false;
    }

    protected abstract void initialize(World var1, ItemStack var2, Entity var3);

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        if (world.field_72995_K) {
            return;
        }
        this.validate(world, itemstack, entity);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean advancedTooltip) {
        String name;
        if (itemstack.field_77990_d != null && (name = LinkOptions.getDisplayName(itemstack.field_77990_d)) != null && !name.equals("")) {
            list.add(name);
        }
    }

    public void activate(ItemStack itemstack, World world, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        if (itemstack.field_77990_d == null) {
            return;
        }
        ILinkInfo linkinfo = this.getLinkInfo(itemstack);
        if (LinkListenerManager.isLinkPermitted(world, entity, linkinfo)) {
            LinkOptions.setUUID(itemstack.field_77990_d, DimensionUtils.getDimensionUUID(linkinfo.getDimensionUID()));
            this.onLink(itemstack, world, entity);
            LinkController.travelEntity(world, entity, linkinfo);
        }
    }

    protected void onLink(ItemStack itemstack, World world, Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            if (entityplayer.field_71071_by.func_70448_g() != itemstack) {
                return;
            }
            if (this.dropItemOnLink(itemstack)) {
                world.func_72838_d(this.createEntity(world, (Entity)entityplayer, itemstack));
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
            }
        }
    }

    @Override
    public void onPortalCollision(ItemStack book, World worldObj, Entity entity, int par2, int par3, int par4) {
        ILinkInfo info = ((ItemLinking)book.func_77973_b()).getLinkInfo(book);
        info.setFlag("Maintain Momentum", true);
        info.setFlag("Generate Platform", false);
        info.setFlag("External", true);
        info.setProperty("Sound", "mystcraft:linking.link-portal");
        MinecraftForge.EVENT_BUS.post((Event)new PortalLinkEvent(worldObj, entity, info));
        LinkController.travelEntity(worldObj, entity, info);
    }

    @Override
    public int getPortalColor(ItemStack itemstack, World worldObj) {
        ILinkInfo info = ((ItemLinking)itemstack.func_77973_b()).getLinkInfo(itemstack);
        return DimensionUtils.getLinkColor(info);
    }

    public boolean hasEffect(ItemStack itemstack, int pass) {
        return LinkOptions.getFlag(itemstack.field_77990_d, "Following");
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityLinkbook(world, location, itemstack);
    }

    public boolean dropItemOnLink(ItemStack itemstack) {
        return !LinkOptions.getFlag(itemstack.field_77990_d, "Following");
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.field_72995_K) {
            NetworkUtils.displayGui(entityplayer, world, GuiID, itemstack);
        }
        return itemstack;
    }

    public boolean isDamaged(ItemStack stack) {
        return ItemLinking.getHealth(stack) != ItemLinking.getMaxHealth(stack);
    }

    public int getDamage(ItemStack stack) {
        return (int)ItemLinking.getMaxHealth(stack) - (int)ItemLinking.getHealth(stack);
    }

    public int getDisplayDamage(ItemStack stack) {
        return (int)ItemLinking.getMaxHealth(stack) - (int)ItemLinking.getHealth(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        ItemLinking.setHealth(stack, ItemLinking.getMaxHealth(stack) - (float)damage);
    }

    public int getMaxDamage(ItemStack stack) {
        return (int)ItemLinking.getMaxHealth(stack);
    }

    public static void setHealth(ItemStack book, float health) {
        if (book == null) {
            return;
        }
        if (book.field_77990_d == null) {
            book.field_77990_d = new NBTTagCompound();
        }
        book.field_77990_d.func_74776_a("damage", ItemLinking.getMaxHealth(book) - health);
    }

    public static float getHealth(ItemStack book) {
        float health = ItemLinking.getMaxHealth(book);
        if (book == null) {
            return health;
        }
        if (book.field_77990_d == null) {
            return health;
        }
        Float damage = Float.valueOf(book.field_77990_d.func_74760_g("damage"));
        if (damage != null) {
            health -= damage.floatValue();
        }
        return health;
    }

    public static float getMaxHealth(ItemStack book) {
        float health = 10.0f;
        if (book == null) {
            return health;
        }
        if (book.field_77990_d == null) {
            return health;
        }
        if (!book.field_77990_d.func_74764_b("MaxHealth")) {
            book.field_77990_d.func_74776_a("MaxHealth", health);
        }
        health = book.field_77990_d.func_74760_g("MaxHealth");
        return health;
    }

    public void validate(World worldObj, ItemStack itemstack, Entity entity) {
        if (itemstack.field_77990_d == null) {
            this.initialize(worldObj, itemstack, entity);
        }
    }

    public String getTitle(ItemStack itemstack) {
        if (itemstack.field_77990_d != null) {
            return LinkOptions.getDisplayName(itemstack.field_77990_d);
        }
        return "";
    }

    public ILinkInfo getLinkInfo(ItemStack itemstack) {
        if (itemstack.field_77990_d != null) {
            LinkOptions info = new LinkOptions(itemstack.field_77990_d);
            return info;
        }
        return null;
    }

    public Collection<String> getAuthors(ItemStack book) {
        return Collections.EMPTY_SET;
    }

    public static class GuiHandlerBookItem
    extends GuiHandlerManager.GuiHandler {
        @Override
        public Container getContainer(EntityPlayerMP player, World worldObj, ItemStack itemstack, int slot) {
            return new ContainerBook(player.field_71071_by, slot);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiScreen getGuiScreen(EntityPlayer player, ByteBuf data) {
            byte slot = data.readByte();
            ItemStack itemstack = player.field_71071_by.func_70301_a((int)slot);
            if (itemstack != null) {
                return new GuiBook(player.field_71071_by, slot);
            }
            return null;
        }
    }
}

