/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.item;

import com.xcompwiz.mystcraft.api.item.IItemPageProvider;
import com.xcompwiz.mystcraft.api.item.IItemWritable;
import com.xcompwiz.mystcraft.data.ModAchievements;
import com.xcompwiz.mystcraft.item.IItemOnLoadable;
import com.xcompwiz.mystcraft.item.ItemLinking;
import com.xcompwiz.mystcraft.linking.DimensionUtils;
import com.xcompwiz.mystcraft.linking.LinkOptions;
import com.xcompwiz.mystcraft.nbt.NBTUtils;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.SymbolRemappings;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;

public class ItemAgebook
extends ItemLinking
implements IItemWritable,
IItemPageProvider,
IItemOnLoadable {
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("mystcraft:agebook");
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return itemstack.func_77948_v() ? EnumRarity.rare : EnumRarity.epic;
    }

    @Override
    protected void initialize(World world, ItemStack itemstack, Entity entity) {
        if (itemstack.field_77990_d == null) {
            itemstack.field_77990_d = new NBTTagCompound();
            LinkOptions.setFlag(itemstack.field_77990_d, "Generate Platform", true);
            this.addPages(itemstack, this.getDefaultPages(itemstack));
        }
    }

    @Override
    public void validate(World worldObj, ItemStack itemstack, Entity entity) {
        super.validate(worldObj, itemstack, entity);
        if (itemstack.field_77990_d != null && !itemstack.field_77990_d.func_74764_b("Pages")) {
            this.addPages(itemstack, this.getDefaultPages(itemstack));
        }
    }

    private Collection<ItemStack> getDefaultPages(ItemStack itemstack) {
        Collection<ItemStack> collection = Collections.singleton(Page.createLinkPage());
        Integer dimid = LinkOptions.getDimensionUID(itemstack.field_77990_d);
        if (dimid == null) {
            return collection;
        }
        AgeData data = AgeData.getAge((int)dimid, false);
        if (data == null) {
            return collection;
        }
        collection = data.getPages();
        return collection;
    }

    public static void initializeCompound(ItemStack itemstack, int dimId, AgeData agedata) {
        itemstack.func_77982_d(new NBTTagCompound());
        LinkOptions.setDimensionUID(itemstack.field_77990_d, dimId);
        LinkOptions.setUUID(itemstack.field_77990_d, agedata.getUUID());
        LinkOptions.setDisplayName(itemstack.field_77990_d, agedata.getAgeName());
        LinkOptions.setFlag(itemstack.field_77990_d, "Generate Platform", true);
        ((ItemAgebook)itemstack.func_77973_b()).addPages(itemstack, agedata.getPages());
    }

    public static void create(ItemStack agebook, EntityPlayer player, List<ItemStack> pages, String pendingtitle) {
        agebook.field_77990_d = new NBTTagCompound();
        ((ItemAgebook)agebook.func_77973_b()).addPages(agebook, pages);
        ((ItemAgebook)agebook.func_77973_b()).addAuthor(agebook, player);
        ((ItemAgebook)agebook.func_77973_b()).setDisplayName(player, agebook, pendingtitle);
        if (pages.isEmpty()) {
            return;
        }
        ItemStack linkpanel = pages.get(0);
        if (Page.isLinkPanel(linkpanel)) {
            Page.applyLinkPanel(linkpanel, agebook);
        }
    }

    public static boolean isNewAgebook(ItemStack itemstack) {
        if (!(itemstack.func_77973_b() instanceof ItemAgebook)) {
            return false;
        }
        if (itemstack.field_77990_d == null) {
            return false;
        }
        Integer dimid = LinkOptions.getDimensionUID(itemstack.field_77990_d);
        if (dimid != null) {
            return false;
        }
        List<ItemStack> pages = ((ItemAgebook)itemstack.func_77973_b()).getPageList(null, itemstack);
        if (pages.isEmpty()) {
            return false;
        }
        return Page.isLinkPanel(pages.get(0));
    }

    public void func_77622_d(ItemStack par1ItemStack, World par2World, EntityPlayer player) {
        player.func_71064_a((StatBase)ModAchievements.agebook, 1);
    }

    @Override
    public void activate(ItemStack itemstack, World worldObj, Entity entity) {
        if (worldObj.field_72995_K) {
            return;
        }
        this.checkFirstLink(itemstack, worldObj, entity);
        super.activate(itemstack, worldObj, entity);
    }

    private void checkFirstLink(ItemStack itemstack, World worldObj, Entity entity) {
        if (itemstack.field_77990_d == null) {
            return;
        }
        Integer dimid = LinkOptions.getDimensionUID(itemstack.field_77990_d);
        if (dimid != null) {
            return;
        }
        dimid = DimensionUtils.createAge();
        AgeData agedata = AgeData.getAge((int)dimid, false);
        LinkOptions.setDimensionUID(itemstack.field_77990_d, dimid);
        LinkOptions.setUUID(itemstack.field_77990_d, agedata.getUUID());
        agedata.setAgeName(LinkOptions.getDisplayName(itemstack.field_77990_d));
        this.updatePageList(itemstack);
        agedata.setPages(this.getPageList(null, itemstack));
    }

    @Override
    public String getDisplayName(EntityPlayer player, ItemStack itemstack) {
        return LinkOptions.getDisplayName(itemstack.field_77990_d);
    }

    @Override
    public void setDisplayName(EntityPlayer player, ItemStack itemstack, String name) {
        LinkOptions.setDisplayName(itemstack.field_77990_d, name);
        AgeData data = this.getAgeData(itemstack, player.field_70170_p.field_72995_K);
        if (data != null) {
            data.setAgeName(name);
        }
    }

    @Override
    public boolean writeSymbol(EntityPlayer player, ItemStack itemstack, String symbol2) {
        if (this.isVisited(itemstack, player.field_70170_p.field_72995_K)) {
            return false;
        }
        if (itemstack.field_77990_d == null) {
            return false;
        }
        NBTTagCompound nbttagcompound = itemstack.field_77990_d;
        ArrayList<ItemStack> list = NBTUtils.readItemStackCollection(nbttagcompound.func_150295_c("Pages", 10), new ArrayList());
        for (ItemStack page : list) {
            if (!Page.isBlank(page)) continue;
            Page.setSymbol(page, symbol2);
            nbttagcompound.func_74782_a("Pages", (NBTBase)NBTUtils.writeItemStackCollection(new NBTTagList(), list));
            this.addAuthor(itemstack, player);
            return true;
        }
        return false;
    }

    private void addPages(ItemStack itemstack, Collection<ItemStack> pages) {
        if (itemstack.field_77990_d == null) {
            return;
        }
        NBTTagCompound nbttagcompound = itemstack.field_77990_d;
        ArrayList<ItemStack> list = NBTUtils.readItemStackCollection(nbttagcompound.func_150295_c("Pages", 10), new ArrayList());
        list.addAll(pages);
        nbttagcompound.func_74782_a("Pages", (NBTBase)NBTUtils.writeItemStackCollection(new NBTTagList(), list));
    }

    @Override
    public List<ItemStack> getPageList(EntityPlayer player, ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return Collections.EMPTY_LIST;
        }
        NBTTagCompound nbttagcompound = itemstack.field_77990_d;
        return NBTUtils.readItemStackCollection(nbttagcompound.func_150295_c("Pages", 10), new ArrayList());
    }

    private void setPageList(ItemStack itemstack, List<ItemStack> pagelist) {
        if (itemstack.field_77990_d == null) {
            return;
        }
        NBTTagCompound nbttagcompound = itemstack.field_77990_d;
        nbttagcompound.func_74782_a("Pages", (NBTBase)NBTUtils.writeItemStackCollection(new NBTTagList(), pagelist));
    }

    private void updatePageList(ItemStack itemstack) {
        this.setPageList(itemstack, SymbolRemappings.remap(this.getPageList(null, itemstack)));
    }

    private void addAuthor(ItemStack itemstack, EntityPlayer player) {
        if (itemstack.field_77990_d == null) {
            return;
        }
        NBTTagCompound nbttagcompound = itemstack.field_77990_d;
        ArrayList<String> list = NBTUtils.readStringCollection(nbttagcompound.func_150295_c("Authors", 8), new ArrayList());
        list.add(player.getDisplayName());
        nbttagcompound.func_74782_a("Authors", (NBTBase)NBTUtils.writeStringCollection(new NBTTagList(), list));
    }

    @Override
    public Collection<String> getAuthors(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return Collections.EMPTY_LIST;
        }
        NBTTagCompound nbttagcompound = itemstack.field_77990_d;
        return NBTUtils.readStringCollection(nbttagcompound.func_150295_c("Authors", 8), new ArrayList());
    }

    private AgeData getAgeData(ItemStack itemstack, boolean isRemote) {
        if (itemstack.field_77990_d == null) {
            return null;
        }
        Integer uid = LinkOptions.getDimensionUID(itemstack.field_77990_d);
        if (uid == null) {
            return null;
        }
        return AgeData.getAge((int)uid, isRemote);
    }

    private boolean isVisited(ItemStack itemstack, boolean isRemote) {
        AgeData agedata = this.getAgeData(itemstack, isRemote);
        if (agedata == null) {
            return false;
        }
        return agedata.isVisited();
    }

    @Override
    public ItemStack onLoad(ItemStack itemstack) {
        this.updatePageList(itemstack);
        this.initialize(null, itemstack, null);
        this.validate(null, itemstack, null);
        if (this.getPageList(null, itemstack).isEmpty()) {
            this.addPages(itemstack, this.getDefaultPages(itemstack));
        }
        return itemstack;
    }
}

