/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.inventory;

import com.xcompwiz.mystcraft.api.impl.InternalAPI;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.symbol.SymbolRemappings;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class InventoryFolder {
    public static boolean isItemValid(ItemStack itemstack) {
        if (itemstack == null) {
            return true;
        }
        if (itemstack.field_77994_a != 1) {
            return false;
        }
        if (itemstack.func_77973_b() == ModItems.page) {
            return true;
        }
        return itemstack.func_77973_b() == Items.field_151121_aF;
    }

    private static void initFolder(ItemStack folder) {
        if (folder.field_77990_d == null) {
            folder.field_77990_d = new NBTTagCompound();
        }
    }

    public static void setName(ItemStack folder, String bookname) {
        if (folder == null) {
            return;
        }
        if (folder.func_77973_b() != ModItems.folder) {
            return;
        }
        if (folder.field_77990_d == null) {
            InventoryFolder.initFolder(folder);
        }
        if (bookname == null || bookname.equals("")) {
            folder.field_77990_d.func_82580_o("Name");
        } else {
            folder.field_77990_d.func_74778_a("Name", bookname);
        }
    }

    public static String getName(ItemStack folder) {
        if (folder == null) {
            return null;
        }
        if (folder.func_77973_b() != ModItems.folder) {
            return null;
        }
        if (folder.field_77990_d == null) {
            InventoryFolder.initFolder(folder);
        }
        if (!folder.field_77990_d.func_74764_b("Name")) {
            return null;
        }
        return folder.field_77990_d.func_74779_i("Name");
    }

    private static NBTTagCompound getInventoryCompound(ItemStack folder) {
        if (folder == null) {
            return null;
        }
        if (folder.func_77973_b() != ModItems.folder) {
            return null;
        }
        if (folder.field_77990_d == null) {
            InventoryFolder.initFolder(folder);
        }
        if (!folder.field_77990_d.func_74764_b("Pages")) {
            folder.field_77990_d.func_74782_a("Pages", (NBTBase)new NBTTagCompound());
        }
        return folder.field_77990_d.func_74775_l("Pages");
    }

    public static int getItemCount(ItemStack folder) {
        if (InventoryFolder.getInventoryCompound(folder) == null) {
            return 0;
        }
        return InventoryFolder.getInventoryCompound(folder).func_150296_c().size();
    }

    public static int getLargestSlotId(ItemStack folder) {
        int largest = -1;
        NBTTagCompound compound = InventoryFolder.getInventoryCompound(folder);
        if (compound == null) {
            return 0;
        }
        Set tagnames = compound.func_150296_c();
        for (String tagname : tagnames) {
            int slot = Integer.parseInt(tagname);
            if (largest >= slot) continue;
            largest = slot;
        }
        return largest;
    }

    public static ItemStack getItem(ItemStack folder, int slot) {
        NBTTagCompound data = InventoryFolder.getInventoryCompound(folder);
        if (data != null && data.func_74764_b("" + slot)) {
            return ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("" + slot));
        }
        return null;
    }

    public static ItemStack setItem(ItemStack folder, int slot, ItemStack page) {
        if (!InventoryFolder.isItemValid(page)) {
            return page;
        }
        NBTTagCompound data = InventoryFolder.getInventoryCompound(folder);
        if (data == null) {
            return page;
        }
        ItemStack previous = null;
        previous = InventoryFolder.removeItem(folder, slot);
        if (page != null && page.field_77994_a > 0) {
            data.func_74782_a("" + slot, (NBTBase)page.func_77955_b(new NBTTagCompound()));
        } else {
            data.func_82580_o("" + slot);
        }
        return previous;
    }

    public static ItemStack removeItem(ItemStack folder, int slot) {
        NBTTagCompound data = InventoryFolder.getInventoryCompound(folder);
        ItemStack itemstack = null;
        if (data != null) {
            if (data.func_74764_b("" + slot)) {
                itemstack = ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("" + slot));
            }
            data.func_82580_o("" + slot);
        }
        return itemstack;
    }

    public static ItemStack addItem(ItemStack folder, ItemStack page) {
        if (!InventoryFolder.isItemValid(page)) {
            return page;
        }
        NBTTagCompound data = InventoryFolder.getInventoryCompound(folder);
        if (data == null) {
            return page;
        }
        int slot = 0;
        while (page != null) {
            if (!data.func_74764_b("" + slot)) {
                ItemStack clone = page.func_77946_l();
                clone.field_77994_a = 1;
                data.func_74782_a("" + slot, (NBTBase)clone.func_77955_b(new NBTTagCompound()));
                --page.field_77994_a;
                if (page.field_77994_a == 0) {
                    page = null;
                }
            }
            ++slot;
        }
        return null;
    }

    public static List<ItemStack> getItems(ItemStack folder) {
        ArrayList<ItemStack> pages = new ArrayList<ItemStack>();
        NBTTagCompound compound = InventoryFolder.getInventoryCompound(folder);
        if (compound == null) {
            return pages;
        }
        Set tagnames = compound.func_150296_c();
        for (String tagname : tagnames) {
            NBTTagCompound pagedata = compound.func_74775_l(tagname);
            int slot = Integer.parseInt(tagname);
            while (pages.size() <= slot) {
                pages.add(null);
            }
            pages.set(slot, ItemStack.func_77949_a((NBTTagCompound)pagedata));
        }
        return pages;
    }

    public static void updatePages(ItemStack folder) {
        NBTTagCompound compound = InventoryFolder.getInventoryCompound(folder);
        if (compound == null) {
            return;
        }
        ArrayList tagnames = new ArrayList();
        tagnames.addAll(compound.func_150296_c());
        for (String tagname : tagnames) {
            NBTTagCompound pagedata = compound.func_74775_l(tagname);
            ItemStack page = ItemStack.func_77949_a((NBTTagCompound)pagedata);
            List<ItemStack> results = SymbolRemappings.remap(page);
            int slot = Integer.parseInt(tagname);
            if (results.size() == 0) {
                InventoryFolder.removeItem(folder, slot);
                continue;
            }
            if (results.size() == 1) {
                InventoryFolder.setItem(folder, slot, results.get(0));
            }
            if (results.size() == 1) continue;
            InventoryFolder.removeItem(folder, slot);
            for (ItemStack item : results) {
                InventoryFolder.addItem(folder, item);
            }
        }
    }

    public static boolean writeSymbol(ItemStack folder, String symbol2) {
        List<ItemStack> pages = InventoryFolder.getItems(folder);
        for (ItemStack page : pages) {
            if (page == null || page.func_77973_b() != ModItems.page || !InternalAPI.page.isPageWritable(page)) continue;
            InternalAPI.page.setPageSymbol(page, symbol2);
            return true;
        }
        return false;
    }
}

