/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.integration.lookingglass;

import com.xcompwiz.lookingglass.api.APIInstanceProvider;
import com.xcompwiz.lookingglass.api.APIUndefined;
import com.xcompwiz.lookingglass.api.APIVersionRemoved;
import com.xcompwiz.lookingglass.api.APIVersionUndefined;
import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.integration.lookingglass.LookingGlassIntegrationView1;
import com.xcompwiz.mystcraft.integration.lookingglass.LookingGlassIntegrationView2;
import com.xcompwiz.mystcraft.integration.lookingglass.MystcraftLookingGlassEventHandler;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import net.minecraftforge.common.MinecraftForge;

public class LookingGlassIntegration {
    public static void register(APIInstanceProvider provider) {
        LoggerUtils.info("LookingGlass API Provider Received", new Object[0]);
        Mystcraft.sidedProxy.initShaders();
        MinecraftForge.EVENT_BUS.register((Object)new MystcraftLookingGlassEventHandler());
        LookingGlassIntegration.getViewAPI(provider);
    }

    private static void getViewAPI(APIInstanceProvider provider) {
        try {
            Object apiinst = provider.getAPIInstance("view-2");
            if (Mystcraft.sidedProxy.isClientSideAvailable()) {
                LookingGlassIntegrationView2.onAPIGetClient(apiinst);
            }
            return;
        }
        catch (APIUndefined e) {
            LoggerUtils.warn("This version of Mystcraft is probably out of date. Please check for updates. LookingGlass integration failure.", new Object[0]);
        }
        catch (APIVersionUndefined e) {
            LoggerUtils.warn("Could not get version 2 of the LookingGlass view API. Attempting to fall back to version 1.", new Object[0]);
        }
        catch (APIVersionRemoved e) {
            LoggerUtils.warn("This version of Mystcraft is probably out of date. Please check for updates. LookingGlass integration failure.", new Object[0]);
        }
        try {
            Object apiinst = provider.getAPIInstance("view-1");
            if (Mystcraft.sidedProxy.isClientSideAvailable()) {
                LookingGlassIntegrationView1.onAPIGetClient(apiinst);
            }
        }
        catch (APIUndefined e) {
            LoggerUtils.warn("This version of Mystcraft is probably out of date. Please check for updates. LookingGlass integration failure.", new Object[0]);
        }
        catch (APIVersionUndefined e) {
            LoggerUtils.warn("For some reason, LookingGlass cannot count to 1. Integration failure.", new Object[0]);
        }
        catch (APIVersionRemoved e) {
            LoggerUtils.warn("This version of Mystcraft is probably out of date. Please check for updates. LookingGlass integration failure.", new Object[0]);
        }
    }
}

