/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.instability.decay;

import com.xcompwiz.mystcraft.data.ModBlocks;
import com.xcompwiz.mystcraft.instability.decay.DecayHandlerBlack;
import com.xcompwiz.mystcraft.instability.decay.DecayHandlerBlue;
import com.xcompwiz.mystcraft.instability.decay.DecayHandlerPurple;
import com.xcompwiz.mystcraft.instability.decay.DecayHandlerRed;
import com.xcompwiz.mystcraft.instability.decay.DecayHandlerWhite;
import com.xcompwiz.mystcraft.world.WorldInfoUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public abstract class DecayHandler {
    public static final int BLACK = 0;
    public static final int RED = 1;
    public static final int GREEN = 2;
    public static final int BLUE = 3;
    public static final int PURPLE = 4;
    public static final int YELLOW = 5;
    public static final int WHITE = 6;
    private static HashMap<Integer, DecayHandler> handlers = new HashMap();
    @SideOnly(value=Side.CLIENT)
    protected IIcon icon;
    private int metadata;

    public static int size() {
        return handlers.size();
    }

    public static void registerHandler(int meta, DecayHandler handler) {
        handler.setMetadata(meta);
        handlers.put(meta, handler);
    }

    protected void setMetadata(int meta) {
        this.metadata = meta;
    }

    protected int getMetadata() {
        return this.metadata;
    }

    public static void registerIcons(IIconRegister par1IconRegister) {
        for (DecayHandler handler : handlers.values()) {
            handler.registerIcon(par1IconRegister);
        }
    }

    public static DecayHandler getHandler(int meta) {
        return handlers.get(meta);
    }

    protected void addInstability(World world, int amount) {
    }

    public abstract String getIdentifier();

    @SideOnly(value=Side.CLIENT)
    public IIcon getBlockTextureFromSide(int side) {
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerIcon(IIconRegister register) {
        this.icon = register.func_94245_a("mystcraft:decay_" + this.getIdentifier());
    }

    public void onBlockAdded(World world, int i, int j, int k) {
        if (!world.field_72995_K && world.func_147439_a(i, j, k) == ModBlocks.decay && !WorldInfoUtils.isMystcraftAge(world)) {
            world.func_147449_b(i, j, k, Blocks.field_150350_a);
            return;
        }
    }

    public void updateTick(World world, int x, int y, int z, Random random) {
        this.pulse(world, x, y, z, random);
    }

    protected abstract void pulse(World var1, int var2, int var3, int var4, Random var5);

    public void onBlockDestroyedByPlayer(World world, int i, int j, int k) {
    }

    public float getExplosionResistance(Entity entity, World worldObj, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return 2.5f;
    }

    public float getBlockHardness(World worldObj, int x, int y, int z) {
        return 0.5f;
    }

    public void onEntityContact(World worldObj, int x, int y, int z, Entity entity) {
    }

    static {
        DecayHandler.registerHandler(0, new DecayHandlerBlack());
        DecayHandler.registerHandler(1, new DecayHandlerRed());
        DecayHandler.registerHandler(3, new DecayHandlerBlue());
        DecayHandler.registerHandler(4, new DecayHandlerPurple());
        DecayHandler.registerHandler(6, new DecayHandlerWhite());
    }
}

