/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui.element;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.client.gui.GuiUtils;
import com.xcompwiz.mystcraft.client.gui.element.GuiElement;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiElementScrollablePages
extends GuiElement {
    private IGuiPageListProvider pagesprovider;
    private IGuiScrollableClickHandler listener;
    private int firstElement;
    private int elementWidth;
    private int elementHeight;
    private int arrowWidth;
    private int hoverpage = -1;
    private int clickedpage = -1;
    private List<String> hovertext = new ArrayList<String>();
    private boolean mouseOver;

    public GuiElementScrollablePages(IGuiScrollableClickHandler handler, IGuiPageListProvider pagesprovider, Minecraft mc, int left, int top, int width, int height) {
        super(left, top, width, height);
        this.mc = mc;
        this.listener = handler;
        this.pagesprovider = pagesprovider;
        this.elementHeight = this.ySize - 6;
        this.elementWidth = this.elementHeight * 3 / 4;
        this.arrowWidth = this.ySize / 5;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getPageList() != null;
    }

    @Override
    public void _handleMouseInput() {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.mouseOver) {
            return;
        }
        int input = Mouse.getEventDWheel();
        if (input != 0) {
            if (input > 0) {
                this.cycleLeft();
            } else {
                this.cycleRight();
            }
        }
    }

    @Override
    public boolean _onMouseDown(int i, int j, int k) {
        if (!this.isEnabled()) {
            return false;
        }
        List<ItemStack> pageList = this.getPageList();
        if (pageList == null) {
            return false;
        }
        int guiLeft = this.getLeft();
        int guiTop = this.getTop();
        if (i > guiLeft && i < guiLeft + this.xSize && j > guiTop && j < guiTop + this.ySize) {
            if (i > guiLeft && i < guiLeft + this.arrowWidth && j > guiTop && j < guiTop + this.ySize) {
                this.cycleLeft();
                return true;
            }
            if (i > guiLeft + this.xSize - this.arrowWidth && i < guiLeft + this.xSize && j > guiTop && j < guiTop + this.ySize) {
                this.cycleRight();
                return true;
            }
            if (this.mc.field_71439_g.field_71071_by.func_70445_o() != null) {
                int index = this.hoverpage;
                if (index == -1) {
                    index = pageList.size();
                }
                this.listener.onItemPlace(this, index, k);
                return true;
            }
            if (this.hoverpage != -1) {
                this.clickedpage = this.hoverpage;
                return true;
            }
        }
        return false;
    }

    private List<ItemStack> getPageList() {
        return this.pagesprovider.getPageList();
    }

    private void cycleRight() {
        ++this.firstElement;
        int size = this.getPageList().size();
        if (this.firstElement >= size) {
            this.firstElement = size - 1;
        }
        if (this.firstElement < 0) {
            this.firstElement = 0;
        }
    }

    private void cycleLeft() {
        --this.firstElement;
        if (this.firstElement < 0) {
            this.firstElement = 0;
        }
    }

    @Override
    public boolean _onMouseUp(int i, int j, int k) {
        if (this.clickedpage != -1 && this.hoverpage == this.clickedpage) {
            this.listener.onItemRemove(this, this.clickedpage);
        }
        this.clickedpage = -1;
        return false;
    }

    @Override
    public List<String> _getTooltipInfo() {
        if (this.hovertext != null && this.hovertext.size() > 0) {
            return this.hovertext;
        }
        return super._getTooltipInfo();
    }

    @Override
    public void _renderBackground(float f, int mouseX, int mouseY) {
        int guiLeft = this.getLeft();
        int guiTop = this.getTop();
        this.mouseOver = this.contains(mouseX, mouseY);
        this.hovertext.clear();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)guiLeft, (float)guiTop, (float)0.0f);
        mouseX -= guiLeft;
        mouseY -= guiTop;
        int color = -1442840576;
        GuiElementScrollablePages.func_73734_a((int)0, (int)0, (int)this.xSize, (int)this.ySize, (int)color);
        GL11.glPushMatrix();
        GuiUtils.startGlScissor(guiLeft + 1, guiTop, this.xSize - 2, this.ySize);
        this.hoverpage = -1;
        List<ItemStack> pageList = this.getPageList();
        if (pageList != null) {
            float x = 2.0f;
            float y = 3.0f;
            float pagexSize = this.elementWidth;
            float pageySize = this.elementHeight;
            for (int i = this.firstElement; i < pageList.size(); ++i) {
                ItemStack page = pageList.get(i);
                GuiUtils.drawPage(this.mc.field_71446_o, this.getZLevel(), page, pagexSize, pageySize, x, y);
                if (GuiUtils.contains(mouseX, mouseY, (int)x, (int)y, (int)pagexSize, (int)pageySize)) {
                    IAgeSymbol symbol2;
                    this.hoverpage = i;
                    Page.getTooltip(page, this.hovertext);
                    if (Page.getSymbol(page) != null && (symbol2 = SymbolManager.getAgeSymbol(Page.getSymbol(page))) != null) {
                        this.hovertext.add(symbol2.displayName());
                    }
                }
                if ((x += pagexSize + 2.0f) > (float)this.xSize) break;
            }
        }
        GuiUtils.endGlScissor();
        GL11.glPopMatrix();
        if (this.firstElement == 0) {
            color = 0x33000000;
        }
        GuiUtils.drawGradientRect(0.0f, 0.0f, this.arrowWidth, this.ySize, color, color, this.getZLevel());
        color = pageList == null || pageList.size() == 0 || pageList.size() - 1 == this.firstElement ? 0x33000000 : -1442840576;
        GuiUtils.drawGradientRect(this.xSize - this.arrowWidth, 0.0f, this.xSize, this.ySize, color, color, this.getZLevel());
        GL11.glPopMatrix();
    }

    @Override
    public boolean _onKeyPress(char c, int i) {
        if (!this.isEnabled()) {
            return false;
        }
        if (i == 203 || i == this.mc.field_71474_y.field_74370_x.func_151463_i()) {
            this.cycleLeft();
            return true;
        }
        if (i == 205 || i == this.mc.field_71474_y.field_74366_z.func_151463_i()) {
            this.cycleRight();
            return true;
        }
        return false;
    }

    public static interface IGuiPageListProvider {
        public List<ItemStack> getPageList();
    }

    public static interface IGuiScrollableClickHandler {
        public void onItemPlace(GuiElementScrollablePages var1, int var2, int var3);

        public void onItemRemove(GuiElementScrollablePages var1, int var2);
    }
}

