/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui.element;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.client.gui.GuiUtils;
import com.xcompwiz.mystcraft.client.gui.element.GuiElement;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementTextField;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementVSlider;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiElementPageSurface
extends GuiElement
implements GuiElementTextField.IGuiOnTextChange {
    public static final float pagewidth = 30.0f;
    public static final float pageheight = 40.0f;
    private IGuiPositionedPagesProvider pagesProvider;
    private float pageWidth;
    private float pageHeight;
    private PositionableItem hoverpage;
    private List<String> hovertext = new ArrayList<String>();
    private GuiElementVSlider scrollbar;
    private boolean mousedown;
    private String searchtext;
    private boolean mouseOverPageArea = false;

    public GuiElementPageSurface(IGuiPositionedPagesProvider pagesProvider, Minecraft mc, int left, int top, int width, int height) {
        super(left, top, width, height);
        this.mc = mc;
        this.pagesProvider = pagesProvider;
        this.pageWidth = 30.0f;
        this.pageHeight = 40.0f;
        this.mousedown = false;
        this.scrollbar = new GuiElementVSlider(this.xSize - 20, 0, 20, this.ySize);
        this.addElement(this.scrollbar);
    }

    @Override
    public void _handleMouseInput() {
        if (!this.mouseOverPageArea) {
            return;
        }
        this.scrollbar.handleMouseScroll();
    }

    @Override
    public boolean _onMouseDown(int mouseX, int mouseY, int button) {
        if (this.contains(mouseX, mouseY)) {
            if (this.pagesProvider == null) {
                return false;
            }
            if (this.mc.field_71439_g.field_71071_by.func_70445_o() != null) {
                List<PositionableItem> pages = this.getPages();
                if (pages == null) {
                    return false;
                }
                int index = pages.size();
                if (this.hoverpage != null) {
                    index = this.hoverpage.slotId;
                }
                this.pagesProvider.place(index, button == 1);
                return true;
            }
            if (this.hoverpage != null && button == 2) {
                return true;
            }
            if (this.hoverpage != null && button == 0) {
                this.pagesProvider.pickup(this.hoverpage);
                return true;
            }
            this.mousedown = true;
        }
        return false;
    }

    @Override
    public boolean _onMouseUp(int i, int j, int k) {
        int guiLeft = this.getLeft();
        int guiTop = this.getTop();
        if (this.pagesProvider != null && GuiUtils.contains(i, j, guiLeft, guiTop, this.xSize - 20, this.ySize) && this.hoverpage != null && k == 1 && this.mousedown) {
            this.pagesProvider.copy(this.hoverpage);
        }
        this.mousedown = false;
        return false;
    }

    @Override
    public List<String> _getTooltipInfo() {
        if (this.hovertext != null && this.hovertext.size() > 0) {
            return this.hovertext;
        }
        return super._getTooltipInfo();
    }

    @Override
    public void _renderBackground(float f, int mouseX, int mouseY) {
        int guiLeft = this.getLeft();
        int guiTop = this.getTop();
        this.mouseOverPageArea = GuiUtils.contains(mouseX, mouseY, guiLeft, guiTop, this.xSize - 20, this.ySize);
        this.hovertext.clear();
        this.hoverpage = null;
        int color = -1442840576;
        GuiElementPageSurface.func_73734_a((int)guiLeft, (int)guiTop, (int)(guiLeft + this.xSize - 20), (int)(guiTop + this.ySize), (int)color);
        GuiUtils.drawGradientRect(guiLeft, guiTop, guiLeft + this.xSize - 20, guiTop + this.ySize, 0, 0, this.getZLevel());
        GL11.glDepthFunc((int)518);
        GuiUtils.startGlScissor(guiLeft, guiTop, this.xSize, this.ySize - 1);
        this.setZLevel(1.0f);
        GL11.glPushMatrix();
        int currentScroll = -this.scrollbar.getCurrentPos();
        List<PositionableItem> pages = this.getPages();
        int maxScroll = 0;
        if (pages != null) {
            float x = guiLeft;
            float y = guiTop + currentScroll;
            float pagexSize = this.pageWidth;
            float pageySize = this.pageHeight;
            for (PositionableItem positionable : pages) {
                IAgeSymbol symbol2;
                ItemStack page = positionable.itemstack;
                float pageX = positionable.x;
                float pageY = positionable.y;
                if (pageY + this.pageHeight - (float)this.ySize > (float)maxScroll) {
                    maxScroll = (int)(pageY + this.pageHeight + 6.0f - (float)this.ySize);
                }
                if (y + pageY < (float)guiTop - this.pageHeight || y + pageY > (float)(guiTop + this.ySize)) continue;
                String displayname = null;
                if (Page.getSymbol(page) != null) {
                    symbol2 = SymbolManager.getAgeSymbol(Page.getSymbol(page));
                    if (symbol2 != null) {
                        displayname = symbol2.displayName();
                    }
                    if (displayname == null) {
                        displayname = Page.getSymbol(page);
                    }
                }
                if (displayname != null && this.searchtext != null && this.searchtext.length() > 0 && !displayname.toLowerCase().contains(this.searchtext.toLowerCase())) {
                    page = null;
                }
                if (positionable.count > 0) {
                    GuiUtils.drawPage(this.mc.field_71446_o, this.getZLevel(), page, pagexSize, pageySize, x + pageX, y + pageY);
                } else {
                    GuiUtils.drawPage(this.mc.field_71446_o, this.getZLevel(), null, pagexSize, pageySize, x + pageX, y + pageY);
                }
                if (positionable.count > 1) {
                    GuiUtils.drawScaledText("" + positionable.count, (int)(x + pageX), (int)(y + pageY + this.pageHeight - 7.0f), 20, 10, 0xFFFFFF);
                }
                if (!this.mouseOverPageArea || !GuiUtils.contains(mouseX, mouseY, (int)(x + pageX), (int)(y + pageY), (int)pagexSize, (int)pageySize)) continue;
                this.hoverpage = positionable;
                Page.getTooltip(page, this.hovertext);
                if (displayname != null) {
                    this.hovertext.add(displayname);
                    continue;
                }
                if (Page.getSymbol(page) == null || (symbol2 = SymbolManager.getAgeSymbol(Page.getSymbol(page))) == null) continue;
                this.hovertext.add(symbol2.displayName());
            }
        }
        this.scrollbar.setMaxScroll(maxScroll);
        GL11.glPopMatrix();
        GL11.glDepthFunc((int)515);
        this.setZLevel(2.0f);
        GuiUtils.endGlScissor();
    }

    private List<PositionableItem> getPages() {
        if (this.pagesProvider == null) {
            return null;
        }
        return this.pagesProvider.getPositionedPages();
    }

    @Override
    public void onTextChange(GuiElementTextField caller, String text) {
        this.searchtext = text;
    }

    public static interface IGuiPositionedPagesProvider {
        public List<PositionableItem> getPositionedPages();

        public void place(int var1, boolean var2);

        public void pickup(PositionableItem var1);

        public void copy(PositionableItem var1);
    }

    public static class PositionableItem {
        public int slotId;
        public ItemStack itemstack;
        public float x;
        public float y;
        public int count = 1;
    }
}

