/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui.element;

import com.xcompwiz.mystcraft.client.gui.GuiUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

@SideOnly(value=Side.CLIENT)
public abstract class GuiElement
extends Gui {
    protected Minecraft mc;
    private GuiElement parent;
    private List<GuiElement> elements = new LinkedList<GuiElement>();
    private boolean visible = true;
    private boolean enabled = true;
    private int guiLeft;
    private int guiTop;
    protected int xSize;
    protected int ySize;
    private float zLevel;

    public GuiElement(int guiLeft, int guiTop, int xSize, int ySize) {
        this.mc = Minecraft.func_71410_x();
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.xSize = xSize;
        this.ySize = ySize;
    }

    public void setPosition(int x, int y) {
        this.guiLeft = x;
        this.guiTop = y;
        this.adjustSize();
    }

    public final int getLeft() {
        if (this.parent != null) {
            return this.guiLeft + this.parent.getLeft();
        }
        return this.guiLeft;
    }

    public final int getTop() {
        if (this.parent != null) {
            return this.guiTop + this.parent.getTop();
        }
        return this.guiTop;
    }

    public final int getWidth() {
        return this.xSize;
    }

    public final int getHeight() {
        return this.ySize;
    }

    public void setLeft(int v) {
        this.guiLeft = v;
        this.adjustSize();
    }

    public void setTop(int v) {
        this.guiTop = v;
        this.adjustSize();
    }

    public void setWidth(int v) {
        this.xSize = v;
        this.adjustSize();
    }

    public void setHeight(int v) {
        this.ySize = v;
        this.adjustSize();
    }

    public void setZLevel(float zLevel) {
        this.zLevel = zLevel;
    }

    public float getZLevel() {
        if (this.parent != null) {
            return this.parent.getZLevel() + this.zLevel;
        }
        return this.zLevel;
    }

    public void focus() {
        if (this.parent == null) {
            return;
        }
        this.parent.bringToFront(this);
        this.parent.focus();
    }

    public void bringToFront(GuiElement element) {
        this.addElement(element);
    }

    public void addElement(GuiElement element) {
        if (element.parent != null) {
            element.parent.elements.remove((Object)element);
        }
        element.parent = this;
        this.elements.add(element);
        element.adjustSize();
    }

    public void removeElement(GuiElement element) {
        if (element.parent == this) {
            this.elements.remove((Object)element);
        }
    }

    public void clearAllElements() {
        for (GuiElement elem : this.elements) {
            elem.parent = null;
        }
        this.elements.clear();
    }

    public void addElements(Collection<GuiElement> elements) {
        for (GuiElement elem : elements) {
            elem.parent = this;
            elem.adjustSize();
        }
        this.elements.addAll(elements);
    }

    public List<GuiElement> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public final GuiElement getParent() {
        return this.parent;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isEnabled() {
        return this.enabled && this.isVisible();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean contains(int xpos, int ypos) {
        return GuiUtils.contains(xpos, ypos, this.getLeft(), this.getTop(), this.xSize, this.ySize) && (this.getParent() == null || this.getParent().contains(xpos, ypos));
    }

    public final void adjustSize() {
        for (GuiElement elem : this.elements) {
            elem.adjustSize();
        }
        this._adjustSize();
    }

    public void _adjustSize() {
    }

    public final void onTick() {
        for (GuiElement elem : this.elements) {
            elem.onTick();
        }
        this._onTick();
    }

    protected void _onTick() {
    }

    public final boolean onKeyPress(char c, int i) {
        if (!this.isEnabled()) {
            return false;
        }
        for (GuiElement elem : this.elements) {
            if (!elem.onKeyPress(c, i)) continue;
            return true;
        }
        return this._onKeyPress(c, i);
    }

    protected boolean _onKeyPress(char c, int i) {
        return false;
    }

    public final void handleMouseInput() {
        if (!this.isEnabled()) {
            return;
        }
        for (GuiElement elem : this.elements) {
            elem.handleMouseInput();
        }
        this._handleMouseInput();
    }

    protected void _handleMouseInput() {
    }

    public final boolean onMouseUp(int mouseX, int mouseY, int button) {
        if (!this.isEnabled()) {
            return false;
        }
        for (GuiElement elem : this.elements) {
            if (!elem.onMouseUp(mouseX, mouseY, button)) continue;
            return true;
        }
        return this._onMouseUp(mouseX, mouseY, button);
    }

    protected boolean _onMouseUp(int mouseX, int mouseY, int button) {
        return this.contains(mouseX, mouseY);
    }

    public final boolean onMouseDown(int mouseX, int mouseY, int button) {
        if (!this.isEnabled()) {
            return false;
        }
        for (GuiElement elem : this.elements) {
            if (!elem.onMouseDown(mouseX, mouseY, button)) continue;
            return true;
        }
        return this._onMouseDown(mouseX, mouseY, button);
    }

    protected boolean _onMouseDown(int mouseX, int mouseY, int button) {
        return this.contains(mouseX, mouseY);
    }

    public final boolean onMouseDrag(int mouseX, int mouseY, int clicked_id, long lastclick) {
        if (!this.isEnabled()) {
            return false;
        }
        for (GuiElement elem : this.elements) {
            if (!elem.onMouseDrag(mouseX, mouseY, clicked_id, lastclick)) continue;
            return true;
        }
        return this._onMouseDrag(mouseX, mouseY, clicked_id, lastclick);
    }

    protected boolean _onMouseDrag(int mouseX, int mouseY, int clicked_id, long lastclick) {
        return this.contains(mouseX, mouseY);
    }

    public final void renderBackground(float f, int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        this._renderBackground(f, mouseX, mouseY);
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            GuiElement elem = this.elements.get(i);
            elem.renderBackground(f, mouseX, mouseY);
        }
        this._renderBackgroundPost(f, mouseX, mouseY);
    }

    protected void _renderBackground(float f, int mouseX, int mouseY) {
    }

    protected void _renderBackgroundPost(float f, int mouseX, int mouseY) {
    }

    public final void renderForeground(int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        this._renderForeground(mouseX, mouseY);
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            GuiElement elem = this.elements.get(i);
            elem.renderForeground(mouseX, mouseY);
        }
        this._renderForegroundPost(mouseX, mouseY);
    }

    protected void _renderForeground(int mouseX, int mouseY) {
    }

    protected void _renderForegroundPost(int mouseX, int mouseY) {
    }

    public final List<String> getTooltipInfo() {
        if (!this.isVisible()) {
            return null;
        }
        for (GuiElement elem : this.elements) {
            List<String> list = elem.getTooltipInfo();
            if (list == null) continue;
            return list;
        }
        return this._getTooltipInfo();
    }

    protected List<String> _getTooltipInfo() {
        return null;
    }
}

