/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.block;

import com.xcompwiz.mystcraft.client.gui.GuiHandlerManager;
import com.xcompwiz.mystcraft.client.gui.GuiWritingDesk;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.inventory.ContainerWritingDesk;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.network.NetworkUtils;
import com.xcompwiz.mystcraft.tileentity.TileEntityDesk;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockWritingDesk
extends Block {
    private static final int GuiID = GuiHandlerManager.registerGuiNetHandler(new GuiHandlerDesk());
    private static final int[][] headFootMap = new int[][]{{0, 1}, {-1, 0}, {0, -1}, {1, 0}};

    public BlockWritingDesk() {
        super(Material.field_151575_d);
    }

    public void func_149719_a(IBlockAccess iblockaccess, int i, int j, int k) {
        float xmin = 0.0f;
        float xmax = 1.0f;
        float ymin = 0.0f;
        float ymax = 1.0f;
        float zmin = 0.0f;
        float zmax = 1.0f;
        int meta = iblockaccess.func_72805_g(i, j, k);
        if (BlockWritingDesk.isBlockTop(meta)) {
            ymax = 0.75f;
            int dir = BlockWritingDesk.getDirectionFromMetadata(meta);
            if (dir == 0) {
                xmin = 0.5f;
            }
            if (dir == 1) {
                zmin = 0.5f;
            }
            if (dir == 2) {
                xmax = 0.5f;
            }
            if (dir == 3) {
                zmax = 0.5f;
            }
        }
        this.func_149676_a(xmin, ymin, zmin, xmax, ymax, zmax);
    }

    public AxisAlignedBB func_149633_g(World par1World, int par2, int par3, int par4) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        return AxisAlignedBB.func_72330_a((double)((double)par2 + this.field_149759_B), (double)((double)par3 + this.field_149760_C), (double)((double)par4 + this.field_149754_D), (double)((double)par2 + this.field_149755_E), (double)((double)par3 + this.field_149756_F), (double)((double)par4 + this.field_149757_G));
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        return AxisAlignedBB.func_72330_a((double)((double)par2 + this.field_149759_B), (double)((double)par3 + this.field_149760_C), (double)((double)par4 + this.field_149754_D), (double)((double)par2 + this.field_149755_E), (double)((double)par3 + this.field_149756_F), (double)((double)par4 + this.field_149757_G));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int i, int j) {
        if (i <= 1) {
            return Blocks.field_150462_ai.func_149733_h(i);
        }
        return Blocks.field_150342_X.func_149733_h(i);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public void func_149695_a(World worldObj, int i, int j, int k, Block block) {
        int meta = worldObj.func_72805_g(i, j, k);
        if (BlockWritingDesk.isBlockTop(meta) && !BlockWritingDesk.isBlockFoot(meta) && worldObj.func_147439_a(i, j - 1, k) != this) {
            if (!worldObj.field_72995_K) {
                this.func_149697_b(worldObj, i, j, k, meta, 0);
            }
            worldObj.func_147449_b(i, j, k, Blocks.field_150350_a);
        }
        int direction = BlockWritingDesk.getDirectionFromMetadata(meta);
        if (BlockWritingDesk.isBlockFoot(meta)) {
            if (worldObj.func_147439_a(i - headFootMap[direction][0], j, k - headFootMap[direction][1]) != this) {
                worldObj.func_147449_b(i, j, k, Blocks.field_150350_a);
            }
        } else if (worldObj.func_147439_a(i + headFootMap[direction][0], j, k + headFootMap[direction][1]) != this) {
            worldObj.func_147449_b(i, j, k, Blocks.field_150350_a);
        }
    }

    public void func_149681_a(World worldObj, int x, int y, int z, int meta, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d && !BlockWritingDesk.isBlockTop(meta) && worldObj.func_147439_a(x, y + 1, z) == this && BlockWritingDesk.isBlockTop(worldObj.func_72805_g(x, y + 1, z))) {
            worldObj.func_147468_f(x, y + 1, z);
            int direction = BlockWritingDesk.getDirectionFromMetadata(meta);
            if (BlockWritingDesk.isBlockFoot(meta)) {
                worldObj.func_147449_b(x - headFootMap[direction][0], y + 1, z - headFootMap[direction][1], Blocks.field_150350_a);
            } else {
                worldObj.func_147449_b(z + headFootMap[direction][0], y + 1, z + headFootMap[direction][1], Blocks.field_150350_a);
            }
        }
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int side, float posX, float pozY, float posZ) {
        if (world.field_72995_K) {
            return true;
        }
        NetworkUtils.displayGui(entityplayer, world, GuiID, i, j, k);
        return true;
    }

    public void func_149749_a(World world, int i, int j, int k, Block block, int meta) {
        IInventory tileentity = (IInventory)world.func_147438_o(i, j, k);
        if (tileentity != null) {
            for (int l = 0; l < tileentity.func_70302_i_(); ++l) {
                ItemStack itemstack = tileentity.func_70301_a(l);
                if (itemstack == null) continue;
                tileentity.func_70299_a(l, null);
                float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                EntityItem entityitem = new EntityItem(world, (double)((float)i + f), (double)((float)j + f1), (double)((float)k + f2), itemstack);
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
                entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
                world.func_72838_d((Entity)entityitem);
            }
        }
        super.func_149749_a(world, i, j, k, block, meta);
    }

    protected ItemStack func_149644_j(int par1) {
        return null;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (BlockWritingDesk.isBlockTop(metadata)) {
            ret.add(new ItemStack(ModItems.desk, 1, 1));
        } else {
            ret.add(new ItemStack(ModItems.desk, 1, 0));
        }
        return ret;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        if (BlockWritingDesk.isBlockTop(world.func_72805_g(x, y, z))) {
            return new ItemStack(ModItems.desk, 1, 1);
        }
        return new ItemStack(ModItems.desk, 1, 0);
    }

    public int func_149656_h() {
        return 1;
    }

    public static int getMetadataFromDirection(int i, int j) {
        if (j == 1) {
            return 0;
        }
        if (i == -1) {
            return 1;
        }
        if (j == -1) {
            return 2;
        }
        if (i == 1) {
            return 3;
        }
        return 0;
    }

    public static int getDirectionFromMetadata(int i) {
        return i & 3;
    }

    public static boolean isBlockFoot(int i) {
        return (i & 8) != 0;
    }

    public static boolean isBlockTop(int i) {
        return (i & 4) != 0;
    }

    public static TileEntityDesk getTileEntity(World world, int i, int j, int k) {
        int meta = world.func_72805_g(i, j, k);
        if (BlockWritingDesk.isBlockTop(meta)) {
            return BlockWritingDesk.getTileEntity(world, i, j - 1, k);
        }
        if (BlockWritingDesk.isBlockFoot(meta)) {
            int direction = BlockWritingDesk.getDirectionFromMetadata(meta);
            return (TileEntityDesk)world.func_147438_o(i - headFootMap[direction][0], j, k - headFootMap[direction][1]);
        }
        return (TileEntityDesk)world.func_147438_o(i, j, k);
    }

    public boolean hasTileEntity(int metadata) {
        return !BlockWritingDesk.isBlockFoot(metadata) && !BlockWritingDesk.isBlockTop(metadata);
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntityDesk();
    }

    public void func_149726_b(World worldObj, int i, int j, int k) {
        super.func_149726_b(worldObj, i, j, k);
        if (this.hasTileEntity(worldObj.func_72805_g(i, j, k))) {
            worldObj.func_147455_a(i, j, k, this.createTileEntity(worldObj, worldObj.func_72805_g(i, j, k)));
        }
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack itemstack) {
        if (world.func_147439_a(i, j, k) != this) {
            return;
        }
        int facing = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) + 1 & 3;
        int xOffset = 0;
        int zOffset = 0;
        if (facing == 0) {
            zOffset = 1;
        }
        if (facing == 1) {
            xOffset = -1;
        }
        if (facing == 2) {
            zOffset = -1;
        }
        if (facing == 3) {
            xOffset = 1;
        }
        if (world.func_147439_a(i + xOffset, j, k + zOffset) == Blocks.field_150350_a) {
            world.func_72921_c(i, j, k, facing, 3);
            world.func_147465_d(i + xOffset, j, k + zOffset, (Block)this, facing + 8, 3);
        } else {
            world.func_147465_d(i, j, k, Blocks.field_150350_a, 0, 3);
        }
    }

    public boolean func_149696_a(World par1World, int par2, int par3, int par4, int par5, int par6) {
        super.func_149696_a(par1World, par2, par3, par4, par5, par6);
        TileEntity var7 = par1World.func_147438_o(par2, par3, par4);
        if (var7 != null) {
            var7.func_145842_c(par5, par6);
        }
        return false;
    }

    public static class GuiHandlerDesk
    extends GuiHandlerManager.GuiHandler {
        @Override
        public TileEntity getTileEntity(EntityPlayerMP player, World worldObj, int i, int j, int k) {
            TileEntityDesk tileentity = BlockWritingDesk.getTileEntity(worldObj, i, j, k);
            if (tileentity == null) {
                LoggerUtils.warn(String.format("Desk TileEntity Missing", new Object[0]), new Object[0]);
            }
            return tileentity;
        }

        @Override
        public Container getContainer(EntityPlayerMP player, World worldObj, TileEntity tileentity, int i, int j, int k) {
            return new ContainerWritingDesk(player.field_71071_by, (TileEntityDesk)tileentity);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiScreen getGuiScreen(EntityPlayer player, ByteBuf data) {
            int x = data.readInt();
            int y = data.readInt();
            int z = data.readInt();
            return new GuiWritingDesk(player.field_71071_by, BlockWritingDesk.getTileEntity(player.field_70170_p, x, y, z));
        }
    }
}

