/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft;

import com.google.common.collect.ImmutableList;
import com.xcompwiz.mystcraft.api.impl.InternalAPI;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.command.CommandCreateAgebook;
import com.xcompwiz.mystcraft.command.CommandCreateDim;
import com.xcompwiz.mystcraft.command.CommandDebug;
import com.xcompwiz.mystcraft.command.CommandMystPermissions;
import com.xcompwiz.mystcraft.command.CommandRegenerateChunk;
import com.xcompwiz.mystcraft.command.CommandReprofile;
import com.xcompwiz.mystcraft.command.CommandSpawnMeteor;
import com.xcompwiz.mystcraft.command.CommandTPX;
import com.xcompwiz.mystcraft.command.CommandTime;
import com.xcompwiz.mystcraft.command.CommandToggleDownfall;
import com.xcompwiz.mystcraft.command.CommandToggleWorldInstability;
import com.xcompwiz.mystcraft.config.MystConfig;
import com.xcompwiz.mystcraft.core.MystcraftCommonProxy;
import com.xcompwiz.mystcraft.core.MystcraftEventHandler;
import com.xcompwiz.mystcraft.core.MystcraftTickHandler;
import com.xcompwiz.mystcraft.core.TaskQueueManager;
import com.xcompwiz.mystcraft.data.GrammarRules;
import com.xcompwiz.mystcraft.data.InkEffects;
import com.xcompwiz.mystcraft.data.ModAchievements;
import com.xcompwiz.mystcraft.data.ModBlocks;
import com.xcompwiz.mystcraft.data.ModFluids;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.data.ModLinkEffects;
import com.xcompwiz.mystcraft.data.ModRecipes;
import com.xcompwiz.mystcraft.data.ModSymbols;
import com.xcompwiz.mystcraft.data.ModSymbolsFluids;
import com.xcompwiz.mystcraft.data.ModWords;
import com.xcompwiz.mystcraft.data.SymbolRules;
import com.xcompwiz.mystcraft.entity.EntityFallingBlock;
import com.xcompwiz.mystcraft.entity.EntityLinkbook;
import com.xcompwiz.mystcraft.entity.EntityMeteor;
import com.xcompwiz.mystcraft.grammar.GrammarGenerator;
import com.xcompwiz.mystcraft.imc.IMCHandler;
import com.xcompwiz.mystcraft.instability.InstabilityData;
import com.xcompwiz.mystcraft.instability.InstabilityManager;
import com.xcompwiz.mystcraft.instability.bonus.EventManager;
import com.xcompwiz.mystcraft.linking.LinkListenerBasic;
import com.xcompwiz.mystcraft.linking.LinkListenerEffects;
import com.xcompwiz.mystcraft.linking.LinkListenerForgeServer;
import com.xcompwiz.mystcraft.linking.LinkListenerPermissions;
import com.xcompwiz.mystcraft.network.MystcraftConnectionHandler;
import com.xcompwiz.mystcraft.network.MystcraftPacketHandler;
import com.xcompwiz.mystcraft.network.packet.MPacketActivateItem;
import com.xcompwiz.mystcraft.network.packet.MPacketAgeData;
import com.xcompwiz.mystcraft.network.packet.MPacketConfigs;
import com.xcompwiz.mystcraft.network.packet.MPacketDimensions;
import com.xcompwiz.mystcraft.network.packet.MPacketExplosion;
import com.xcompwiz.mystcraft.network.packet.MPacketGuiMessage;
import com.xcompwiz.mystcraft.network.packet.MPacketMessage;
import com.xcompwiz.mystcraft.network.packet.MPacketOpenWindow;
import com.xcompwiz.mystcraft.network.packet.MPacketParticles;
import com.xcompwiz.mystcraft.network.packet.MPacketProfilingState;
import com.xcompwiz.mystcraft.network.packet.MPacketSpawnLightningBolt;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import com.xcompwiz.mystcraft.symbol.SymbolRemappings;
import com.xcompwiz.mystcraft.tileentity.TileEntityBookBinder;
import com.xcompwiz.mystcraft.tileentity.TileEntityBookReceptacle;
import com.xcompwiz.mystcraft.tileentity.TileEntityBookstand;
import com.xcompwiz.mystcraft.tileentity.TileEntityDesk;
import com.xcompwiz.mystcraft.tileentity.TileEntityInkMixer;
import com.xcompwiz.mystcraft.tileentity.TileEntityLectern;
import com.xcompwiz.mystcraft.tileentity.TileEntityLinkModifier;
import com.xcompwiz.mystcraft.tileentity.TileEntityStarFissure;
import com.xcompwiz.mystcraft.treasure.TreasureGenWrapper;
import com.xcompwiz.mystcraft.villager.MerchantRecipeProviderItem;
import com.xcompwiz.mystcraft.villager.VillageCreationHandlerArchivistHouse;
import com.xcompwiz.mystcraft.villager.VillagerArchivist;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import com.xcompwiz.mystcraft.world.gen.structure.ComponentScatteredFeatureSmallLibrary;
import com.xcompwiz.mystcraft.world.gen.structure.ComponentVillageArchivistHouse;
import com.xcompwiz.mystcraft.world.gen.structure.MapGenScatteredFeatureMyst;
import com.xcompwiz.mystcraft.world.gen.structure.StructureScatteredFeatureStartMyst;
import com.xcompwiz.mystcraft.world.profiling.ChunkProfilerManager;
import com.xcompwiz.mystcraft.world.profiling.InstabilityDataCalculator;
import com.xcompwiz.mystcraft.world.profiling.MystWorldGenerator;
import com.xcompwiz.mystcraft.world.storage.FileUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;

@Mod(modid="Mystcraft", version="0.12.3.02", name="Mystcraft", useMetadata=true, dependencies="required-after:Forge@[10.12.1.1083,)")
public class Mystcraft {
    @Mod.Instance(value="Mystcraft")
    public static Mystcraft instance;
    @SidedProxy(clientSide="com.xcompwiz.mystcraft.client.MystcraftClientProxy", serverSide="com.xcompwiz.mystcraft.core.MystcraftCommonProxy")
    public static MystcraftCommonProxy sidedProxy;
    public static int difficulty;
    public static boolean instabilityEnabled;
    public static boolean renderlabels;
    public static boolean fastRainbows;
    private static boolean spawnmeteorEnabled;
    public static boolean respawnInAges;
    public static boolean villageDeskGen;
    public static boolean serverLabels;
    public static int providerId;
    public static Collection<Integer> registeredDims;
    public static LinkedList<Integer> deadDims;
    public static int archivistId;
    private VillagerArchivist archivist;
    private ChunkProfilerManager profilingThread;
    public static int inkcost;
    public static Set<String> validInks;
    public static MapStorage clientStorage;
    public static boolean requireUUID;
    public static int homeDimension;

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent event) {
        InternalAPI.initAPI();
        MystcraftPacketHandler.registerPacketHandler(new MPacketDimensions(), (byte)10);
        MystcraftPacketHandler.registerPacketHandler(new MPacketConfigs(), (byte)20);
        MystcraftPacketHandler.registerPacketHandler(new MPacketProfilingState(), (byte)21);
        MystcraftPacketHandler.registerPacketHandler(new MPacketParticles(), (byte)25);
        MystcraftPacketHandler.registerPacketHandler(new MPacketMessage(), (byte)-124);
        MystcraftPacketHandler.registerPacketHandler(new MPacketGuiMessage(), (byte)-116);
        MystcraftPacketHandler.registerPacketHandler(new MPacketOpenWindow(), (byte)-122);
        MystcraftPacketHandler.registerPacketHandler(new MPacketActivateItem(), (byte)-119);
        MystcraftPacketHandler.registerPacketHandler(new MPacketAgeData(), (byte)-121);
        MystcraftPacketHandler.registerPacketHandler(new MPacketExplosion(), (byte)100);
        MystcraftPacketHandler.registerPacketHandler(new MPacketSpawnLightningBolt(), (byte)101);
        FMLCommonHandler.instance().bus().register((Object)new MystcraftConnectionHandler());
        MystcraftPacketHandler.bus = NetworkRegistry.INSTANCE.newEventDrivenChannel("mystcraft");
        MystcraftPacketHandler.bus.register((Object)new MystcraftPacketHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MystcraftEventHandler());
        EventManager eventmanager = new EventManager();
        MinecraftForge.EVENT_BUS.register((Object)eventmanager);
        FMLCommonHandler.instance().bus().register((Object)eventmanager);
        FMLCommonHandler.instance().bus().register((Object)new MystcraftTickHandler());
        EventManager.set(eventmanager);
        File configroot = event.getSuggestedConfigurationFile().getParentFile();
        File configfile = new File(configroot, "mystcraft/core.cfg");
        File oldconfigfile = new File(configroot, "Mystcraft.txt");
        if (oldconfigfile.exists()) {
            configfile.getParentFile().mkdirs();
            if (!configfile.exists()) {
                oldconfigfile.renameTo(configfile);
            }
        }
        MystConfig config = new MystConfig(configfile);
        MystConfig balanceconfig = new MystConfig(new File(configroot, "mystcraft/balance.cfg"));
        SymbolManager.setConfig(new MystConfig(new File(configroot, "mystcraft/symbols.cfg")));
        InstabilityManager.setConfig(new MystConfig(new File(configroot, "mystcraft/instabilities.cfg")));
        ModSymbolsFluids.setConfig(balanceconfig);
        InstabilityDataCalculator.setBalanceConfig(balanceconfig);
        boolean generate_template = config.get("general", "configs.generate_template.balance", false).getBoolean(false);
        spawnmeteorEnabled = config.get("general", "commands.spawnmeteor.enabled", spawnmeteorEnabled).getBoolean(spawnmeteorEnabled);
        difficulty = balanceconfig.getOptional("instability", "global.difficulty", difficulty);
        instabilityEnabled = balanceconfig.get("instability", "global.enabled", instabilityEnabled).getBoolean(instabilityEnabled);
        renderlabels = config.get("render", "renderlabels", renderlabels, "If set to false on the server config, this will override client settings.").getBoolean(renderlabels);
        fastRainbows = config.get("render", "fast_rainbows", fastRainbows).getBoolean(fastRainbows);
        respawnInAges = config.get("general", "respawning.respawnInAges", respawnInAges).getBoolean(respawnInAges);
        villageDeskGen = config.get("general", "generation.villageDeskGen", villageDeskGen).getBoolean(villageDeskGen);
        requireUUID = config.get("general", "teleportation.requireUUIDTest", requireUUID, "If set to true, the dimension matching test will be strict. This will force new players to the \"home\" dimension.").getBoolean(requireUUID);
        homeDimension = config.get("general", "teleportation.homedim", homeDimension).getInt();
        archivistId = config.get("general", "ids.villager.archivist", 1210950779).getInt();
        providerId = config.get("general", "ids.dim_provider", 1210950779).getInt();
        serverLabels = renderlabels;
        if (generate_template) {
            ModSymbolsFluids.setReferenceConfig(new MystConfig(new File(configroot, "mystcraft/balance_template.cfg")));
        }
        ModFluids.loadConfigs(config);
        ModItems.loadConfigs(config);
        ModBlocks.loadConfigs(config);
        ModRecipes.loadConfigs(config);
        ModLinkEffects.setConfigs(config);
        InstabilityDataCalculator.loadConfigs(config);
        if (config.hasChanged()) {
            config.save();
        }
        MapGenStructureIO.func_143034_b(StructureScatteredFeatureStartMyst.class, (String)MapGenScatteredFeatureMyst.stringId);
        MapGenStructureIO.func_143031_a(ComponentScatteredFeatureSmallLibrary.class, (String)"TeMystSL");
        MapGenStructureIO.func_143031_a(ComponentVillageArchivistHouse.class, (String)"ViMystAH");
        SymbolRemappings.initialize();
        GrammarRules.initialize();
        DimensionManager.registerProviderType((int)providerId, WorldProviderMyst.class, (boolean)false);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new MystWorldGenerator(), (int)Integer.MAX_VALUE);
        sidedProxy.preinit();
        MinecraftForge.EVENT_BUS.register((Object)new LinkListenerBasic());
        MinecraftForge.EVENT_BUS.register((Object)new LinkListenerPermissions());
        MinecraftForge.EVENT_BUS.register((Object)new LinkListenerEffects());
        MinecraftForge.EVENT_BUS.register((Object)new LinkListenerForgeServer());
        ModFluids.init();
        ModItems.init();
        ModBlocks.init();
        InkEffects.init();
        FluidContainerRegistry.registerFluidContainer((Fluid)ModFluids.black_ink, (ItemStack)new ItemStack((Item)ModItems.inkvial, 1, 0), (ItemStack)new ItemStack(Items.field_151069_bo));
        ModSymbolsFluids.init();
        ModAchievements.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FMLInterModComms.sendMessage((String)"LookingGlass", (String)"API", (String)"com.xcompwiz.mystcraft.integration.lookingglass.LookingGlassIntegration.register");
        ModRecipes.addRecipes(CraftingManager.func_77594_a());
        TileEntity.func_145826_a(TileEntityLectern.class, (String)"LinkbookLectern");
        TileEntity.func_145826_a(TileEntityBookstand.class, (String)"LinkbookStand");
        TileEntity.func_145826_a(TileEntityStarFissure.class, (String)"StarFissure");
        TileEntity.func_145826_a(TileEntityDesk.class, (String)"WritingDesk");
        TileEntity.func_145826_a(TileEntityBookReceptacle.class, (String)"CrystalBlock");
        TileEntity.func_145826_a(TileEntityLinkModifier.class, (String)"LinkModifier");
        TileEntity.func_145826_a(TileEntityBookBinder.class, (String)"myst.BookBinder");
        TileEntity.func_145826_a(TileEntityInkMixer.class, (String)"myst.InkMixer");
        EntityRegistry.registerModEntity(EntityLinkbook.class, (String)"myst.book", (int)219, (Object)this, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityFallingBlock.class, (String)"myst.block", (int)218, (Object)this, (int)16, (int)60, (boolean)false);
        EntityRegistry.registerModEntity(EntityMeteor.class, (String)"myst.meteor", (int)217, (Object)this, (int)192, (int)30, (boolean)false);
        ModSymbols.initialize();
        ModWords.initialize();
        SymbolRules.initialize();
        InstabilityData.initialize();
        if (Mystcraft.archivistEnabled()) {
            this.archivist = new VillagerArchivist();
            VillagerRegistry.instance().registerVillagerId(archivistId);
            VillagerRegistry.instance().registerVillageTradeHandler(archivistId, (VillagerRegistry.IVillageTradeHandler)this.archivist);
        }
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageCreationHandlerArchivistHouse());
        sidedProxy.init();
    }

    public static boolean archivistEnabled() {
        return archivistId != 0;
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent event) {
        ImmutableList messages = event.getMessages();
        IMCHandler.process((ImmutableList<FMLInterModComms.IMCMessage>)messages);
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent event) {
        sidedProxy.postInit();
        ModSymbols.generateBiomeSymbols();
        ModSymbolsFluids.modsLoaded();
        SymbolManager.buildCardRanks();
        SymbolManager.registerRules();
        GrammarGenerator.buildGrammar();
        InstabilityDataCalculator.loadBalanceData();
        ChestGenHooks treasureinfo = ChestGenHooks.getInfo((String)"mystcraftTreasure");
        treasureinfo.setMin(4);
        treasureinfo.setMax(8);
        treasureinfo.addItem(new WeightedRandomChestContent(Items.field_151121_aF, 0, 1, 8, 50));
        treasureinfo.addItem(new WeightedRandomChestContent(Items.field_151116_aA, 0, 1, 8, 50));
        treasureinfo.addItem(new WeightedRandomChestContent((Item)ModItems.inkvial, 0, 1, 2, 50));
        treasureinfo.addItem(new WeightedRandomChestContent(ModItems.booster, 0, 1, 4, 1000));
        if (this.archivist != null) {
            this.archivist.registerRecipe(new MerchantRecipeProviderItem(new ItemStack(Items.field_151166_bC, 25), null, new ItemStack(ModItems.booster, 1)));
        }
        TreasureGenWrapper mystTreasureSub = new TreasureGenWrapper("mystcraftTreasure", 10);
        ChestGenHooks.getInfo((String)"pyramidDesertyChest").addItem((WeightedRandomChestContent)mystTreasureSub);
        ChestGenHooks.getInfo((String)"pyramidJungleChest").addItem((WeightedRandomChestContent)mystTreasureSub);
        ChestGenHooks.getInfo((String)"strongholdLibrary").addItem((WeightedRandomChestContent)mystTreasureSub);
        ChestGenHooks.getInfo((String)"dungeonChest").addItem((WeightedRandomChestContent)mystTreasureSub);
        sidedProxy.createCreativeTabs();
        ArrayList<IAgeSymbol> symbols = SymbolManager.getAgeSymbols();
        for (IAgeSymbol symbol2 : symbols) {
            int maxStack = SymbolManager.getSymbolTreasureMaxStack(symbol2);
            int chance = SymbolManager.getSymbolItemWeight(symbol2.identifier());
            if (chance == 0 || maxStack == 0) continue;
            treasureinfo.addItem(new WeightedRandomChestContent(Page.createSymbolPage(symbol2.identifier()), 1, maxStack, chance));
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        MinecraftServer mcserver = event.getServer();
        ((ServerCommandManager)mcserver.func_71187_D()).func_71560_a((ICommand)new CommandTPX());
        ((ServerCommandManager)mcserver.func_71187_D()).func_71560_a((ICommand)new CommandCreateDim());
        ((ServerCommandManager)mcserver.func_71187_D()).func_71560_a((ICommand)new CommandCreateAgebook());
        ((ServerCommandManager)mcserver.func_71187_D()).func_71560_a((ICommand)new CommandToggleWorldInstability());
        if (spawnmeteorEnabled) {
            ((ServerCommandManager)mcserver.func_71187_D()).func_71560_a((ICommand)new CommandSpawnMeteor());
        }
        ((ServerCommandManager)mcserver.func_71187_D()).func_71560_a((ICommand)new CommandToggleDownfall());
        ((ServerCommandManager)mcserver.func_71187_D()).func_71560_a((ICommand)new CommandTime());
        ((ServerCommandManager)mcserver.func_71187_D()).func_71560_a((ICommand)new CommandMystPermissions());
        ((ServerCommandManager)mcserver.func_71187_D()).func_71560_a((ICommand)new CommandRegenerateChunk());
        ((ServerCommandManager)mcserver.func_71187_D()).func_71560_a((ICommand)new CommandReprofile());
        ((ServerCommandManager)mcserver.func_71187_D()).func_71560_a((ICommand)new CommandDebug());
        this.profilingThread = new ChunkProfilerManager();
        this.profilingThread.start();
        sidedProxy.startBaselineProfiling(mcserver);
        Mystcraft.registerDimensions(mcserver.func_71218_a(0).func_72860_G());
        LinkListenerPermissions.loadState();
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        TaskQueueManager.onServerStop();
        sidedProxy.stopBaselineProfiling();
        if (this.profilingThread != null) {
            this.profilingThread.halt();
            this.profilingThread = null;
        }
        Mystcraft.unregisterDimensions();
        clientStorage = null;
    }

    public static MapStorage getStorage(boolean isServer) {
        WorldServer overworld = null;
        if (isServer) {
            overworld = DimensionManager.getWorld((int)0);
        }
        if (overworld == null) {
            if (clientStorage == null) {
                throw new RuntimeException("Client-Side Storage Missing (Attempted as " + (isServer ? "server" : "remote") + ")");
            }
            return clientStorage;
        }
        return overworld.field_72988_C;
    }

    public static long getLevelSeed(MapStorage storage) {
        if (clientStorage == storage) {
            return 0L;
        }
        MinecraftServer mcServer = MinecraftServer.func_71276_C();
        if (mcServer == null) {
            return 0L;
        }
        if (DimensionManager.getWorld((int)0) == null) {
            return 0L;
        }
        return DimensionManager.getWorld((int)0).func_72905_C();
    }

    public static void unregisterDimensions() {
        deadDims = null;
        if (registeredDims == null) {
            return;
        }
        for (Integer dimId : registeredDims) {
            DimensionManager.unregisterDimension((int)dimId);
        }
        registeredDims = null;
    }

    public static void registerDimensions(ISaveHandler savehandler) {
        registeredDims = FileUtils.getExistingAgeList(savehandler.func_75758_b("dummy").getParentFile());
        deadDims = new LinkedList();
        MapStorage tempstorage = new MapStorage(savehandler);
        for (Integer dimId : registeredDims) {
            DimensionManager.registerDimension((int)dimId, (int)providerId);
            AgeData data = AgeData.getAge((int)dimId, tempstorage);
            if (!data.isDead()) continue;
            deadDims.add(dimId);
        }
    }

    @Mod.EventHandler
    public void handleNameChanges(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping elem : event.get()) {
            if (!elem.name.equals("Mystcraft:notebook")) continue;
            elem.remap(ModItems.folder);
        }
    }

    static {
        difficulty = 2;
        instabilityEnabled = true;
        renderlabels = false;
        fastRainbows = true;
        spawnmeteorEnabled = false;
        respawnInAges = true;
        villageDeskGen = true;
        inkcost = 50;
        clientStorage = null;
        requireUUID = false;
        homeDimension = 0;
    }
}

