/*
 * Decompiled with CFR 0.152.
 */
package neresources.api.messages;

import neresources.api.messages.Message;
import neresources.api.utils.Priority;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ModifyMessage
extends Message {
    private final Priority addPriority;
    private final Priority removePriority;

    public ModifyMessage(Priority addPriority, Priority removePriority) {
        this.addPriority = addPriority;
        this.removePriority = removePriority;
    }

    public ModifyMessage(Priority priority, boolean add) {
        if (add) {
            this.addPriority = priority;
            this.removePriority = Priority.FIRST;
        } else {
            this.addPriority = Priority.FIRST;
            this.removePriority = priority;
        }
    }

    public Priority getAddPriority() {
        return this.addPriority;
    }

    public Priority getRemovePriority() {
        return this.removePriority;
    }

    public abstract boolean hasAdd();

    public abstract boolean hasRemove();

    public ModifyMessage(NBTTagCompound tagCompound) {
        this.addPriority = Priority.getPriority(tagCompound.func_74762_e("addPriority"));
        this.removePriority = Priority.getPriority(tagCompound.func_74762_e("removePriority"));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("addPriority", this.addPriority.ordinal());
        tagCompound.func_74768_a("removePriority", this.removePriority.ordinal());
        return tagCompound;
    }
}

