/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.transport;

import cofh.lib.network.ByteBufHelper;
import cofh.lib.transport.IEnderChannelRegistry;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.hash.TIntObjectHashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ServerEnderChannelRegistry
implements IEnderChannelRegistry {
    protected Configuration linkConf;
    protected HashMap<String, TIntObjectHashMap<String>> channels = new HashMap();
    private int modCount;

    public ServerEnderChannelRegistry(Configuration configuration) {
        this.linkConf = configuration;
        this.load();
    }

    protected void load() {
        ++this.modCount;
        for (String string : this.linkConf.getCategoryNames()) {
            ConfigCategory configCategory = this.linkConf.getCategory(string);
            TIntObjectHashMap tIntObjectHashMap = this.channels.get(string);
            if (tIntObjectHashMap == null) {
                tIntObjectHashMap = new TIntObjectHashMap();
                this.channels.put(string, (TIntObjectHashMap<String>)tIntObjectHashMap);
            }
            for (Property property : configCategory.values()) {
                try {
                    int n = Integer.parseInt(property.getName());
                    tIntObjectHashMap.put(n, (Object)property.getString());
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void save() {
        if (this.linkConf.hasChanged()) {
            this.linkConf.save();
        }
    }

    public ByteBuf getFrequencyData(String string) {
        TIntObjectHashMap<String> tIntObjectHashMap = this.channels.get(string);
        ByteBuf byteBuf = Unpooled.buffer();
        if (tIntObjectHashMap != null) {
            TIntObjectIterator tIntObjectIterator = tIntObjectHashMap.iterator();
            ByteBufHelper.writeVarInt(tIntObjectHashMap.size(), byteBuf);
            ByteBufHelper.writeString(string, byteBuf);
            while (tIntObjectIterator.hasNext()) {
                tIntObjectIterator.advance();
                ByteBufHelper.writeVarInt(tIntObjectIterator.key(), byteBuf);
                ByteBufHelper.writeString((String)tIntObjectIterator.value(), byteBuf);
            }
        } else {
            ByteBufHelper.writeVarInt(0, byteBuf);
            ByteBufHelper.writeString(string, byteBuf);
        }
        return byteBuf;
    }

    @Override
    public List<IEnderChannelRegistry.Frequency> getFrequencyList(String string) {
        LinkedList<IEnderChannelRegistry.Frequency> linkedList = new LinkedList<IEnderChannelRegistry.Frequency>();
        TIntObjectHashMap<String> tIntObjectHashMap = this.channels.get(string);
        if (tIntObjectHashMap != null) {
            TIntObjectIterator tIntObjectIterator = tIntObjectHashMap.iterator();
            while (tIntObjectIterator.hasNext()) {
                tIntObjectIterator.advance();
                linkedList.add(new IEnderChannelRegistry.Frequency(tIntObjectIterator.key(), (String)tIntObjectIterator.value()));
            }
        }
        return linkedList;
    }

    @Override
    public String getFrequency(String string, int n) {
        TIntObjectHashMap<String> tIntObjectHashMap = this.channels.get(string);
        if (tIntObjectHashMap != null) {
            return (String)tIntObjectHashMap.get(n);
        }
        return null;
    }

    @Override
    public String setFrequency(String string, int n, String string2) {
        TIntObjectHashMap tIntObjectHashMap = this.channels.get(string);
        if (tIntObjectHashMap == null) {
            tIntObjectHashMap = new TIntObjectHashMap();
            this.channels.put(string, (TIntObjectHashMap<String>)tIntObjectHashMap);
        }
        String string3 = (String)tIntObjectHashMap.put(n, (Object)string2);
        ++this.modCount;
        this.linkConf.get(string, String.valueOf(n), "").set(string2);
        return string3;
    }

    @Override
    public String removeFrequency(String string, int n) {
        TIntObjectHashMap<String> tIntObjectHashMap = this.channels.get(string);
        if (tIntObjectHashMap == null) {
            return null;
        }
        String string2 = (String)tIntObjectHashMap.remove(n);
        if (string2 != null) {
            ++this.modCount;
            this.linkConf.getCategory(string).remove((Object)String.valueOf(n));
        }
        return string2;
    }

    @Override
    public int updated() {
        return this.modCount;
    }
}

