/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Preconditions;
import cpw.mods.fml.common.eventhandler.Event;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;

public class BlockManipulator {
    public final World world;
    public final EntityPlayer player;
    public int x;
    public int y;
    public int z;
    private boolean spawnProtection = true;
    private boolean eventCheck = true;
    private boolean silentTeRemove = false;
    private int blockPlaceFlags = 3;

    public BlockManipulator(@Nonnull World world, @Nonnull EntityPlayer player, int x, int y, int z) {
        Preconditions.checkNotNull((Object)world);
        this.world = world;
        Preconditions.checkNotNull((Object)player);
        this.player = player;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockManipulator setSpawnProtection(boolean value) {
        this.spawnProtection = value;
        return this;
    }

    public BlockManipulator setEventCheck(boolean value) {
        this.eventCheck = value;
        return this;
    }

    public BlockManipulator setSilentTeRemove(boolean value) {
        this.silentTeRemove = value;
        return this;
    }

    public BlockManipulator setBlockPlaceFlags(int value) {
        this.blockPlaceFlags = value;
        return this;
    }

    public boolean remove() {
        if (!this.world.func_72899_e(this.x, this.y, this.z)) {
            return false;
        }
        if (this.spawnProtection && !this.world.func_72962_a(this.player, this.x, this.y, this.z)) {
            return false;
        }
        if (this.eventCheck) {
            Block block = this.world.func_147439_a(this.x, this.y, this.z);
            int meta = this.world.func_72805_g(this.x, this.y, this.z);
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(this.x, this.y, this.z, this.world, block, meta, this.player);
            event.setExpToDrop(0);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return false;
            }
        }
        if (this.silentTeRemove) {
            this.world.func_147475_p(this.x, this.y, this.z);
        }
        return this.world.func_147468_f(this.x, this.y, this.z);
    }

    public boolean place(Block block, int meta) {
        if (!this.world.func_72899_e(this.x, this.y, this.z)) {
            return false;
        }
        if (this.spawnProtection && !this.world.func_72962_a(this.player, this.x, this.y, this.z)) {
            return false;
        }
        BlockSnapshot snapshot = BlockSnapshot.getBlockSnapshot((World)this.world, (int)this.x, (int)this.y, (int)this.z);
        if (!this.world.func_147465_d(this.x, this.y, this.z, block, meta, this.blockPlaceFlags)) {
            return false;
        }
        if (ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)this.player, (BlockSnapshot)snapshot, (ForgeDirection)ForgeDirection.UNKNOWN).isCanceled()) {
            this.world.restoringBlockSnapshots = true;
            snapshot.restore(true, false);
            this.world.restoringBlockSnapshots = false;
            return false;
        }
        return true;
    }
}

