/*
 * Decompiled with CFR 0.152.
 */
package openmods.structured;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.lang.reflect.Field;
import openmods.structured.ElementField;
import openmods.structured.IStructureContainer;
import openmods.structured.IStructureElement;
import openmods.structured.StructureField;

public abstract class FieldContainer
implements IStructureContainer<IStructureElement> {
    private static final int NULL = -1;
    private final TObjectIntMap<Field> fields = new TObjectIntHashMap(10, 0.5f, -1);

    @Override
    public void createElements(IStructureContainer.IElementAddCallback<IStructureElement> callback) {
        for (Field field : this.getClass().getFields()) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(StructureField.class)) continue;
            ElementField fieldWrapper = new ElementField(this, field);
            int fieldId = callback.addElement(fieldWrapper);
            this.fields.put((Object)field, fieldId);
        }
    }

    public Integer getElementIdForField(Field field) {
        int id = this.fields.get((Object)field);
        return id != -1 ? Integer.valueOf(id) : null;
    }
}

