/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import openmods.gui.component.BaseComponent;
import openmods.utils.TextureUtils;
import org.lwjgl.opengl.GL11;

public class GuiComponentItemStackSpinner
extends BaseComponent {
    private ItemStack stack;
    private float rotationY = 0.0f;
    private static ItemRenderer itemRenderer;
    private static RenderBlocks blockRenderer;

    public GuiComponentItemStackSpinner(int x, int y, ItemStack stack) {
        super(x, y);
        if (itemRenderer == null) {
            itemRenderer = new ItemRenderer(Minecraft.func_71410_x());
        }
        this.stack = stack;
    }

    @Override
    public int getWidth() {
        return 64;
    }

    @Override
    public int getHeight() {
        return 64;
    }

    @Override
    public void render(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
    }

    @Override
    public void renderOverlay(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glEnable((int)2929);
        float scale = 30.0f;
        GL11.glTranslated((double)((float)(offsetX + this.x) + scale / 2.0f), (double)((float)(offsetY + this.y) + scale / 2.0f), (double)scale);
        GL11.glScaled((double)scale, (double)(-scale), (double)scale);
        this.rotationY += 0.6f;
        GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)this.rotationY, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.renderItem(this.stack);
        GL11.glDisable((int)2929);
        GL11.glPopMatrix();
    }

    public void renderItem(ItemStack itemStack) {
        GL11.glPushMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        Item item = itemStack.func_77973_b();
        Block block = null;
        if (item instanceof ItemBlock) {
            block = Block.func_149634_a((Item)item);
        }
        TextureUtils.bindItemStackTexture(itemStack);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)itemStack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY);
        if (customRenderer != null) {
            ForgeHooksClient.renderEquippedItem((IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.EQUIPPED, (IItemRenderer)customRenderer, (RenderBlocks)blockRenderer, (EntityLivingBase)player, (ItemStack)itemStack);
        } else if (block != null && itemStack.func_94608_d() == 0 && RenderBlocks.func_147739_a((int)block.func_149645_b())) {
            blockRenderer.func_147800_a(block, itemStack.func_77960_j(), 1.0f);
        } else {
            GuiComponentItemStackSpinner.renderItem(itemStack, (EntityLivingBase)player);
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    private static void renderItem(ItemStack itemStack, EntityLivingBase player) {
        IIcon icon = player.func_70620_b(itemStack, 0);
        if (icon != null) {
            Tessellator tessellator = Tessellator.field_78398_a;
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        }
    }

    static {
        blockRenderer = new RenderBlocks();
    }
}

