/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.collect.Maps;
import java.util.Map;
import openmods.calc.ICalculatorFrame;
import openmods.calc.ISymbol;
import openmods.utils.Stack;

public class LocalFrame<E>
implements ICalculatorFrame<E> {
    private final ICalculatorFrame<E> parent;
    private final Map<String, ISymbol<E>> locals = Maps.newHashMap();
    private final Stack<E> stack = new Stack();

    public LocalFrame(ICalculatorFrame<E> parent) {
        this.parent = parent instanceof LocalFrame ? ((LocalFrame)parent).parent : parent;
    }

    public void setLocalSymbol(String symbol, ISymbol<E> value) {
        this.locals.put(symbol, value);
    }

    @Override
    public ISymbol<E> getSymbol(String id) {
        ISymbol<E> symbol = this.locals.get(id);
        return symbol != null ? symbol : (this.parent != null ? this.parent.getSymbol(id) : null);
    }

    @Override
    public Stack<E> stack() {
        return this.stack;
    }
}

