/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import openmods.calc.BinaryFunction;
import openmods.calc.BinaryOperator;
import openmods.calc.Calculator;
import openmods.calc.Constant;
import openmods.calc.DoubleParser;
import openmods.calc.DoublePrinter;
import openmods.calc.ISymbol;
import openmods.calc.OperatorDictionary;
import openmods.calc.TopFrame;
import openmods.calc.UnaryFunction;
import openmods.calc.UnaryOperator;
import openmods.config.simpler.Configurable;

public class DoubleCalculator
extends Calculator<Double> {
    private static final int MAX_PRIO = 5;
    @Configurable
    public int base = 10;
    @Configurable
    public boolean allowStandardPrinter = false;
    @Configurable
    public boolean uniformBaseNotation = false;
    private final DoublePrinter printer = new DoublePrinter(8);

    public DoubleCalculator() {
        super(new DoubleParser(), 0.0);
    }

    @Override
    protected void setupOperators(OperatorDictionary<Double> operators) {
        operators.registerUnaryOperator("neg", new UnaryOperator<Double>(){

            @Override
            protected Double execute(Double value) {
                return -value.doubleValue();
            }
        });
        operators.registerMixedOperator("+", new BinaryOperator<Double>(1){

            @Override
            protected Double execute(Double left, Double right) {
                return left + right;
            }
        }, new UnaryOperator<Double>(){

            @Override
            protected Double execute(Double value) {
                return (double)value;
            }
        });
        operators.registerMixedOperator("-", new BinaryOperator<Double>(1){

            @Override
            protected Double execute(Double left, Double right) {
                return left - right;
            }
        }, new UnaryOperator<Double>(){

            @Override
            protected Double execute(Double value) {
                return -value.doubleValue();
            }
        });
        operators.registerBinaryOperator("*", new BinaryOperator<Double>(2){

            @Override
            protected Double execute(Double left, Double right) {
                return left * right;
            }
        });
        operators.registerBinaryOperator("/", new BinaryOperator<Double>(2){

            @Override
            protected Double execute(Double left, Double right) {
                return left / right;
            }
        });
        operators.registerBinaryOperator("%", new BinaryOperator<Double>(2){

            @Override
            protected Double execute(Double left, Double right) {
                return left % right;
            }
        });
        operators.registerBinaryOperator("^", new BinaryOperator<Double>(3){

            @Override
            protected Double execute(Double left, Double right) {
                return Math.pow(left, right);
            }
        });
    }

    @Override
    protected void setupGlobals(TopFrame<Double> globals) {
        globals.setSymbol("PI", Constant.create(Math.PI));
        globals.setSymbol("E", Constant.create(Math.E));
        globals.setSymbol("INF", Constant.create(Double.POSITIVE_INFINITY));
        globals.setSymbol("MAX", Constant.create(Double.MIN_VALUE));
        globals.setSymbol("abs", (ISymbol<Double>)new UnaryFunction<Double>(){

            @Override
            protected Double execute(Double value) {
                return Math.abs(value);
            }
        });
        globals.setSymbol("sgn", (ISymbol<Double>)new UnaryFunction<Double>(){

            @Override
            protected Double execute(Double value) {
                return Math.signum(value);
            }
        });
        globals.setSymbol("sqrt", (ISymbol<Double>)new UnaryFunction<Double>(){

            @Override
            protected Double execute(Double value) {
                return Math.sqrt(value);
            }
        });
        globals.setSymbol("ceil", (ISymbol<Double>)new UnaryFunction<Double>(){

            @Override
            protected Double execute(Double value) {
                return Math.ceil(value);
            }
        });
        globals.setSymbol("floor", (ISymbol<Double>)new UnaryFunction<Double>(){

            @Override
            protected Double execute(Double value) {
                return Math.floor(value);
            }
        });
        globals.setSymbol("cos", (ISymbol<Double>)new UnaryFunction<Double>(){

            @Override
            protected Double execute(Double value) {
                return Math.cos(value);
            }
        });
        globals.setSymbol("sin", (ISymbol<Double>)new UnaryFunction<Double>(){

            @Override
            protected Double execute(Double value) {
                return Math.sin(value);
            }
        });
        globals.setSymbol("tan", (ISymbol<Double>)new UnaryFunction<Double>(){

            @Override
            protected Double execute(Double value) {
                return Math.tan(value);
            }
        });
        globals.setSymbol("acos", (ISymbol<Double>)new UnaryFunction<Double>(){

            @Override
            protected Double execute(Double value) {
                return Math.acos(value);
            }
        });
        globals.setSymbol("asin", (ISymbol<Double>)new UnaryFunction<Double>(){

            @Override
            protected Double execute(Double value) {
                return Math.asin(value);
            }
        });
        globals.setSymbol("atan", (ISymbol<Double>)new UnaryFunction<Double>(){

            @Override
            protected Double execute(Double value) {
                return Math.atan(value);
            }
        });
        globals.setSymbol("atan2", (ISymbol<Double>)new BinaryFunction<Double>(){

            @Override
            protected Double execute(Double left, Double right) {
                return Math.atan2(left, right);
            }
        });
        globals.setSymbol("log10", (ISymbol<Double>)new UnaryFunction<Double>(){

            @Override
            protected Double execute(Double value) {
                return Math.log10(value);
            }
        });
        globals.setSymbol("ln", (ISymbol<Double>)new UnaryFunction<Double>(){

            @Override
            protected Double execute(Double value) {
                return Math.log(value);
            }
        });
        globals.setSymbol("log", (ISymbol<Double>)new BinaryFunction<Double>(){

            @Override
            protected Double execute(Double left, Double right) {
                return Math.log(left) / Math.log(right);
            }
        });
        globals.setSymbol("exp", (ISymbol<Double>)new UnaryFunction<Double>(){

            @Override
            protected Double execute(Double value) {
                return Math.exp(value);
            }
        });
        globals.setSymbol("min", new Calculator.AccumulatorFunction(){

            protected Double accumulate(Double result, Double value) {
                return Math.min(result, value);
            }
        });
        globals.setSymbol("max", new Calculator.AccumulatorFunction(){

            protected Double accumulate(Double result, Double value) {
                return Math.max(result, value);
            }
        });
        globals.setSymbol("rad", (ISymbol<Double>)new UnaryFunction<Double>(){

            @Override
            protected Double execute(Double value) {
                return Math.toRadians(value);
            }
        });
        globals.setSymbol("deg", (ISymbol<Double>)new UnaryFunction<Double>(){

            @Override
            protected Double execute(Double value) {
                return Math.toDegrees(value);
            }
        });
    }

    @Override
    public String toString(Double value) {
        if (this.base == 10 && !this.allowStandardPrinter && !this.uniformBaseNotation) {
            return value.toString();
        }
        if (value.isNaN()) {
            return "NaN";
        }
        if (value.isInfinite()) {
            return value > 0.0 ? "+Inf" : "-Inf";
        }
        String result = this.printer.toString(value, this.base);
        return DoubleCalculator.decorateBase(!this.uniformBaseNotation, this.base, result);
    }
}

