/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import openmods.calc.ICalculatorFrame;
import openmods.calc.Operator;
import openmods.calc.UnaryOperator;
import openmods.utils.Stack;

public abstract class BinaryOperator<E>
extends Operator<E> {
    public final int precedence;
    public final Associativity associativity;

    public BinaryOperator(int precedence, Associativity associativity) {
        this.precedence = precedence;
        this.associativity = associativity;
    }

    public BinaryOperator(int precendence) {
        this(precendence, Associativity.LEFT);
    }

    protected abstract E execute(E var1, E var2);

    @Override
    public final void execute(ICalculatorFrame<E> frame) {
        Stack<E> stack = frame.stack();
        E right = stack.pop();
        E left = stack.pop();
        E result = this.execute(left, right);
        stack.push(result);
    }

    @Override
    public boolean isLessThan(Operator<E> other) {
        if (other instanceof UnaryOperator) {
            return true;
        }
        BinaryOperator o = (BinaryOperator)other;
        return this.associativity.isLessThan(this.precedence, o.precedence);
    }

    public static enum Associativity {
        LEFT{

            @Override
            protected boolean isLessThan(int left, int right) {
                return left <= right;
            }
        }
        ,
        RIGHT{

            @Override
            protected boolean isLessThan(int left, int right) {
                return left < right;
            }
        };


        protected abstract boolean isLessThan(int var1, int var2);
    }
}

