/*
 * Decompiled with CFR 0.152.
 */
package openmods.access;

import com.google.common.base.Throwables;

public abstract class ApiInstanceProvider<T> {
    public abstract T getInterface();

    public static class Singleton<T>
    extends ApiInstanceProvider<T> {
        private final T obj;

        public Singleton(T obj) {
            this.obj = obj;
        }

        @Override
        public T getInterface() {
            return this.obj;
        }

        public String toString() {
            return "SingletonProvider [obj=" + this.obj + "]";
        }
    }

    public static class NewInstance<T>
    extends ApiInstanceProvider<T> {
        private final Class<? extends T> cls;

        public NewInstance(Class<? extends T> cls) {
            this.cls = cls;
        }

        @Override
        public T getInterface() {
            try {
                return this.cls.newInstance();
            }
            catch (Throwable t) {
                throw Throwables.propagate((Throwable)t);
            }
        }

        public String toString() {
            return "NewInstanceProvider [cls=" + this.cls + "]";
        }
    }

    public static class CachedInstance<T>
    extends ApiInstanceProvider<T> {
        private final T instance;

        public CachedInstance(Class<? extends T> cls) {
            try {
                this.instance = cls.newInstance();
            }
            catch (Throwable t) {
                throw Throwables.propagate((Throwable)t);
            }
        }

        @Override
        public T getInterface() {
            return this.instance;
        }

        public String toString() {
            return "SingleInstanceProvider [instance=" + this.instance + "]";
        }
    }
}

