/*
 * Decompiled with CFR 0.152.
 */
package se.rupy.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URL;
import se.rupy.http.Daemon;
import se.rupy.http.Deploy;
import se.rupy.http.Event;
import se.rupy.http.Session;

class Test
implements Runnable {
    static final String intro = "Parallel testing with one worker thread:\r\n- Fixed and chunked, read and write.\r\n- Asynchronous non-blocking reply.\r\n- Session creation and timeout.\r\n- Exception handling.\r\nNOTICE: The test receives and sends the bin/http.jar\r\nwhich is ~60kb, if you wonder why it takes time.\r\n             ---o---";
    static final int other_count = 300;
    static final int comet_count = 5;
    static final int comet_sleep = 30;
    static final String[] unit = new String[]{"comet", "chunk", "fixed", "error"};
    static final String original = "bin/http.jar";
    protected boolean failed;
    protected int loop;
    protected int done;
    protected int http;
    protected String host;
    protected String name;
    protected Service service;
    protected Daemon daemon;
    protected Thread thread;
    protected long time;
    protected static File file;
    protected static Test test;

    protected Test(Daemon daemon, int loop) {
        this.loop = loop;
        file = new File(original);
        this.daemon = daemon;
        test = this;
        this.thread = new Thread((Runnable)this, "RupyTest-" + loop);
        this.thread.start();
    }

    protected Test(String host, String name, int loop) throws IOException {
        this.host = host;
        this.name = name;
        this.loop = loop;
        this.service = new Service(name);
    }

    protected Service service() {
        return this.service;
    }

    protected boolean failed() {
        return this.failed || this.service.failed();
    }

    protected String name() {
        return this.name;
    }

    protected void done(Test test) {
        ++this.done;
        ++this.http;
        System.out.println(this.done + "/" + (unit.length + 2) + " Done: " + test.name + " (" + test.loop + ")");
        if (this.http == unit.length) {
            System.out.println(900 * this.loop + 5 * this.loop + " dynamic requests in " + (System.currentTimeMillis() - this.time) + " ms.");
        }
        this.done();
    }

    protected void done(String text) {
        ++this.done;
        System.out.println(this.done + "/" + (unit.length + 2) + " Done: " + text);
        this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void done() {
        if (this.done == unit.length + 2) {
            Thread thread = this.thread;
            synchronized (thread) {
                this.thread.notify();
            }
        }
    }

    void save(String name, InputStream in) {
        int read = 0;
        try {
            File file = new File(name);
            FileOutputStream out = new FileOutputStream(file);
            read = Deploy.pipe(in, out);
            out.flush();
            ((OutputStream)out).close();
            if (file.length() != Test.file.length()) {
                this.failed = true;
            }
        }
        catch (Exception e) {
            System.out.println(name + " failed. (" + read + ")");
            e.printStackTrace();
            this.failed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.daemon != null) {
                this.test(this.daemon);
                return;
            }
            for (int i = 0; i < this.loop; ++i) {
                this.connect();
            }
        }
        catch (ConnectException ce) {
            System.out.println("Connection failed, is there a server on " + this.host + "?");
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.failed = true;
            if (this.daemon != null) {
                System.exit(1);
            }
        }
        finally {
            test.done(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void test(Daemon daemon) throws Exception {
        System.out.println(intro);
        Thread.sleep(100L);
        this.time = System.currentTimeMillis();
        System.out.println("START");
        Test[] test = new Test[unit.length];
        for (int i = 0; i < test.length; ++i) {
            test[i] = new Test("localhost:" + daemon.port, unit[i], this.loop * (unit[i].equals("comet") ? 5 : 300));
            daemon.add(test[i].service());
            Thread thread = new Thread((Runnable)test[i], "RupyTestCase-" + i);
            thread.start();
        }
        Thread i = this.thread;
        synchronized (i) {
            this.thread.wait();
        }
        boolean failed = false;
        for (int i2 = 0; i2 < test.length; ++i2) {
            if (test[i2].failed()) {
                failed = true;
            }
            new File(test[i2].name).deleteOnExit();
        }
        System.out.println(failed ? "UNIT FAILED! (see log/error.txt)" : "UNIT SUCCESSFUL!");
        System.exit(0);
    }

    private void connect() throws IOException {
        URL url = new URL("http://" + this.host + "/" + this.name);
        if (this.name.equals("error")) {
            String error = Deploy.Client.toString(new Deploy.Client().send(url, null, null, true));
            if (error.indexOf("Error successful") == -1) {
                this.failed = true;
            }
        } else {
            this.save(this.name, new Deploy.Client().send(url, file, null, true));
        }
    }

    static class Service
    extends se.rupy.http.Service
    implements Runnable {
        protected static boolean session;
        protected static boolean timeout;
        protected String path;
        protected Event event;
        protected boolean failed;

        public Service(String name) {
            this.path = "/" + name;
        }

        @Override
        public String path() {
            return this.path;
        }

        protected boolean failed() {
            return this.failed;
        }

        @Override
        public void session(Session session, int type) {
            if (type == 1) {
                if (!Service.session) {
                    Service.session = true;
                    test.done("Session successful.");
                }
            } else if (type == 2) {
                if (!timeout) {
                    timeout = true;
                    test.done("Timeout successful.");
                }
            } else {
                System.out.println("Socket closed. (" + this.path + ")");
            }
        }

        @Override
        public void filter(Event event) throws Event, Exception {
            try {
                this.work(event);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.failed = true;
                throw e;
            }
            if (this.path.equals("/error")) {
                throw new Exception("Error successful.");
            }
        }

        private void work(Event event) throws Exception {
            if (this.path.equals("/chunk")) {
                this.load(event);
                this.write(event.output());
            } else if (this.path.equals("/fixed")) {
                this.load(event);
                this.write(event.reply().output(file.length()));
            } else if (this.path.equals("/comet")) {
                if (event.push()) {
                    this.write(event.output());
                    event.output().finish();
                } else {
                    this.load(event);
                    this.event = event;
                    new Thread((Runnable)this, "RupyTestWork").start();
                }
            }
        }

        private void load(Event event) throws IOException {
            int read = this.read(event.input());
            if ((long)read != file.length()) {
                this.failed = true;
            }
        }

        @Override
        public void run() {
            try {
                Thread.sleep(30L);
                this.event.reply().wakeup();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        int read(InputStream in) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            return Deploy.pipe(in, out);
        }

        int write(OutputStream out) throws IOException {
            File file = new File(Test.original);
            FileInputStream in = new FileInputStream(file);
            return Deploy.pipe(in, out);
        }
    }
}

