/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.service;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import journeymap.client.JourneymapClient;
import journeymap.client.log.ChatLog;
import journeymap.client.log.LogFormatter;
import journeymap.client.properties.WebMapProperties;
import journeymap.client.service.ActionService;
import journeymap.client.service.DataService;
import journeymap.client.service.DebugService;
import journeymap.client.service.FileService;
import journeymap.client.service.LogService;
import journeymap.client.service.MapApiService;
import journeymap.client.service.PropertyService;
import journeymap.client.service.TileService;
import journeymap.common.Journeymap;
import journeymap.common.thread.JMThreadFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import se.rupy.http.Daemon;

public class WebServer {
    private static final int MAXPORT = 9990;
    private static final int MAXFAILS = 5;
    private static volatile WebServer instance;
    private final Logger logger = Journeymap.getLogger();
    private Daemon rupy;
    private int port;
    private boolean ready = false;

    private WebServer() {
        this.port = JourneymapClient.getWebMapProperties().port.get();
        this.validatePort();
    }

    public static void setEnabled(Boolean enable, boolean forceAnnounce) {
        WebMapProperties webMapProperties = JourneymapClient.getWebMapProperties();
        webMapProperties.enabled.set(enable);
        webMapProperties.save();
        if (instance != null) {
            try {
                instance.stop();
            }
            catch (Throwable e) {
                Journeymap.getLogger().log(Level.ERROR, LogFormatter.toString(e));
            }
        }
        if (enable.booleanValue()) {
            try {
                instance = new WebServer();
                if (instance.isReady()) {
                    instance.start();
                } else {
                    enable = false;
                }
            }
            catch (Throwable e) {
                Journeymap.getLogger().log(Level.ERROR, LogFormatter.toString(e));
                enable = false;
            }
            if (!enable.booleanValue()) {
                Journeymap.getLogger().error("Unexpected error, JMServer couldn't be started.");
            }
        }
        if (forceAnnounce) {
            ChatLog.enableAnnounceMod = true;
        }
        ChatLog.announceMod(forceAnnounce);
    }

    public static WebServer getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validatePort() {
        int hardFails = 0;
        int testPort = this.port;
        int maxPort = Math.max(9990, this.port + 1000);
        boolean validPort = false;
        while (!validPort && hardFails <= 5 && testPort <= maxPort) {
            ServerSocketChannel server = null;
            try {
                server = ServerSocketChannel.open();
                server.socket().bind(new InetSocketAddress(testPort));
                validPort = true;
            }
            catch (BindException e) {
                this.logger.warn("Port " + testPort + " already in use");
                testPort += 10;
            }
            catch (Throwable t) {
                this.logger.error("Error when testing port " + testPort + ": " + t);
                ++hardFails;
            }
            finally {
                if (server == null) continue;
                try {
                    server.close();
                }
                catch (IOException e) {}
            }
        }
        this.ready = validPort;
        if (this.ready && this.port != testPort) {
            this.logger.info("Webserver will use port " + testPort + " for this session");
            this.port = testPort;
        }
        if (!this.ready && hardFails > 5) {
            this.logger.error("Gave up finding a port for webserver after " + hardFails + " failures to test ports!");
        }
        if (!this.ready && testPort > 9990) {
            this.logger.error("Gave up finding a port for webserver after testing ports " + this.port + " - " + maxPort + " without finding one open!");
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    public int getPort() {
        return this.port;
    }

    public void start() throws Exception {
        if (!this.ready) {
            throw new IllegalStateException("Initialization failed");
        }
        Properties props = new Properties();
        props.put("port", Integer.toString(this.port));
        props.put("delay", Integer.toString(5000));
        props.put("timeout", Integer.toString(0));
        props.put("threads", Integer.toString(5));
        Level logLevel = Level.toLevel((String)JourneymapClient.getCoreProperties().logLevel.get(), (Level)Level.INFO);
        if (logLevel.intLevel() >= Level.TRACE.intLevel()) {
            props.put("debug", Boolean.TRUE.toString());
        }
        if (logLevel.intLevel() >= Level.TRACE.intLevel()) {
            props.put("verbose", Boolean.TRUE.toString());
        }
        this.rupy = new Daemon(props);
        this.rupy.add(new DataService());
        this.rupy.add(new LogService());
        this.rupy.add(new TileService());
        this.rupy.add(new ActionService());
        this.rupy.add(new FileService());
        this.rupy.add(new PropertyService());
        this.rupy.add(new DebugService());
        this.rupy.add(new MapApiService());
        this.rupy.init();
        JMThreadFactory tf = new JMThreadFactory("svr");
        ExecutorService es = Executors.newSingleThreadExecutor(tf);
        es.execute(this.rupy);
        Runtime.getRuntime().addShutdownHook(tf.newThread(new Runnable(){

            @Override
            public void run() {
                WebServer.this.stop();
            }
        }));
        this.logger.info("Started webserver on port " + this.port);
    }

    public void stop() {
        try {
            if (this.rupy.isAlive()) {
                this.rupy.stop();
                this.logger.info("Stopped webserver without errors");
            }
        }
        catch (Throwable t) {
            this.logger.info("Stopped webserver with error: " + t);
        }
    }
}

