/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.FilterWriteStrategy;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLine;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngIDatChunkOutputStream;
import ar.com.hjg.pngj.PngReader;
import ar.com.hjg.pngj.PngjExceptionInternal;
import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.PngjUnsupportedException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunksListForWrite;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkIEND;
import ar.com.hjg.pngj.chunks.PngChunkIHDR;
import ar.com.hjg.pngj.chunks.PngChunkSkipped;
import ar.com.hjg.pngj.chunks.PngChunkTextVar;
import ar.com.hjg.pngj.chunks.PngMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PngWriter {
    public final ImageInfo imgInfo;
    private final String filename;
    protected int rowNum = -1;
    private final ChunksListForWrite chunksList;
    private final PngMetadata metadata;
    protected int currentChunkGroup = -1;
    protected FilterWriteStrategy filterStrat;
    private int compLevel = 6;
    private boolean shouldCloseStream = true;
    private PngIDatChunkOutputStream datStream;
    private DeflaterOutputStream datStreamDeflated;
    private int deflaterStrategy = 1;
    private int[] histox = new int[256];
    private int idatMaxSize = 0;
    private final OutputStream os;
    protected byte[] rowb = null;
    protected byte[] rowbfilter = null;
    protected byte[] rowbprev = null;
    private boolean unpackedMode = false;

    public PngWriter(OutputStream outputStream, ImageInfo imgInfo) {
        this(outputStream, imgInfo, "[NO FILENAME AVAILABLE]");
    }

    public PngWriter(OutputStream outputStream, ImageInfo imgInfo, String filenameOrDescription) {
        this.filename = filenameOrDescription == null ? "" : filenameOrDescription;
        this.os = outputStream;
        this.imgInfo = imgInfo;
        this.rowb = new byte[imgInfo.bytesPerRow + 1];
        this.rowbprev = new byte[this.rowb.length];
        this.rowbfilter = new byte[this.rowb.length];
        this.chunksList = new ChunksListForWrite(imgInfo);
        this.metadata = new PngMetadata(this.chunksList);
        this.filterStrat = new FilterWriteStrategy(imgInfo, FilterType.FILTER_DEFAULT);
    }

    private void init() {
        this.datStream = new PngIDatChunkOutputStream(this.os, this.idatMaxSize);
        Deflater def = new Deflater(this.compLevel);
        def.setStrategy(this.deflaterStrategy);
        this.datStreamDeflated = new DeflaterOutputStream((OutputStream)this.datStream, def);
        this.writeSignatureAndIHDR();
        this.writeFirstChunks();
    }

    private void reportResultsForFilter(int rown, FilterType type, boolean tentative) {
        Arrays.fill(this.histox, 0);
        int s = 0;
        for (int i = 1; i <= this.imgInfo.bytesPerRow; ++i) {
            byte v = this.rowbfilter[i];
            s = v < 0 ? (s -= v) : (s += v);
            int n = v & 0xFF;
            this.histox[n] = this.histox[n] + 1;
        }
        this.filterStrat.fillResultsForFilter(rown, type, s, this.histox, tentative);
    }

    private void writeEndChunk() {
        PngChunkIEND c = new PngChunkIEND(this.imgInfo);
        c.createRawChunk().writeChunk(this.os);
    }

    private void writeFirstChunks() {
        int nw = 0;
        this.currentChunkGroup = 1;
        nw = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        this.currentChunkGroup = 2;
        nw = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        if (nw > 0 && this.imgInfo.greyscale) {
            throw new PngjOutputException("cannot write palette for this format");
        }
        if (nw == 0 && this.imgInfo.indexed) {
            throw new PngjOutputException("missing palette");
        }
        this.currentChunkGroup = 3;
        nw = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        this.currentChunkGroup = 4;
    }

    private void writeLastChunks() {
        this.currentChunkGroup = 5;
        this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        List<PngChunk> pending = this.chunksList.getQueuedChunks();
        if (!pending.isEmpty()) {
            throw new PngjOutputException(pending.size() + " chunks were not written! Eg: " + pending.get(0).toString());
        }
        this.currentChunkGroup = 6;
    }

    private void writeSignatureAndIHDR() {
        this.currentChunkGroup = 0;
        PngHelperInternal.writeBytes(this.os, PngHelperInternal.getPngIdSignature());
        PngChunkIHDR ihdr = new PngChunkIHDR(this.imgInfo);
        ihdr.setCols(this.imgInfo.cols);
        ihdr.setRows(this.imgInfo.rows);
        ihdr.setBitspc(this.imgInfo.bitDepth);
        int colormodel = 0;
        if (this.imgInfo.alpha) {
            colormodel += 4;
        }
        if (this.imgInfo.indexed) {
            ++colormodel;
        }
        if (!this.imgInfo.greyscale) {
            colormodel += 2;
        }
        ihdr.setColormodel(colormodel);
        ihdr.setCompmeth(0);
        ihdr.setFilmeth(0);
        ihdr.setInterlaced(0);
        ihdr.createRawChunk().writeChunk(this.os);
    }

    protected void encodeRowFromByte(byte[] row) {
        if (row.length == this.imgInfo.samplesPerRowPacked) {
            int j = 1;
            if (this.imgInfo.bitDepth <= 8) {
                for (byte x : row) {
                    this.rowb[j++] = x;
                }
            } else {
                byte[] arr$ = row;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    byte x;
                    this.rowb[j] = x = arr$[i$];
                    j += 2;
                }
            }
        } else {
            if (row.length >= this.imgInfo.samplesPerRow && this.unpackedMode) {
                ImageLine.packInplaceByte(this.imgInfo, row, row, false);
            }
            if (this.imgInfo.bitDepth <= 8) {
                int j = 1;
                for (int i = 0; i < this.imgInfo.samplesPerRowPacked; ++i) {
                    this.rowb[j++] = row[i];
                }
            } else {
                int j = 1;
                for (int i = 0; i < this.imgInfo.samplesPerRowPacked; ++i) {
                    this.rowb[j++] = row[i];
                    this.rowb[j++] = 0;
                }
            }
        }
    }

    protected void encodeRowFromInt(int[] row) {
        if (row.length == this.imgInfo.samplesPerRowPacked) {
            int j = 1;
            if (this.imgInfo.bitDepth <= 8) {
                for (int x : row) {
                    this.rowb[j++] = (byte)x;
                }
            } else {
                for (int x : row) {
                    this.rowb[j++] = (byte)(x >> 8);
                    this.rowb[j++] = (byte)x;
                }
            }
        } else {
            if (row.length >= this.imgInfo.samplesPerRow && this.unpackedMode) {
                ImageLine.packInplaceInt(this.imgInfo, row, row, false);
            }
            if (this.imgInfo.bitDepth <= 8) {
                int j = 1;
                for (int i = 0; i < this.imgInfo.samplesPerRowPacked; ++i) {
                    this.rowb[j++] = (byte)row[i];
                }
            } else {
                int j = 1;
                for (int i = 0; i < this.imgInfo.samplesPerRowPacked; ++i) {
                    this.rowb[j++] = (byte)(row[i] >> 8);
                    this.rowb[j++] = (byte)row[i];
                }
            }
        }
    }

    private void filterRow(int rown) {
        if (this.filterStrat.shouldTestAll(rown)) {
            this.filterRowNone();
            this.reportResultsForFilter(rown, FilterType.FILTER_NONE, true);
            this.filterRowSub();
            this.reportResultsForFilter(rown, FilterType.FILTER_SUB, true);
            this.filterRowUp();
            this.reportResultsForFilter(rown, FilterType.FILTER_UP, true);
            this.filterRowAverage();
            this.reportResultsForFilter(rown, FilterType.FILTER_AVERAGE, true);
            this.filterRowPaeth();
            this.reportResultsForFilter(rown, FilterType.FILTER_PAETH, true);
        }
        FilterType filterType = this.filterStrat.gimmeFilterType(rown, true);
        this.rowbfilter[0] = (byte)filterType.val;
        switch (filterType) {
            case FILTER_NONE: {
                this.filterRowNone();
                break;
            }
            case FILTER_SUB: {
                this.filterRowSub();
                break;
            }
            case FILTER_UP: {
                this.filterRowUp();
                break;
            }
            case FILTER_AVERAGE: {
                this.filterRowAverage();
                break;
            }
            case FILTER_PAETH: {
                this.filterRowPaeth();
                break;
            }
            default: {
                throw new PngjUnsupportedException("Filter type " + (Object)((Object)filterType) + " not implemented");
            }
        }
        this.reportResultsForFilter(rown, filterType, false);
    }

    private void prepareEncodeRow(int rown) {
        if (this.datStream == null) {
            this.init();
        }
        ++this.rowNum;
        if (rown >= 0 && this.rowNum != rown) {
            throw new PngjOutputException("rows must be written in order: expected:" + this.rowNum + " passed:" + rown);
        }
        byte[] tmp = this.rowb;
        this.rowb = this.rowbprev;
        this.rowbprev = tmp;
    }

    private void filterAndSend(int rown) {
        this.filterRow(rown);
        try {
            this.datStreamDeflated.write(this.rowbfilter, 0, this.imgInfo.bytesPerRow + 1);
        }
        catch (IOException e) {
            throw new PngjOutputException(e);
        }
    }

    protected void filterRowAverage() {
        int imax = this.imgInfo.bytesPerRow;
        int j = 1 - this.imgInfo.bytesPixel;
        int i = 1;
        while (i <= imax) {
            this.rowbfilter[i] = (byte)(this.rowb[i] - ((this.rowbprev[i] & 0xFF) + (j > 0 ? this.rowb[j] & 0xFF : 0)) / 2);
            ++i;
            ++j;
        }
    }

    protected void filterRowNone() {
        for (int i = 1; i <= this.imgInfo.bytesPerRow; ++i) {
            this.rowbfilter[i] = this.rowb[i];
        }
    }

    protected void filterRowPaeth() {
        int imax = this.imgInfo.bytesPerRow;
        int j = 1 - this.imgInfo.bytesPixel;
        int i = 1;
        while (i <= imax) {
            this.rowbfilter[i] = (byte)PngHelperInternal.filterRowPaeth(this.rowb[i], j > 0 ? this.rowb[j] & 0xFF : 0, this.rowbprev[i] & 0xFF, j > 0 ? this.rowbprev[j] & 0xFF : 0);
            ++i;
            ++j;
        }
    }

    protected void filterRowSub() {
        int i;
        for (i = 1; i <= this.imgInfo.bytesPixel; ++i) {
            this.rowbfilter[i] = this.rowb[i];
        }
        int j = 1;
        i = this.imgInfo.bytesPixel + 1;
        while (i <= this.imgInfo.bytesPerRow) {
            this.rowbfilter[i] = (byte)PngHelperInternal.filterRowSub(this.rowb[i], this.rowb[j]);
            ++i;
            ++j;
        }
    }

    protected void filterRowUp() {
        for (int i = 1; i <= this.imgInfo.bytesPerRow; ++i) {
            this.rowbfilter[i] = (byte)PngHelperInternal.filterRowUp(this.rowb[i], this.rowbprev[i]);
        }
    }

    protected int sumRowbfilter() {
        int s = 0;
        for (int i = 1; i <= this.imgInfo.bytesPerRow; ++i) {
            if (this.rowbfilter[i] < 0) {
                s -= this.rowbfilter[i];
                continue;
            }
            s += this.rowbfilter[i];
        }
        return s;
    }

    private void copyChunks(PngReader reader, int copy_mask, boolean onlyAfterIdat) {
        boolean idatDone;
        boolean bl = idatDone = this.currentChunkGroup >= 4;
        if (onlyAfterIdat && reader.getCurrentChunkGroup() < 6) {
            throw new PngjExceptionInternal("tried to copy last chunks but reader has not ended");
        }
        for (PngChunk chunk : reader.getChunksList().getChunks()) {
            int group = chunk.getChunkGroup();
            if (group < 4 && idatDone) continue;
            boolean copy = false;
            if (chunk.crit) {
                if (chunk.id.equals("PLTE")) {
                    if (this.imgInfo.indexed && ChunkHelper.maskMatch(copy_mask, 1)) {
                        copy = true;
                    }
                    if (!this.imgInfo.greyscale && ChunkHelper.maskMatch(copy_mask, 8)) {
                        copy = true;
                    }
                }
            } else {
                boolean text = chunk instanceof PngChunkTextVar;
                boolean safe = chunk.safe;
                if (ChunkHelper.maskMatch(copy_mask, 8)) {
                    copy = true;
                }
                if (safe && ChunkHelper.maskMatch(copy_mask, 4)) {
                    copy = true;
                }
                if (chunk.id.equals("tRNS") && ChunkHelper.maskMatch(copy_mask, 64)) {
                    copy = true;
                }
                if (chunk.id.equals("pHYs") && ChunkHelper.maskMatch(copy_mask, 16)) {
                    copy = true;
                }
                if (text && ChunkHelper.maskMatch(copy_mask, 32)) {
                    copy = true;
                }
                if (!(!ChunkHelper.maskMatch(copy_mask, 256) || ChunkHelper.isUnknown(chunk) || text || chunk.id.equals("hIST") || chunk.id.equals("tIME"))) {
                    copy = true;
                }
                if (chunk instanceof PngChunkSkipped) {
                    copy = false;
                }
            }
            if (!copy) continue;
            this.chunksList.queue(PngChunk.cloneChunk(chunk, this.imgInfo));
        }
    }

    public void copyChunksFirst(PngReader reader, int copy_mask) {
        this.copyChunks(reader, copy_mask, false);
    }

    public void copyChunksLast(PngReader reader, int copy_mask) {
        this.copyChunks(reader, copy_mask, true);
    }

    public double computeCompressionRatio() {
        if (this.currentChunkGroup < 6) {
            throw new PngjOutputException("must be called after end()");
        }
        double compressed = this.datStream.getCountFlushed();
        double raw = (this.imgInfo.bytesPerRow + 1) * this.imgInfo.rows;
        return compressed / raw;
    }

    public void end() {
        if (this.rowNum != this.imgInfo.rows - 1) {
            throw new PngjOutputException("all rows have not been written");
        }
        try {
            this.datStreamDeflated.finish();
            this.datStream.flush();
            this.writeLastChunks();
            this.writeEndChunk();
            if (this.shouldCloseStream) {
                this.os.close();
            }
        }
        catch (IOException e) {
            throw new PngjOutputException(e);
        }
    }

    public ChunksListForWrite getChunksList() {
        return this.chunksList;
    }

    public String getFilename() {
        return this.filename;
    }

    public PngMetadata getMetadata() {
        return this.metadata;
    }

    public void setCompLevel(int compLevel) {
        if (compLevel < 0 || compLevel > 9) {
            throw new PngjOutputException("Compression level invalid (" + compLevel + ") Must be 0..9");
        }
        this.compLevel = compLevel;
    }

    public void setFilterType(FilterType filterType) {
        this.filterStrat = new FilterWriteStrategy(this.imgInfo, filterType);
    }

    public void setIdatMaxSize(int idatMaxSize) {
        this.idatMaxSize = idatMaxSize;
    }

    public void setShouldCloseStream(boolean shouldCloseStream) {
        this.shouldCloseStream = shouldCloseStream;
    }

    public void setDeflaterStrategy(int deflaterStrategy) {
        this.deflaterStrategy = deflaterStrategy;
    }

    public void writeRow(ImageLine imgline) {
        this.writeRow(imgline.scanline, imgline.getRown());
    }

    public void writeRow(ImageLine imgline, int rownumber) {
        this.unpackedMode = imgline.samplesUnpacked;
        if (imgline.sampleType == ImageLine.SampleType.INT) {
            this.writeRowInt(imgline.scanline, rownumber);
        } else {
            this.writeRowByte(imgline.scanlineb, rownumber);
        }
    }

    public void writeRow(int[] newrow) {
        this.writeRow(newrow, -1);
    }

    public void writeRow(int[] newrow, int rown) {
        this.writeRowInt(newrow, rown);
    }

    public void writeRowInt(int[] newrow, int rown) {
        this.prepareEncodeRow(rown);
        this.encodeRowFromInt(newrow);
        this.filterAndSend(rown);
    }

    public void writeRowByte(byte[] newrow, int rown) {
        this.prepareEncodeRow(rown);
        this.encodeRowFromByte(newrow);
        this.filterAndSend(rown);
    }

    public void writeRowsInt(int[][] image) {
        for (int i = 0; i < this.imgInfo.rows; ++i) {
            this.writeRowInt(image[i], i);
        }
    }

    public void writeRowsByte(byte[][] image) {
        for (int i = 0; i < this.imgInfo.rows; ++i) {
            this.writeRowByte(image[i], i);
        }
    }

    public boolean isUnpackedMode() {
        return this.unpackedMode;
    }

    public void setUseUnPackedMode(boolean useUnpackedMode) {
        this.unpackedMode = useUnpackedMode;
    }
}

