/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.ResourceIdBlock;
import buildcraft.core.lib.inventory.filters.IStackFilter;
import buildcraft.core.lib.utils.IBlockFilter;
import buildcraft.robotics.ai.AIRobotFetchAndEquipItemStack;
import buildcraft.robotics.ai.AIRobotGotoSleep;
import buildcraft.robotics.ai.AIRobotSearchAndGotoBlock;
import buildcraft.robotics.ai.AIRobotStripesHandler;
import buildcraft.robotics.boards.BCBoardNBT;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BoardRobotStripes
extends RedstoneBoardRobot {
    private BlockIndex blockFound;

    public BoardRobotStripes(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BCBoardNBT.REGISTRY.get("stripes");
    }

    @Override
    public void update() {
        if (this.robot.func_70694_bm() == null) {
            this.startDelegateAI(new AIRobotFetchAndEquipItemStack(this.robot, new IStackFilter(){

                @Override
                public boolean matches(ItemStack stack) {
                    return stack != null;
                }
            }));
        } else {
            this.startDelegateAI(new AIRobotSearchAndGotoBlock(this.robot, true, new IBlockFilter(){

                @Override
                public boolean matches(World world, int x, int y, int z) {
                    return world.func_147439_a(x, y, z).isAir((IBlockAccess)world, x, y, z) && !BoardRobotStripes.this.robot.getRegistry().isTaken(new ResourceIdBlock(x, y, z));
                }
            }));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchAndGotoBlock) {
            if (ai.success()) {
                this.blockFound = ((AIRobotSearchAndGotoBlock)ai).getBlockFound();
                this.startDelegateAI(new AIRobotStripesHandler(this.robot, this.blockFound));
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotFetchAndEquipItemStack) {
            if (!ai.success()) {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotStripesHandler) {
            this.releaseBlockFound();
        }
    }

    private void releaseBlockFound() {
        if (this.blockFound != null) {
            this.robot.getRegistry().release(new ResourceIdBlock(this.blockFound));
            this.blockFound = null;
        }
    }

    @Override
    public void end() {
        if (this.blockFound != null) {
            this.robot.getRegistry().release(new ResourceIdBlock(this.blockFound));
        }
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockFound != null) {
            NBTTagCompound sub = new NBTTagCompound();
            this.blockFound.writeTo(sub);
            nbt.func_74782_a("blockFound", (NBTBase)sub);
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.func_74764_b("blockFound")) {
            this.blockFound = new BlockIndex(nbt.func_74775_l("blockFound"));
        }
    }
}

