/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.render;

import buildcraft.core.lib.fluids.Tank;
import buildcraft.core.lib.render.FluidRenderer;
import buildcraft.core.lib.render.IInventoryRenderer;
import buildcraft.core.lib.render.RenderUtils;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.factory.TileRefinery;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderRefinery
extends TileEntitySpecialRenderer
implements IInventoryRenderer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftfactory:textures/blocks/refineryBlock/refinery.png");
    private static final float pixel = 0.0625f;
    private final ModelRenderer tank;
    private final ModelRenderer[] magnet = new ModelRenderer[4];
    private final ModelBase model = new ModelBase(){};

    public RenderRefinery() {
        this.tank = new ModelRenderer(this.model, 0, 0);
        this.tank.func_78789_a(-4.0f, -8.0f, -4.0f, 8, 16, 8);
        this.tank.field_78800_c = 8.0f;
        this.tank.field_78797_d = 8.0f;
        this.tank.field_78798_e = 8.0f;
        for (int i = 0; i < 4; ++i) {
            this.magnet[i] = new ModelRenderer(this.model, 32, i * 8);
            this.magnet[i].func_78789_a(0.0f, -8.0f, -8.0f, 8, 4, 4);
            this.magnet[i].field_78800_c = 8.0f;
            this.magnet[i].field_78797_d = 8.0f;
            this.magnet[i].field_78798_e = 8.0f;
        }
        this.field_147501_a = TileEntityRendererDispatcher.field_147556_a;
    }

    public RenderRefinery(String baseTexture) {
        this();
    }

    @Override
    public void inventoryRender(double x, double y, double z, float f, float f1) {
        this.render(null, x, y, z);
    }

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float f) {
        this.render((TileRefinery)CoreProxy.proxy.getServerTile(tileentity), x, y, z);
    }

    private void render(TileRefinery tile, double x, double y, double z) {
        float trans2;
        float trans1;
        FluidStack liquid1 = null;
        FluidStack liquid2 = null;
        FluidStack liquidResult = null;
        int color1 = 0xFFFFFF;
        int color2 = 0xFFFFFF;
        int colorResult = 0xFFFFFF;
        float anim = 0.0f;
        int angle = 0;
        ModelRenderer theMagnet = this.magnet[0];
        if (tile != null) {
            if (tile.tanks[0].getFluid() != null) {
                liquid1 = tile.tanks[0].getFluid();
                color1 = tile.tanks[0].colorRenderCache;
            }
            if (tile.tanks[1].getFluid() != null) {
                liquid2 = tile.tanks[1].getFluid();
                color2 = tile.tanks[1].colorRenderCache;
            }
            if (tile.result.getFluid() != null) {
                liquidResult = tile.result.getFluid();
                colorResult = tile.result.colorRenderCache;
            }
            anim = tile.getAnimationStage();
            angle = 0;
            switch (tile.func_145831_w().func_72805_g(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e)) {
                case 2: {
                    angle = 90;
                    break;
                }
                case 3: {
                    angle = 270;
                    break;
                }
                case 4: {
                    angle = 180;
                    break;
                }
                case 5: {
                    angle = 0;
                }
            }
            theMagnet = tile.animationSpeed <= 1.0f ? this.magnet[0] : ((double)tile.animationSpeed <= 2.5 ? this.magnet[1] : ((double)tile.animationSpeed <= 4.5 ? this.magnet[2] : this.magnet[3]));
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)0.99f, (float)0.99f, (float)0.99f);
        GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(TEXTURE);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glTranslatef((float)-0.25f, (float)0.0f, (float)-0.25f);
        this.tank.func_78785_a(0.0625f);
        GL11.glTranslatef((float)0.25f, (float)0.0f, (float)0.25f);
        GL11.glTranslatef((float)-0.25f, (float)0.0f, (float)0.25f);
        this.tank.func_78785_a(0.0625f);
        GL11.glTranslatef((float)0.25f, (float)0.0f, (float)-0.25f);
        GL11.glTranslatef((float)0.25f, (float)0.0f, (float)0.0f);
        this.tank.func_78785_a(0.0625f);
        GL11.glTranslatef((float)-0.25f, (float)0.0f, (float)0.0f);
        GL11.glPopMatrix();
        if (anim <= 100.0f) {
            trans1 = 0.75f * anim / 100.0f;
            trans2 = 0.0f;
        } else if (anim <= 200.0f) {
            trans1 = 0.75f - 0.75f * (anim - 100.0f) / 100.0f;
            trans2 = 0.75f * (anim - 100.0f) / 100.0f;
        } else {
            trans1 = 0.75f * (anim - 200.0f) / 100.0f;
            trans2 = 0.75f - 0.75f * (anim - 200.0f) / 100.0f;
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)0.99f, (float)0.99f, (float)0.99f);
        GL11.glTranslatef((float)-0.51f, (float)(trans1 - 0.5f), (float)-0.5f);
        theMagnet.func_78785_a(0.0625f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.99f, (float)0.99f, (float)0.99f);
        GL11.glTranslatef((float)-0.51f, (float)(trans2 - 0.5f), (float)0.25f);
        theMagnet.func_78785_a(0.0625f);
        GL11.glPopMatrix();
        if (tile != null) {
            int[] list3;
            int[] list2;
            int[] list1;
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GL11.glScalef((float)0.5f, (float)1.0f, (float)0.5f);
            this.func_147499_a(TextureMap.field_110575_b);
            if (liquid1 != null && liquid1.amount > 0 && (list1 = FluidRenderer.getFluidDisplayLists(liquid1, tile.func_145831_w(), false)) != null) {
                RenderUtils.setGLColorFromInt(color1);
                GL11.glCallList((int)list1[this.getDisplayListIndex(tile.tanks[0])]);
            }
            if (liquid2 != null && liquid2.amount > 0 && (list2 = FluidRenderer.getFluidDisplayLists(liquid2, tile.func_145831_w(), false)) != null) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.0f);
                RenderUtils.setGLColorFromInt(color2);
                GL11.glCallList((int)list2[this.getDisplayListIndex(tile.tanks[1])]);
                GL11.glPopMatrix();
            }
            if (liquidResult != null && liquidResult.amount > 0 && (list3 = FluidRenderer.getFluidDisplayLists(liquidResult, tile.func_145831_w(), false)) != null) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)1.0f, (float)0.0f, (float)0.5f);
                RenderUtils.setGLColorFromInt(colorResult);
                GL11.glCallList((int)list3[this.getDisplayListIndex(tile.result)]);
                GL11.glPopMatrix();
            }
            GL11.glPopAttrib();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private int getDisplayListIndex(Tank tank) {
        return Math.min((int)((float)tank.getFluidAmount() / (float)tank.getCapacity() * 99.0f), 99);
    }
}

