/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.block;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.IInvSlot;
import buildcraft.api.events.BlockInteractionEvent;
import buildcraft.api.tiles.IHasWork;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.lib.block.IComparatorInventory;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.inventory.InventoryIterator;
import buildcraft.core.lib.utils.ResourceUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.lib.utils.XorShift128Random;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockBuildCraft
extends BlockContainer {
    protected static boolean keepInventory = false;
    private static final int[][] SIDE_TEXTURING_LOCATIONS = new int[][]{{2, 3, 5, 4}, {3, 2, 4, 5}, {4, 5, 2, 3}, {5, 4, 3, 2}};
    @SideOnly(value=Side.CLIENT)
    public IIcon[][] icons;
    protected final XorShift128Random rand = new XorShift128Random();
    protected int renderPass;
    protected int maxPasses = 1;
    private boolean rotatable = false;
    private boolean alphaPass = false;

    protected BlockBuildCraft(Material material) {
        this(material, BCCreativeTab.get("main"));
    }

    protected BlockBuildCraft(Material material, CreativeTabs creativeTab) {
        super(material);
        this.func_149647_a(creativeTab);
        this.func_149711_c(5.0f);
    }

    public boolean hasAlphaPass() {
        return this.alphaPass;
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
    }

    public void setAlphaPass(boolean alphaPass) {
        this.alphaPass = alphaPass;
    }

    public void setPassCount(int maxPasses) {
        this.maxPasses = maxPasses;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        super.func_149689_a(world, x, y, z, entity, stack);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (this.isRotatable()) {
            ForgeDirection orientation = Utils.get2dOrientation(entity);
            world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) & 8 | orientation.getOpposite().ordinal(), 1);
        }
        if (tile instanceof TileBuildCraft) {
            ((TileBuildCraft)tile).onBlockPlacedBy(entity, stack);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        BlockInteractionEvent event = new BlockInteractionEvent(entityplayer, (Block)this);
        FMLCommonHandler.instance().bus().post((Event)event);
        return event.isCanceled();
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int par6) {
        Utils.preDestroyBlock(world, x, y, z);
        super.func_149749_a(world, x, y, z, block, par6);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IHasWork && ((IHasWork)tile).hasWork()) {
            return super.getLightValue(world, x, y, z) + 8;
        }
        return super.getLightValue(world, x, y, z);
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        if (this.isRotatable()) {
            int meta = world.func_72805_g(x, y, z);
            switch (ForgeDirection.getOrientation((int)meta)) {
                case WEST: {
                    world.func_72921_c(x, y, z, ForgeDirection.SOUTH.ordinal(), 3);
                    break;
                }
                case EAST: {
                    world.func_72921_c(x, y, z, ForgeDirection.NORTH.ordinal(), 3);
                    break;
                }
                case NORTH: {
                    world.func_72921_c(x, y, z, ForgeDirection.WEST.ordinal(), 3);
                    break;
                }
                default: {
                    world.func_72921_c(x, y, z, ForgeDirection.EAST.ordinal(), 3);
                }
            }
            world.func_147471_g(x, y, z);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconAbsolute(IBlockAccess access, int x, int y, int z, int side, int metadata) {
        return this.getIconAbsolute(side, metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconAbsolute(int side, int metadata) {
        return this.icons[metadata] == null ? this.icons[0][side] : this.icons[metadata][side];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess access, int x, int y, int z, int side) {
        IIcon icon;
        int metadata = access.func_72805_g(x, y, z);
        if (this.isRotatable()) {
            if (side < 2) {
                icon = this.getIconAbsolute(access, x, y, z, side, metadata & 8);
            } else {
                int front = metadata >= 2 && metadata <= 5 ? metadata : 3;
                icon = this.getIconAbsolute(access, x, y, z, SIDE_TEXTURING_LOCATIONS[(front - 2) % 4][(side - 2) % 4], metadata & 8);
            }
        } else {
            icon = this.getIconAbsolute(access, x, y, z, side, metadata);
        }
        return icon != null ? icon : BuildCraftCore.transparentTexture;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (this.isRotatable()) {
            if (side < 2) {
                return this.getIconAbsolute(side, metadata & 8);
            }
            int front = this.getFrontSide(metadata);
            return this.getIconAbsolute(SIDE_TEXTURING_LOCATIONS[(front - 2) % 4][(side - 2) % 4], metadata & 8);
        }
        return this.getIconAbsolute(side, metadata);
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerIconsForMeta(int meta, String blockName, IIconRegister register) {
        this.icons[meta] = new IIcon[6];
        String name = ResourceUtils.getObjectPrefix(blockName);
        this.icons[meta][0] = ResourceUtils.getIconPriority(register, name, new String[]{"bottom", "topbottom", "default"});
        this.icons[meta][1] = ResourceUtils.getIconPriority(register, name, new String[]{"top", "topbottom", "default"});
        this.icons[meta][2] = ResourceUtils.getIconPriority(register, name, new String[]{"front", "frontback", "side", "default"});
        this.icons[meta][3] = ResourceUtils.getIconPriority(register, name, new String[]{"back", "frontback", "side", "default"});
        this.icons[meta][4] = ResourceUtils.getIconPriority(register, name, new String[]{"left", "leftright", "side", "default"});
        this.icons[meta][5] = ResourceUtils.getIconPriority(register, name, new String[]{"right", "leftright", "side", "default"});
    }

    @SideOnly(value=Side.CLIENT)
    public String[] getIconBlockNames() {
        return new String[]{Block.field_149771_c.func_148750_c((Object)this)};
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.icons = new IIcon[16][];
        String[] iconBlockNames = this.getIconBlockNames();
        for (int i = 0; i < iconBlockNames.length; ++i) {
            this.registerIconsForMeta(i, iconBlockNames[i], register);
        }
    }

    public boolean canRenderInPassBC(int pass) {
        if (pass >= this.maxPasses) {
            this.renderPass = 0;
            return false;
        }
        this.renderPass = pass;
        return true;
    }

    public boolean canRenderInPass(int pass) {
        if (this.alphaPass) {
            this.renderPass = pass;
        }
        return pass == 0 || this.alphaPass;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return this.hasAlphaPass() ? 1 : 0;
    }

    public int func_149645_b() {
        return this.maxPasses > 1 || this.isRotatable() ? BuildCraftCore.complexBlockModel : 0;
    }

    public int getCurrentRenderPass() {
        return this.renderPass;
    }

    public int getFrontSide(int meta) {
        if (!this.isRotatable()) {
            return -1;
        }
        return meta >= 2 && meta <= 5 ? meta : 3;
    }

    public boolean func_149740_M() {
        return this instanceof IComparatorInventory;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IInventory) {
            int count = 0;
            int countNonEmpty = 0;
            float power = 0.0f;
            for (IInvSlot slot : InventoryIterator.getIterable((IInventory)tile, ForgeDirection.getOrientation((int)side))) {
                if (!((IComparatorInventory)((Object)this)).doesSlotCountComparator(tile, slot.getIndex(), slot.getStackInSlot())) continue;
                ++count;
                if (slot.getStackInSlot() == null) continue;
                ++countNonEmpty;
                power += (float)slot.getStackInSlot().field_77994_a / (float)Math.min(((IInventory)tile).func_70297_j_(), slot.getStackInSlot().func_77976_d());
            }
            return MathHelper.func_76141_d((float)((power /= (float)count) * 14.0f)) + (countNonEmpty > 0 ? 1 : 0);
        }
        return 0;
    }
}

